/* GDTEIDT */
#include "main.h"

void gdt_init(void)
{
	struct sdesc *sd = (struct sdesc *) GDT_ADDR;
	int i;

	for (i = 0; i <= GDT_LIMIT / 8; i++) {
		gdt_set(sd + i, 0, 0, 0);
	}
	gdt_set(sd + 1, 0x00000000, 0xffffffff, RWDATA);
	gdt_set(sd + 2, MAIN_ADDR, MAIN_LIMIT, RXCODE);
	load_gdtr(GDT_LIMIT, GDT_ADDR);
	return;
}

void idt_init(void)
{
	struct gdesc *gd = (struct gdesc *) IDT_ADDR;
	int i;

	for (i = 0; i <= IDT_LIMIT / 8; i++) {
		idt_set(gd + i, 0, 0, 0);
	}
	load_idtr(IDT_LIMIT, IDT_ADDR);
	idt_set(gd + 0x07, (int) int_07asm, 2 * 8, INT);		/* FPU */
	idt_set(gd + 0x0c, (int) int_0casm, 2 * 8, INT);		/* X^bNO */
	idt_set(gd + 0x0d, (int) int_0dasm, 2 * 8, INT);		/* ʕیO */
	idt_set(gd + 0x20, (int) int_20asm, 2 * 8, INT);		/* PIT */
	idt_set(gd + 0x21, (int) int_21asm, 2 * 8, INT);		/* PS/2L[{[h */
	idt_set(gd + 0x27, (int) int_27asm, 2 * 8, INT);		/* }X^PIC̕sS荞 */
	idt_set(gd + 0x2c, (int) int_2casm, 2 * 8, INT);		/* PS/2}EX */
	idt_set(gd + 0x30, (int)   api_asm, 2 * 8, INT + 0x60);	/* API */
	return;
}

void gdt_set(struct sdesc *sd, int base, unsigned int limit, int ar)
{
	if (limit > 0xfffff) {
		ar |= 0x8000;	/* G-bit */
		limit /= 0x1000;
	}
	sd->limit_low = limit & 0xffff;
	sd->base_low = base & 0xffff;
	sd->base_mid = (base >> 16) & 0xff;
	sd->access_right = ar & 0xff;
	sd->limit_high = ((limit >> 16) & 0x0f) | ((ar >> 8) & 0xf0);
	sd->base_high = (base >> 24) &0xff;
	return;
}

void idt_set(struct gdesc *gd, int offset, int selector, int ar)
{
	gd->offset_low = offset & 0xffff;
	gd->selector = selector;
	gd->dw_count = (ar >> 8) & 0xff;
	gd->access_right = ar & 0xff;
	gd->offset_high = (offset >> 16) & 0xffff;
	return;
}
