; ẘ֐Q

[format "WCOFF"]	; WCOFF`ŃIuWFNgt@C𐶐
[bits 32]
[instrset "i486p"]
[file "low.nas"]

		global	_io_hlt, _io_cli, _io_sti, _io_stihlt
		global	_io_in8, _io_in16, _io_in32
		global	_io_out8, _io_out16, _io_out32
		global	_io_load_eflags, _io_store_eflags
		global	_load_gdtr, _load_idtr, _load_cr0, _store_cr0
		global	_load_tr, _farjmp, _farcall, _clts, _fnsave, _frstor
		global	_runapp, _endapp
		global	_int_07asm, _int_0casm, _int_0dasm
		global	_int_20asm, _int_21asm, _int_27asm, _int_2casm
		global	_api_asm
		global	_memory_test0
		extern	_int_07, _int_0c, _int_0d
		extern	_int_20, _int_21, _int_27, _int_2c
		extern	_api

[section .text]
_io_hlt:
		hlt
		ret

_io_cli:
		cli
		ret

_io_sti:
		sti
		ret

_io_stihlt:
		sti
		hlt
		ret

_io_in8:
		mov		edx, [esp + 4]	; port
		mov		eax, 0
		in		al, dx
		ret

_io_in16:
		mov		edx, [esp + 4]	; port
		mov		eax, 0
		in		ax, dx
		ret

_io_in32:
		mov		edx, [esp + 4]	; port
		in		eax, dx
		ret

_io_out8:
		mov		edx, [esp + 4]	; port
		mov		al, [esp + 8]	; data
		out		dx, al
		ret

_io_out16:
		mov		edx, [esp + 4]	; port
		mov		ax, [esp + 8]	; data
		out		dx, ax
		ret

_io_out32:
		mov		edx, [esp + 4]	; port
		mov		eax, [esp + 8]	; data
		out		dx, eax
		ret

_io_load_eflags:
		pushfd		; push eflags
		pop		eax
		ret

_io_store_eflags:
		mov		eax, [esp + 4]	; eflags
		push	eax
		popfd					; pop eflags
		ret

_load_gdtr:
		mov		eax, [esp + 4]	; limit
		mov		[esp + 6], ax	; llaaaa(l limit, a addr)
		lgdt	[esp + 6]
		ret

_load_idtr:
		mov		eax, [esp + 4]	; limit
		mov		[esp + 6], ax	; llaaaa(l limit, a addr)
		lidt	[esp + 6]
		ret

_load_cr0:
		mov		eax, cr0
		ret

_store_cr0:
		mov		eax, [esp + 4]	; cr0
		mov		cr0, eax
		ret

_load_tr:
		ltr		[esp + 4]	; tr
		ret

_farjmp:
		jmp		far [esp + 4]	; eip, cs
		ret

_farcall:
		call	far [esp + 4]	; eip, cs
		ret

_clts:
		clts
		ret

_fnsave:
		mov		eax, [esp + 4]	; addr
		fnsave	[eax]
		ret

_frstor:
		mov		eax, [esp + 4]	; addr
		frstor	[eax]
		ret

_runapp:
		pushad
		mov		eax, [esp + 36]	; eip
		mov		ecx, [esp + 40]	; cs
		mov		ebx, [esp + 44]	; ds/ss
		mov		edx, [esp + 48]	; esp
		mov		ebp, [esp + 52]	; tss.esp0
		mov		[ebp], esp		; OSpESP
		mov		[ebp + 4], ss	; OSpSS
		mov		es, bx
		mov		ds, bx
		mov		fs, bx
		mov		gs, bx

; RETFŃAvP[V
		or		ecx, 3
		or		ebx, 3
		push	ebx
		push	edx
		push	ecx
		push	eax
		retf

_endapp:
		mov		esp, [eax]
		mov		dword [eax + 4], 0
		popad
		ret

_int_07asm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_07
		cmp		eax, 0
		jne		_endapp
		pop		eax
		popad
		pop		ds
		pop		es
		iretd

_int_0casm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_0c
		cmp		eax, 0
		jne		_endapp
		pop		eax
		popad
		pop		ds
		pop		es
		add		esp, 4		; G[R[ĥĂ
		iretd

_int_0dasm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_0d
		cmp		eax, 0
		jne		_endapp
		pop		eax
		popad
		pop		ds
		pop		es
		add		esp, 4
		iretd

_int_20asm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_20
		pop		eax
		popad
		pop		ds
		pop		es
		iretd

_int_21asm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_21
		pop		eax
		popad
		pop		ds
		pop		es
		iretd

_int_27asm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_27
		pop		eax
		popad
		pop		ds
		pop		es
		iretd

_int_2casm:
		push	es
		push	ds
		pushad
		mov		eax, esp
		push	eax
		mov		ax, ss
		mov		ds, ax
		mov		es, ax
		call	_int_2c
		pop		eax
		popad
		pop		ds
		pop		es
		iretd

_api_asm:
		sti
		push	ds
		push	es
		pushad
		pushad
		mov		ax, ss
		mov		ds, ax	; OSp
		mov		es, ax
		call	_api
		cmp		eax, 0
		jne		_endapp
		add		esp, 32
		popad
		pop		es
		pop		ds
		iretd

_memory_test0:
		push	edi
		push	esi
		push	ebx
		mov		esi, 0xaa55aa55
		mov		edi, 0x55aa55aa
		mov		eax, [esp + 16]	; start

mt0_loop:
		mov		ebx, eax
		add		ebx, 0x0ffc
		mov		edx, [ebx]				; ̃f[^L
		mov		[ebx], esi				; p^[A
		xor		dword [ebx], 0xffffffff	; p^[B
		cmp		edi, [ebx]				; ݂mF
		jne		mt0_fin
		xor		dword [ebx], 0xffffffff	; p^[A
		cmp		esi, [ebx]				; ݂mF
		jne		mt0_fin
		mov		[ebx], edx				; f[^߂
		add		eax, 0x1000
		cmp		eax, [esp + 20]			; end
		jbe		mt0_loop
		pop		ebx
		pop		esi
		pop		edi
		ret

mt0_fin:
		mov		[ebx], edx
		pop		ebx
		pop		esi
		pop		edi
		ret
