/* VXe̒S */
#include "main.h"
#include <stdio.h>
struct fifo fifo;
struct mouse mouse;
int *fat;			/* menu.c  extern */
extern struct sheets *shts;
extern struct tasks *tss;

void HariMain(void)
{
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	struct fifo fkey;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	static unsigned char tkey[0x80] = {
		  0,   0, '1',  '2', '3', '4', '5', '6', '7', '8', '9', '0',  '-',  '^', 0x08,   0,
		'Q', 'W', 'E',  'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a,    0,  'A', 'S',
		'D', 'F', 'G',  'H', 'J', 'K', 'L', ';', ':',   0,   0, ']',  'Z',  'X',  'C', 'V',
		'B', 'N', 'M',  ',', '.', '/',   0, '*',   0, ' ',   0,   0,    0,    0,    0,   0,
		  0,   0,   0,    0,   0,   0,   0, '7', '8', '9', '-', '4',  '5',  '6',  '+', '1',
		'2', '3', '0',  '.',   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,    0,   0,
		  0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,    0,   0,
		  0,   0,   0, 0x5c,   0,   0,   0,   0,   0,   0,   0,   0,    0, 0x5c,    0,   0
	};
	static unsigned char tkey1[0x80] = {
		  0,   0, '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~',  '=', '~', 0x08,   0,
		'Q', 'W', 'E',  'R', 'T', 'Y', 'U', 'I',  'O', 'P', '@', '[', 0x0a,   0,  'A', 'S',
		'D', 'F', 'G',  'H', 'J', 'K', 'L', '+',  '*',   0,   0, ']',  'Z', 'X',  'C', 'V',
		'B', 'N', 'M',  '<', '>', '?',   0, '*',    0, ' ',   0,   0,    0,   0,    0,   0,
		  0,   0,   0,    0,   0,   0,   0, '7',  '8', '9', '-', '4',  '5', '6',  '+', '1',
		'2', '3', '0',  '.',   0,   0,   0,   0,    0,   0,   0,   0,    0,   0,    0,   0,
		  0,   0,   0,    0,   0,   0,   0,   0,    0,   0,   0,   0,    0,   0,    0,   0,
		  0,   0,   0,  '-',   0,   0,   0,   0,    0,   0,   0,   0,    0, '-',    0,   0
	};
	struct task *tsys, *task;
	struct sheet *sback, *smcur, *skey, *sht = 0, *sht2;
	unsigned char *bback, *bmcur, *nihongo, s[14];
	int bfifo[96], bfkey[32], x, y, i, j;
	int mmx = -1, mmy = -1, mmx2 = 0, nmx = -1, nmy = 0, nwx = 0x7fffffff, nwy = 0;
	int kshf = 0, kleds = (binfo->leds >> 4) & 7, kwait = -1;
	struct file *file;
	extern unsigned char english[4096];
	struct clock clock;
	struct timer *tclock;
	struct menu mstart, mapp;

	/* n[hEFȀiVrAȃ^C~OlĂ̏ԁj */
	gdt_init();
	idt_init();
	pic_init();
	io_sti();
	fifo_init(&fifo, bfifo, 96, 0);
	fifo_init(&fkey, bfkey, 32, 0);
	pit_init();
	io_out8(0x0021, 0xf8);	/* 11111000 */
	io_out8(0x00a1, 0xef);	/* 11101111 */
	keyboard_init(&fifo);
	mouse_enable(&mouse, &fifo);

	mem->allsize = memory_test(0x00400000, 0xbfffffff);
	memory_init(mem);
	memory_free(mem, 0x00001000, 0x0009e000);
	memory_free(mem, 0x00400000, mem->allsize - 0x00400000);

	timer_init();

	tclock = timer_alloc();
	timer_set(tclock, &fifo);
	timer_sett(tclock, 0, 1);

	/* ^XN̏ */
	tsys = task_init();
	fifo.t = tsys;
	fkey.t = tsys;

	/* ʂ̏ */
	palette_init();
	sheet_init();

	/* nihongo.fnt̓ǂݍ */
	fat = (int *) memory_alloc(mem, 11520);
	fat_read(fat, (unsigned char *) (DISK_ADDR + 0x0200));
	file = file_search("nihongo.fnt");
	if (file != 0) {
		nihongo = file_read(fat, file->caddr, file->size);
		for (i = 0; i < 512; i++) {
			nihongo[i] = english[i];
		}
	} else {
		nihongo = (unsigned char *) memory_alloc(mem, 145472);
		for (i = 0; i < 4096; i++) {
			nihongo[i] = english[i];
		}
		for (; i < 145472; i++) {
			nihongo[i] = 0xff;	/* Ŗߐs */
		}
	}
	*((int *) NIHONGO_ADDR) = (int) nihongo;

	sback = sheet_alloc();
	bback = (unsigned char *) memory_alloc(mem, binfo->scrnx * binfo->scrny);
	sheet_set(sback, bback, binfo->scrnx, binfo->scrny, -1);	/* FȂ */
	screen_init(sback, fat);
	tbar_init(sback);

	smcur = sheet_alloc();
	bmcur = (unsigned char *) memory_alloc(mem, 160);
	sheet_set(smcur, bmcur, 10, 16, 99);	/* FȂ */
	mouse.mx = (binfo->scrnx - 10) / 2;
	mouse.my = (binfo->scrny - 44) / 2;
	mcursor_init(smcur);

	sheet_slide(sback,  0,  0);
	sheet_slide(smcur, mouse.mx, mouse.my);
	sheet_updown(sback, 0);
	sheet_updown(smcur, 1);

	skey = console_open(fat);
	sheet_app(skey);
	window_on(skey);

	/* X^[gj */
	menu_init(&mstart, "TeaseOS ver.0.2");
	menu_init(&mapp, 0);

	menu_add(&mstart, "I", "\2", 0);
	menu_add(&mstart, "R\[", "\1"/* R\[֐ĂяoƂɂȂ */, 0);
	menu_add(&mstart, "t@C_", 0, 0);
	menu_add(&mstart, "AvP[V", 0, &mapp);
	menu_add(&mstart, "wv", "memo readme.txt", 0);

	menu_add(&mapp, "", "bball", 0);
	menu_add(&mapp, "Cx[_", "invader", 0);
	menu_add(&mapp, "d", "calc", 0);
	menu_add(&mapp, "", "memo", 0);
	menu_add(&mapp, "C[Wr[A", "iview", 0);
	menu_add(&mapp, "yvC[", "mplay", 0);

	/* L[{[hLEDĐݒ */
	fifo_put(&fkey, 0xed);
	fifo_put(&fkey, kleds);

	for (;;) {
		if (fifo_stat(&fkey) > 0 && kwait < 0) {
			kwait = fifo_get(&fkey);
			keyboard_ready();
			io_out8(0x0060, kwait);
		}
		io_cli();
		if (fifo_stat(&fifo) == 0) {
			if (nmx >= 0) {
				io_sti();
				sheet_slide(smcur, nmx, nmy);
				nmx = -1;
			} else if (nwx != 0x7fffffff) {
				io_sti();
				sheet_slide(sht, nwx, nwy);
				nwx = 0x7fffffff;
			} else {
				task_sleep(tsys);
				io_sti();
			}
		} else {
			i = fifo_get(&fifo);
			io_sti();

			if (skey != 0 && skey->flag == 0) {
close:
				window_off(skey);
				if (shts->top > 1) {
					skey = shts->s[shts->top - 1];
					window_on(skey);
				} else {
					skey = 0;
				}
				menu_run(sback, &mstart, mouse.mx, mouse.my, skey->height);
			}
			if (i == 1) {
				clock_get(&clock);
				sprintf(s, "%2d:%02d", clock.hour, clock.min);
				graphic_box(sback, COLOR_C6C6C6, sback->sx - 45, sback->sy - 21, sback->sx - 6, sback->sy - 6);
				graphic_puts(sback, COLOR_000000, sback->sx - 45, sback->sy - 21, s);
				sheet_refresh(sback, sback->sx - 45, sback->sy - 21, sback->sx - 5, sback->sy - 5);
				timer_sett(tclock, 100, 1);
			} else if (i == 2) {	/* ̓EBhEđI */
				i = 0;
 				goto close;
			} else if (256 <= i && i <= 511) {
				i -= 256;
				if (i < 0x80) {
					if (kshf == 0) {
						s[0] = tkey[i];
					} else {
						s[0] = tkey1[i];
					}
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z') {
					if (((kleds & 4) == 0 && kshf == 0) ||
						((kleds & 4) != 0 && kshf != 0)) {
						s[0] += 0x20;
					}
				}
				if (s[0] != 0 && skey != 0) {	/* ʏ핶AobNXy[XAEnter */
					fifo_put(&skey->task->fifo, 256 + s[0]);
				} else if (i == 0x01 && skey != 0) {	/* ESC */
					task = skey->task;
					if (task != 0 && task->tss.ss0 != 0) {
						console_puts(task->cons, "\n[UɂċI܂B", -1);
						io_cli();
						task->tss.eax = (int) &(task->tss.esp0);
						task->tss.eip = (int) endapp;
						io_sti();
						task_run(task, -1, 0);
					}
				} else if (i == 0x2a) {	/* Vtg ON */
					kshf |= 1;
				} else if (i == 0x36) {	/* EVtg ON */
					kshf |= 2;
				} else if (i == 0x3a) {	/* CapsLock */
					kleds ^= 4;
					fifo_put(&fkey, 0xed);
					fifo_put(&fkey, kleds);
				} else if (i == 0x45) {	/* NumLock */
					kleds ^= 2;
					fifo_put(&fkey, 0xed);
					fifo_put(&fkey, kleds);
				} else if (i == 0x46) {	/* ScrollLock */
					kleds ^= 1;
					fifo_put(&fkey, 0xed);
					fifo_put(&fkey, kleds);
				} else if (i == 0xaa) {	/* Vtg OFF */
					kshf &= ~1;
				} else if (i == 0xb6) {	/* EVtg OFF */
					kshf &= ~2;
				} else if (i == 0xfa) {	/* KBCf[^𐳏폈 */
					kwait = -1;
				} else if (i == 0xfe) {	/* KBCf[^s */
					keyboard_ready();
					io_out8(0x0060, kwait);
				}
			} else if (512 <= i && i <= 767) {
				i -= 512;
				if (mouse_decode(&mouse, i) != 0) {
					mouse.mx += mouse.x;
					mouse.my += mouse.y;
					if (mouse.mx < 0) { mouse.mx = 0; }
					if (mouse.my < 0) { mouse.my = 0; }
					if (mouse.mx > binfo->scrnx - 1) { mouse.mx = binfo->scrnx - 1; }
					if (mouse.my > binfo->scrny - 1) { mouse.my = binfo->scrny - 1; }
					nmx = mouse.mx;
					nmy = mouse.my;
					if ((mouse.btn & 0x01) != 0) {	/* {^NbN */
						if (mmx < 0) {
							for (j = shts->top - 1; j > 0; j--) {
								sht = shts->s[j];
								x = mouse.mx - sht->x;
								y = mouse.my - sht->y;
								if (0 <= x && x < sht->sx && 0 <= y && y < sht->sy) {
									if (sht->buf[y * sht->sx + x] != sht->cinv) {
										if ((sht->flag & SHEET_MENU) != 0) {
											break;
										}
										sheet_updown(sht, shts->top - 1);
										j = shts->top - 1;
										if (skey != sht) {	/* IEBhE̐؂ւ */
											window_off(skey);
											skey = sht;
											window_on(skey);
										}
										if (sht->sx - 39 <= x && x < sht->sx - 23 && 5 <= y && y < 19) {	/* ŏ{^ */
											sheet_updown(skey, -1);
											menu_run(sback, &mstart, mouse.mx, mouse.my, j);
											tbar_run(j, mouse.mx, mouse.my);
											i = 0;
											goto close;
										}
										if (sht->sx - 21 <= x && x < sht->sx - 5 && 5 <= y && y < 19) {	/* I{^ */
											if ((sht->flag & SHEET_APP) != 0) {	/* AvP[V */
												task = sht->task;
												io_cli();
												task->tss.eax = (int) &(task->tss.esp0);
												task->tss.eip = (int) endapp;
												io_sti();
												task_run(task, -1, 0);
											} else if ((sht->flag & SHEET_DIALOGUE) != 0) {	/* _CAO */
												sht->flag &= ~SHEET_DIALOGUE;
												task_run(sht->task, -1, 0);
											} else {	/* R\[ */
												task = sht->task;
												sheet_updown(sht, -1);
												io_cli();
												fifo_put(&task->fifo, 4);
												io_sti();
											}
										}
										if (3 <= x && x < sht->sx - 3 && 3 <= y && y < 21) {
											mmx = mouse.mx;
											mmy = mouse.my;
											mmx2 = sht->x;
											nwy = sht->y;
										}
										break;
									}
								}
							}
							menu_run(sback, &mstart, mouse.mx, mouse.my, j);
							tbar_run(j, mouse.mx, mouse.my);
						} else {	/* EBhEړ */
							x = mouse.mx - mmx;
							y = mouse.my - mmy;
							nwx = (mmx2 + x + 2) & ~3;
							nwy += y;
							mmy = mouse.my;
						}
					} else {
						mmx = -1;
						if (nwx != 0x7fffffff) {
							sheet_slide(sht, nwx, nwy);
							nwx = 0x7fffffff;
						}
					}
				}
			} else if (768 <= i && i <= 1023) {
				console_close((struct sheet *) (shts->sht + (i - 768)));
			} else if (1024 <= i && i <= 2023) {
				console_close0((struct task *) (tss->task + (i - 1024)));
			} else if (2024 <= i && i <= 2279) {
				sht2 = shts->sht + (i - 2024);
				memory_free(mem, (int) sht2->buf, 42240);
				sheet_free(sht2);
			}
		}
	}
}

void window_refresh(void)
{
	fifo_put(&fifo, 2);
	return;
}

void console_exitreq(struct sheet *sht)
{
	fifo_put(&fifo, 768 + (sht - shts->sht));
	return;
}

void console_exitreq0(struct task *task)
{
	fifo_put(&fifo, 1024 + (task - tss->task));
	return;
}

void console_exitreq1(struct sheet *sht)
{
	fifo_put(&fifo, 2024 + (sht - shts->sht));
	return;
}

void mouse_get(struct mapi *m)
{
	m->x = mouse.mx;
	m->y = mouse.my;
	m->btn = mouse.btn;
	m->stat = mouse.stat;
	return;
}

void reset(void)
{
	io_cli();
	keyboard_ready();
	io_out8(0x0064, 0xfe);
	for (;;) {
    	io_hlt();
	}
}
