#include "main.h"

struct tbar *tbar;

void tbar_init(struct sheet *st)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	int i;

	tbar = (struct tbar *) memory_alloc(mem, sizeof(struct tbar));
	for (i = 0; i < SHEETS; i++) {
		tbar->win[i].sht = 0;
	}
	tbar->cont = 0;
	tbar->select = -1;	/* I */
	tbar->start = 0;
	tbar->each = (binfo->scrnx - 123) / 136;
	tbar->sht = st;
	return;
}

void tbar_add(struct sheet *sht, unsigned char *title)
{
	int i;

	for (i = 0; i < SHEETS; i++) {
		if (tbar->win[i].sht == 0) {
			tbar->win[i].sht = sht;
			tbar->win[i].title = title;
			tbar->cont++;
			break;
		}
	}
	tbar->start = (i / tbar->each) * tbar->each;
	tbar_print();
	return;
}

void tbar_remove(struct sheet *sht)
{
	int i;

	for (i = 0; i < SHEETS; i++) {
		if (tbar->win[i].sht == sht) {
			tbar->win[i].sht = 0;
			tbar->win[i].title = 0;
			tbar->cont--;
			break;
		}
	}
	if (i == SHEETS) {
		return;
	}
	if (tbar->start >= tbar->cont) {	/* \̈ʒu */
		tbar->start = (tbar->start / tbar->each) - 1;
	}
	for (; i < SHEETS; i++) {
		tbar->win[i] = tbar->win[i + 1];
	}
	tbar_print();
	return;
}

void tbar_select(struct sheet *sht)
{
	int i;

	for (i = 0; i < SHEETS; i++) {
		if (tbar->win[i].sht == sht) {
			tbar->select = i;
			tbar->start = tbar->select / tbar->each * tbar->each;
			break;
		}
	}
	tbar_print();
	return;
}

void tbar_unselect(void)
{
	tbar->select = -1;
	tbar_print();
	return;
}

void tbar_run(int h, int x, int y)
{
	struct window *win;
	int i;

	if (h == 0 && tbar->sht->sy - 24 <= y && y <= tbar->sht->sy - 2) {
		if (tbar->sht->sx - 61 <= x && x <= tbar->sht->sx - 50) {
			if (tbar->cont > tbar->each) {
				tbar->start += tbar->each;
				if (tbar->start > tbar->cont) {
					tbar->start = 0;
				}
			}
		} else if (62 <= x && x <= tbar->sht->sx - 63) {
			i = (x - 62) / 134;
			if (0 <= i && i < tbar->each) {
				win = &tbar->win[tbar->start + i];
				sheet_tupdown(win->sht);
				window_refresh();
			}
		}
	}
	tbar_print();
	return;
}

void tbar_print(void)
{
	struct window *win;
	int i;

	graphic_box(tbar->sht, COLOR_C6C6C6, 62, tbar->sht->sy - 24, tbar->sht->sx - 50, tbar->sht->sy - 2);
	for (i = 0; i < tbar->each; i++) {
		win = &tbar->win[tbar->start + i];
		if (win->sht == 0) {
			break;
		}
		tbar_print0(win, i);
	}
	if (tbar->cont > tbar->each) {
		graphic_button(tbar->sht, tbar->sht->sx - 61, tbar->sht->sy - 24, 11, 21, "\20", 0);
	}
	sheet_refresh(tbar->sht, 62, tbar->sht->sy - 24, tbar->sht->sx - 49, tbar->sht->sy - 1);
	return;
}

void tbar_print0(struct window *win, int i)
{
	int x = 62 + (i * 136);

	if (tbar->start + i == tbar->select) {
		graphic_button(tbar->sht, x, tbar->sht->sy - 24, 134, 21, win->title, 1);
	} else {
		graphic_button(tbar->sht, x, tbar->sht->sy - 24, 134, 21, win->title, 0);
	}
	return;
}
