#include <tapi.h>
#include <stdlib.h>
#include <string.h>
#define TAB			4
#define CMAP_LETTER	0x01
#define CMAP_KANJI	0x02
#define CMAP_KANJI2	0x03
#define CMAP_TAB	0x04

int isKanji(unsigned char c)
{
	if ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) {
		return 1;
	}
	return 0;
}

struct line *tEboxMakeline(void)
{
	struct line *line = (struct line *) malloc(sizeof(struct line));
	line->next = 0;
	line->size = 1;
	line->str = malloc(line->size);
	line->str[line->size - 1] = 0;
	return line;
}

struct line *tEboxGetlAtnum(struct editBox *eb, int no)
{
	struct line *line = eb->text;
	int i;
	for (i = 0; i < no; i++) {
		line = line->next;
	}
	return line;
}

void tEboxCmap(struct editBox *eb)
{
	struct line *l = tEboxGetlAtnum(eb, eb->cy);
	unsigned char *p = l->str;
	int x;
	if (!eb->cmap)
		eb->cmap = (unsigned char *) malloc(l->size * TAB - 1);
	for (x = 0; x < l->size * TAB - 1; x++)
		eb->cmap[x] = 0;
	for (x = 0; ; p++) {
		if (*p == 0x09) {
printf("In %d\n", x);
			if (!x)
				eb->cmap[x++] = CMAP_LETTER;
			for (; x % TAB != 0; x++) {
				eb->cmap[x] = CMAP_TAB;
			}
		} else if (isKanji(*p) != 0) {
			eb->cmap[x] = CMAP_KANJI;
			eb->cmap[x + 1] = CMAP_KANJI2;
			x += 2;
			p++;
		} else if (*p == 0x00) {
			eb->cmap[x] = 0;
			return;
		} else {
			eb->cmap[x] = CMAP_LETTER;
			x++;
		}
	}
}

void tEboxPutc(struct line *line, int col, unsigned char c)
{
	struct line *l;
	unsigned char *p;
	int i;
	if (c == 0x0a) {
		l = line->next;
		line->next = tEboxMakeline();
		line->next->next = l;
		return;
	}
	if (col >= line->size - 1) {
		line->size++;
		col = line->size - 2;
		p = malloc(line->size);
		for (i = 0; i < line->size - 2; i++) {
			p[i] = line->str[i];
		}
		p[line->size - 1] = 0;
		free(line->str);
		line->str = p;
	}
	line->str[col] = c;
	return;
}

void tEboxDelc(struct line *line, int col)
{
	unsigned char *p;
	int i;
	for (i = col; i < line->size - 1; i++) {
		line->str[i] = line->str[i + 1];
	}
	p = malloc(line->size - 1);
	for (i = 0; i <= line->size - 1; i++) {
		p[i] = line->str[i];
	}
	free(line->str);
	line->str = p;
	line->size--;
	line->str[line->size - 1] = 0;
	return;
}

void tEboxInit(struct editBox *eb, int win, unsigned char *wbuf, int x0, int y0, int sx, int sy, unsigned char *text)
{
	struct line *l;
	int col = 0, i;
	eb->win = win;
	eb->x0 = x0;
	eb->y0 = y0;
	eb->sizex = sx;
	eb->sizey = sy;
	eb->skipx = 0;
	eb->skipy = 0;
	eb->cx = 0;
	eb->cy = 0;
	eb->wbuf = wbuf;
	eb->cmap = 0;
	eb->change = 0;
	eb->text = tEboxMakeline();
	l = eb->text;
	for (i = 0; text[i] != 0x00; i++) {
		if (text[i] != 0x0d) {
			tEboxPutc(l, col, text[i]);
		}
		col++;
		if (text[i] == 0x0a) {
			l->next = tEboxMakeline();
			l = l->next;
			col = 0;
		}
	}
	tEboxCmap(eb);
	return;
}

void tEboxPutcAtcur(struct editBox *eb, unsigned char c)
{
	struct line *line = tEboxGetlAtnum(eb, eb->cy), *l;
	unsigned char *p;
	int i;
	eb->change = 1;
	if (c == 0x0a) {
		l = tEboxMakeline();
		for (i = eb->cx; line->str[i] != 0x00; i++) {
			tEboxPutc(l, i - eb->cx, line->str[i]);
		}
		l->next = line->next;
		line->next = l;
		line->size = eb->cx + 1;
		p = malloc(line->size);
		for (i = 0; i < line->size - 1; i++) {
			p[i] = line->str[i];
		}
		p[i] = 0;
		free(line->str);
		line->str = p;
		eb->cx = 0;
		eb->cy++;
	} else {
		tEboxPutc(line, line->size, ' ');
		for (i = line->size - 2; i > eb->cx; i--) {
			line->str[i] = line->str[i - 1];
		}
		tEboxPutc(line, eb->cx, c);
		eb->cx++;
	}
	return;
}

void tEboxDelcAtcur(struct editBox *eb)
{
	struct line *line = tEboxGetlAtnum(eb, eb->cy), *l;
	int i;
	if (eb->cx == 0 && eb->cy == 0) {
		return;
	}
	eb->change = 1;
	if (eb->cx == 0) {
		for (l = eb->text; l->next != line; l = l->next) { }
		for (i = eb->cx; line->str[i] != 0x00; i++) {
			tEboxPutc(l, l->size, line->str[i]);
		}
		l->next = line->next;
		free(line->str);
		free(line);
		eb->cx = -1;
		eb->cy--;
		return;
	}
	if (eb->cx >= 2 && isKanji(line->str[eb->cx - 2]) != 0) {
		tEboxDelc(line, eb->cx - 1);
		eb->cx--;
	}
	tEboxDelc(line, eb->cx - 1);
	if (line->size == 1) {
		for (l = eb->text; l->next != line; l = l->next) { }
		l->next = line->next;
		free(line->str);
		free(line);
		eb->cx = 0;
		return;
	}
	eb->cx--;
	return;
}

void puttab(int *x, int skipx, int sizex, unsigned char *s)
{
	for (;;) {
		if (0 <= *x && *x < sizex) {
			s[*x] = ' ';
		}
		(*x)++;
		if ((skipx + *x) % TAB == 0) {
			return;
		}
	}
}

int tEboxCurPrint(struct editBox *eb)
{
	int x0 = 8 + (eb->cx - eb->skipx) * 8, y0 = 28 + (eb->cy - eb->skipy) * 16, x1, i, j;
	if (eb->cmap[eb->cx] == CMAP_KANJI) {
		x1 = x0 + 16;
	} else if (eb->cmap[eb->cx] == CMAP_TAB) {
		for (i = 0; eb->cmap[eb->cx + i] == CMAP_TAB; i++);
		x1 = x0 + 8 * i;
	} else {
		x1 = x0 + 8;
	}
	for (i = y0; i < y0 + 16; i++) {
		for (j = x0; j < x1; j++) {
			if (eb->wbuf[i * (eb->sizex / 8 * 8 + 16) + j] == _000000) {
				eb->wbuf[i * (eb->sizex / 8 * 8 + 16) + j] = _FFFFFF;
			} else {
				eb->wbuf[i * (eb->sizex / 8 * 8 + 16) + j] = _000000;
			}
		}
	}
	return 0;
}

void tEboxLview(int win, int y, int skipx, int sizex, unsigned char *p)
{
	int x = -skipx;
	unsigned char s[sizex / 8];
	for (;;) {
		if (*p == 0) {
			break;
		} else if (*p == 0x09) {
			puttab(&x, skipx, sizex, s);
			p++;
		} else if (*p == 0x0a) {
			p++;
			break;
		} else if ((0x81 <= *p && *p <= 0x9f) || (0xe0 <= *p && *p <= 0xfc)) {
			if (x == -1) {
				s[0] = ' ';
			} else if (0 <= x && x < sizex / 8) {
				s[x] = *p;
				s[x + 1] = p[1];
			} else if (x == sizex / 8) {
				s[x] = ' ';
			}
			x += 2;
			p += 2;
		} else {
			if (0 <= x && x < sizex / 8) {
				s[x] = *p;
			}
			x++;
			p++;
		}
	}
	if (x > sizex / 8) {
		x = sizex / 8;
	}
	if (x > 0) {
		tWputs(win, _000000, 8, y * 16 + 28, s, x);
	}
	return;
}

void tEboxView(struct editBox *eb)
{
	struct line *line;
	int i;
	for (;;) {
		line = tEboxGetlAtnum(eb, eb->skipy);
		tTbox(eb->win + 1, _FFFFFF, 8, 28, eb->sizex, eb->sizey);
		for (i = 0; i < eb->sizey / 16; i++) {
			tEboxLview(eb->win + 1, i, eb->skipx, eb->sizex, line->str);
			if (line->next == 0) {
				break;
			}
			line = line->next;
		}
		if ((i = tEboxCurPrint(eb)) == 0) {
			tWrefresh(eb->win, 5, 25, eb->sizex + 10, eb->sizey + 37);
			return;
		}
	}
}

void tEboxSetcur(struct editBox *eb, char to)
{
	int i;
	if (eb->cy - eb->skipy < 0 || eb->cy - eb->skipy >= eb->sizey / 16) {
		eb->skipy = eb->cy - eb->sizey / 16 + 1;
		if (eb->skipy < 0) {
			eb->skipy = 0;
		}
	}
	if (eb->cx == -1) {
		for (i = 0; eb->cmap[i] != 0; i++) { }
		eb->cx = i;
	}
	if (eb->cmap[eb->cx] == CMAP_KANJI2) {
		if (to != 0) {
			eb->cx++;
		} else {
			eb->cx--;
		}
	} if (eb->cmap[eb->cx] == CMAP_TAB) {
		if (to) {
			for (; eb->cmap[eb->cx] == CMAP_TAB; eb->cx++) { }
		} else {
			for (; eb->cmap[eb->cx] == CMAP_TAB; eb->cx--) { }
		}
	}
	if (eb->cx - eb->skipx < 0 || eb->cx - eb->skipx >= eb->sizex / 8) {
		eb->skipx = eb->cx - eb->sizex / 8 + 1;
		if (eb->cmap[eb->cx] == CMAP_KANJI) {
			eb->skipx++;
		}
		if (eb->skipx < 0) {
			eb->skipx = 0;
		}
	}
	return;
}

void tEboxEvent(struct editBox *eb, int i)
{
	struct line *t = tEboxGetlAtnum(eb, eb->cy), *u;
	if (i == KEY_LEFT) {
		for (;;) {
			if (eb->cx > 0) {
				eb->cx--;
			} else {
				u = eb->text;
				if (t != u) {
					for (; u->next != t; u = u->next) { }
				}
				if (u != t || t != eb->text) {
					t = u;
					eb->cy--;
					tEboxCmap(eb);
					eb->cx = -1;
				}
			}
			if (tGetc(0) != KEY_LEFT) {
				break;
			}
		}
		tEboxCmap(eb);
		tEboxSetcur(eb, 0);
	} else if (i == KEY_RIGHT) {
		for (;;) {
			printf("%d %d\n", eb->cx, eb->cmap[eb->cx]);
			if (eb->cx < strlen(eb->cmap)) {
				eb->cx++;
			} else {
				if (t->next != 0) {
					eb->cy++;
					t = t->next;
					eb->cx = 0;
				}
			}
			if (tGetc(0) != KEY_RIGHT) {
				break;
			}
		}
		tEboxCmap(eb);
		tEboxSetcur(eb, 1);
	} else if (i == KEY_UP) {
		for (;;) {
			u = eb->text;
			if (t != u) {
				for (; u->next != t; u = u->next) { }
			}
			if (u != t || t != eb->text) {
				t = u;
				eb->cy--;
				if (eb->cx > t->size - 1) {
					eb->cx = -1;
				}
			}
			if (tGetc(0) != KEY_UP) {
				break;
			}
		}
		tEboxCmap(eb);
		tEboxSetcur(eb, 0);
	} else if (i == KEY_DOWN) {
		for (;;) {
			if (t->next != 0) {
				t = t->next;
				eb->cy++;
				if (eb->cx > t->size - 1) {
					eb->cx = -1;
				}
			}
			tEboxCmap(eb);
			tEboxSetcur(eb, 0);
			if (tGetc(0) != KEY_DOWN) {
				break;
			}
		}
		tEboxCmap(eb);
		tEboxSetcur(eb, 0);
	} else if (i == 0x08) {
		tEboxDelcAtcur(eb);
		tEboxCmap(eb);
		tEboxSetcur(eb, 0);
	} else if ((0x20 <= i && i <= 0x7e) || i == 0x09 || i == 0x0a) {
		tEboxPutcAtcur(eb, i);
		tEboxCmap(eb);
		tEboxSetcur(eb, 1);
	}
	return;
}
