#include <tapi.h>
#include <stdio.h>
#define WIN_X	71
#define WIN_Y	17
#define TAB		4
#define TEMP	512

void lview(int win, int y, char *p, int n)
{
	char s[WIN_X];
	int x;
	sprintf(s, "%06X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X ",
		n, p[0] & 0xff, p[1] & 0xff, p[2] & 0xff, p[3] & 0xff, p[4] & 0xff, p[5] & 0xff, p[6] & 0xff, p[7] & 0xff, p[8] & 0xff, p[9] & 0xff,
		p[10] & 0xff, p[11] & 0xff, p[12] & 0xff, p[13] & 0xff, p[14] & 0xff, p[15] & 0xff);
	for (x = 0; x < 16; ) {
		if (0x20 <= *p && *p <= 0x7e) {
			s[WIN_X - 16 + x] = *p;
		} else {
			s[WIN_X - 16 + x] = '.';
		}
		x++;
		p++;
	}
	tWbox(win, _848484, 8, y * 16 + 29, 8 + 8 * 6, y * 16 + 29 + 15);
	tWputs(win, _000000, 8, y * 16 + 29, s, WIN_X);
	return;
}

void tview(int win, char *p, int n, int size)
{
	int i;
	tTbox(win + 1, _FFFFFF, 8, 28, WIN_X * 8, WIN_Y * 16);
	tWbox(win + 1, _848484, 8 + 8 * 7, 29, WIN_X * 8 + 7, 29 + 15);
	tWputs(win + 1, _000000, 8 + 8 * 7, 29, "+0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F 0123456789ABCDEF", -1);
	for (i = 1; i < WIN_Y && n + (i - 1) * 0x10 < size; i++) {
		lview(win + 1, i, p + n + (i - 1) * 0x10, n + (i - 1) * 0x10);
	}
	tWrefresh(win, 5, 25, WIN_X * 8 + 10, WIN_Y * 16 + 31);
	return;
}

void HariMain(void)
{
	unsigned char wbuf[(WIN_X * 8 + 16) * (WIN_Y * 16 + 37)], tbuf[TEMP * 1024];
	char line[31], s[31];
	int win, n = 0, size, i = 0;
	i = tFinput(line, 31);
	size = tFsize(i, 0);
	if (size >= TEMP * 1024 - 1) {
		size = TEMP * 1024 - 1;
	}
	tFread(i, tbuf, size);
	tFclose(i);
	sprintf(s, "%s - oCir[A", line);
	win = tWopen(wbuf, WIN_X * 8 + 16, WIN_Y * 16 + 37, -1, s);

	for (;;) {
		tview(win, tbuf, n, size);
		i = tGetc(1);
		if (i == '8') {
			for (;;) {
				n -= 16;
				if (n < 0) {
					n = 0;
				}
				if (tGetc(0) != '8') {
					break;
				}
			}
		} else if (i == '2') {
			for (;;) {
				if (n + 16 <= size) {
					n += 16;
				}
				if (tGetc(0) != '2') {
					break;
				}
			}
		}
	}
}
