#include <tapi.h>
#include <stdio.h>
#define INVALID	-0x7fffffff
int strtol(char *s, char **endp, int base);	/* stdlib.h */

void sskip(char **p)
{
	for (; **p == ' '; (*p)++) { }
	return;
}

int calc(char **p, int pri)
{
	int i = INVALID, j;
	sskip(p);
	if (**p == '+') {
		(*p)++;
		sskip(p);
		i = calc(p, 0);
	} else if (**p == '-') {
		(*p)++;
		sskip(p);
		i = calc(p, 0);
		if (i != INVALID) {
			i = -i;
		}
	} else if (**p == '~') {
		(*p)++;
		sskip(p);
		i = calc(p, 0);
		if (i != INVALID) {
			i = ~i;
		}
	} else if (**p == '(') {
		(*p)++;
		sskip(p);
		i = calc(p, 9);
		if (**p == ')') {
			(*p)++;
			sskip(p);
		} else {
			i = INVALID;
		}
	} else if ('0' <= **p && **p <= '9') {
		i = strtol(*p, p, 0);
	} else {
		i = INVALID;
	}

	for (;;) {
		if (i == INVALID) {
			break;
		}
		sskip(p);
		if (**p == '+' && pri >= 2) {
			(*p)++;
			sskip(p);
			j = calc(p, 2);
			if (j != INVALID) {
				i += j;
			} else {
				i = INVALID;
			}
		} else if (**p == '-' && pri >= 2) {
			(*p)++;
			sskip(p);
			j = calc(p, 2);
			if (j != INVALID) {
				i -= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '*' && pri >= 1) {
			(*p)++;
			sskip(p);
			j = calc(p, 1);
			if (j != INVALID) {
				i *= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '/' && pri >= 1) {
			(*p)++;
			sskip(p);
			j = calc(p, 1);
			if (j != INVALID && j != 0) {
				i /= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '%' && pri >= 1) {
			(*p)++;
			sskip(p);
			j = calc(p, 1);
			if (j != INVALID && j != 0) {
				i %= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '<' && *(*p + 1) == '<' && pri >= 3) {
			*p += 2;
			sskip(p);
			j = calc(p, 3);
			if (j != INVALID && j != 0) {
				i <<= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '>' && *(*p + 1) == '>' && pri >= 3) {
			*p += 2;
			sskip(p);
			j = calc(p, 3);
			if (j != INVALID && j != 0) {
				i >>= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '&' && pri >= 4) {
			(*p)++;
			sskip(p);
			j = calc(p, 4);
			if (j != INVALID) {
				i &= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '^' && pri >= 5) {
			(*p)++;
			sskip(p);
			j = calc(p, 5);
			if (j != INVALID) {
				i ^= j;
			} else {
				i = INVALID;
			}
		} else if (**p == '|' && pri >= 6) {
			(*p)++;
			sskip(p);
			j = calc(p, 6);
			if (j != INVALID) {
				i |= j;
			} else {
				i = INVALID;
			}
		} else {
			break;
		}
	}
	sskip(p);
	return i;
}

void HariMain(void)
{
	char line[31], *p;
	int i;
	for (;;) {
		tIdialog(line, 31);
		p = line;
		if (*p == 0) {
			break;
		}
		i = calc(&p, 9);
		if (i == INVALID) {
			tDialog("vZł܂B");
		} else {
			sprintf(line, "%d 0x%x", i, i);
			tDialog(line);
		}
	}
	return;
}
