#ifndef _KOZOS_H_INCLUDED_
#define _KOZOS_H_INCLUDED_

/* configure.hFTEASEOSpr` */
#include <tapi.h>

typedef int (*kz_func)(int argc, char *argv[]);

/* syscall */
int kz_run(kz_func func, char *name, int pri, int argc, char *argv[]);
void kz_exit();
int kz_wait();
int kz_sleep();
int kz_wakeup(int id);
int kz_getid();
int kz_chpri(int pri);
int kz_send(int id, int size, char *p);
int kz_recv(int *idp, char **pp);

/* library */
void kz_start(kz_func func, char *name, int pri, int argc, char *argv[]);

/* syscall.h */
typedef enum {
  KZ_SYSCALL_TYPE_RUN,
  KZ_SYSCALL_TYPE_EXIT,
  KZ_SYSCALL_TYPE_WAIT,
  KZ_SYSCALL_TYPE_SLEEP,
  KZ_SYSCALL_TYPE_WAKEUP,
  KZ_SYSCALL_TYPE_GETID,
  KZ_SYSCALL_TYPE_CHPRI,
  KZ_SYSCALL_TYPE_SEND,
  KZ_SYSCALL_TYPE_RECV,
} kz_syscall_type_t;

typedef struct {
  union {
    struct {
      kz_func func;
      char *name;
      int pri;
      int argc;
      char **argv;
      int ret;
    } run;
    struct {
      int dummy;
    } exit;
    struct {
      int ret;
    } wait;
    struct {
      int ret;
    } sleep;
    struct {
      int id;
      int ret;
    } wakeup;
    struct {
      int ret;
    } getid;
    struct {
      int pri;
      int ret;
    } chpri;
    struct {
      int id;
      int size;
      char *p;
      int ret;
    } send;
    struct {
      int *idp;
      char **pp;
      int ret;
    } recv;
  } un;
} kz_syscall_param_t;

void kz_syscall(kz_syscall_type_t type, kz_syscall_param_t *param);

/* thread.h */
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>

#define THREAD_NUM 16
#define PRI_NUM 32
#define THREAD_NAME_SIZE 16

typedef struct _kz_membuf {
  struct _kz_membuf *next;
  int id;
  int size;
  char *p;
} kz_membuf;

typedef struct _kz_thread {
  struct _kz_thread *next;
  char name[THREAD_NAME_SIZE + 1];
  struct _kz_thread *id;
  kz_func func;
  int pri;
  char *stack;

  struct {
    kz_syscall_type_t type;
    kz_syscall_param_t *param;
  } syscall;

  kz_membuf *messages;

  struct {
#ifdef __TEASEOS
    struct jmp_buf env;
#else
    jmp_buf env;
#endif
  } context;
} kz_thread;

extern kz_thread *current;

#endif
