#ifndef _TEASEOS_LISP_H_INCLUDED
#define _TEASEOS_LISP_H_INCLUDED
#define TLISP_CELLS		4096
#define TLISP_STRLEN	16384
#define TLISP_CELL		1
#define TLISP_NUM		2
#define TLISP_ATOM		3
struct cell {
	unsigned int id;
	struct cell *car, *cdr;
};
/* struct cell̓ZƃAg𗼕
  ZȂA
    id = TLISP_CELL; car, cdr͂̂܂܂̈Ӗ;
  lAgȂA
    id = TLISP_NUM; car = l, cdr = 0
  AgȂA
    id = TLISP_ATOM; car = ւ̃|C^, cdr = 0
*/
struct tlisp {
	struct cell cell[TLISP_CELLS], *cp;
	unsigned char str[TLISP_STRLEN], *sp, *tp;
};

#define CAR(cp)			(!cp ? 0 : cp->car)
#define CDR(cp)			(!cp ? 0 : cp->cdr)
#define ISTCELL(cp)		(cp ? ((cp->id == TLISP_CELL) ? cp : 0) : 0)
#define ISTNUM(cp)		(cp ? ((cp->id == TLISP_NUM) ? cp : 0) : 0)
#define ISTATOM(cp)		(cp ? ((cp->id == TLISP_ATOM) ? cp : 0) : 0)

void tlispInit(struct tlisp *lisp, unsigned char *text);
struct cell *tlisp(struct tlisp *lisp);
#endif
