#include <kozos.h>
#include <string.h>

#define SIG_NUM 32
#define STACK_SIZE 0x8000

#ifdef __TEASEOS
kz_thread *threads;
kz_thread **readyque;
struct jmp_buf intr_env;
#else
kz_thread threads[THREAD_NUM];
kz_thread *readyque[PRI_NUM];
static jmp_buf intr_env;
#endif

kz_thread *current;

static void getcurrent()
{
  readyque[current->pri] = current->next;
  current->next = NULL;
}

static int putcurrent()
{
  kz_thread **thpp;
  for (thpp = &readyque[current->pri]; *thpp; thpp = &((*thpp)->next)) {
    /* łɗLꍇ͖ */
    if (*thpp == current) return -1;
  }
  *thpp = current;
  return 0;
}

static void thread_init(kz_thread *thp, int argc, char *argv[])
{
  thp->func(argc, argv);
}

static void thread_end()
{
  kz_exit();
}

static int thread_run(kz_func func, char *name, int pri,
		      int argc, char *argv[])
{
  int i;
  char *sp;
  kz_thread *thp;

  for (i = 0; i < THREAD_NUM; i++) {
    thp = &threads[i];
    if (!thp->id) break;
  }
  if (i == THREAD_NUM) return -1;

  memset(thp, 0, sizeof(*thp));

  thp->next = NULL;
  strcpy(thp->name, name);
  thp->id = thp;
  thp->func = func;
  thp->pri = pri;
  thp->stack = malloc(STACK_SIZE);

  memset(thp->stack, 0, STACK_SIZE);

  sp = thp->stack + STACK_SIZE - 32;

  /* C֐I̖߂ */
  ((int *)sp)[1] = (int)thread_end;

  /* X^bNɈ(argc,argv) */
  ((int *)sp)[2] = (int)thp;
  ((int *)sp)[3] = argc;
  ((int *)sp)[4] = (int)argv;

  /*
   * ȉ̐ݒɂĂ setjmp()/longjmp()
   * (/usr/src/lib/libc/i386/gen)QƁD
   */
#ifdef __TEASEOS
  thp->context.env.reg[0] = (int)thread_init;
  thp->context.env.reg[1] = intr_env.reg[1];
  thp->context.env.reg[2] = (int)sp;
  thp->context.env.reg[3] = intr_env.reg[3];
  thp->context.env.reg[4] = intr_env.reg[4];
  thp->context.env.reg[5] = intr_env.reg[5];
#else
#if 1
  thp->context.env[0]._jb[0] = (int)thread_init;   /* EIP */
  thp->context.env[0]._jb[1] = intr_env[0]._jb[1]; /* EBX */
  thp->context.env[0]._jb[2] = (int)sp;            /* ESP */
  thp->context.env[0]._jb[3] = intr_env[0]._jb[3]; /* EBP */
  thp->context.env[0]._jb[4] = intr_env[0]._jb[4]; /* ESI */
  thp->context.env[0]._jb[5] = intr_env[0]._jb[5]; /* EDI */
  /* thp->context.env[0]._jb[6] = ??? */
#else
  memcpy(thp->context.env, intr_env, sizeof(intr_env));
  thp->context.env[0]._jb[0] = (int)thread_init; /* EIP */
  thp->context.env[0]._jb[2] = (int)sp;   /* ESP */
#endif
#endif

  /* N̏̃Xbh쐬ł current Ȃ̂NULL`FbN */
  if (current) {
    putcurrent();
  }

  current = thp;
  putcurrent();
  return (int)current;
}

/* Xbh̏I */
static int thread_exit()
{
  free(current->stack);
  memset(current, 0, sizeof(*current));
  return 0;
}

/* Xbh̎s(pri̕ʃXbhɎsn) */
static int thread_wait()
{
  putcurrent();
  return 0;
}

static int thread_sleep()
{
  return 0;
}

static int thread_wakeup(int id)
{
  putcurrent();
  current = (kz_thread *)id;
  putcurrent();
  return 0;
}

static int thread_getid()
{
  putcurrent();
  return (int)current->id;
}

static int thread_chpri(int pri)
{
  int old = current->pri;
  if (pri >= 0)
    current->pri = pri;
  putcurrent();
  return old;
}

static void recvmsg()
{
  kz_membuf *mp;

  mp = current->messages;
  current->messages = mp->next;
  mp->next = NULL;

  current->syscall.param->un.recv.ret = mp->size;
  if (current->syscall.param->un.recv.idp)
    *(current->syscall.param->un.recv.idp) = mp->id;
  if (current->syscall.param->un.recv.pp)
    *(current->syscall.param->un.recv.pp)  = mp->p;
  free(mp);
}

static void sendmsg(kz_thread *thp, int id, int size, char *p)
{
  kz_membuf *mp;
  kz_membuf **mpp;

  current = thp;

  mp = (kz_membuf *)malloc(sizeof(*mp));
  if (mp == NULL) {
#ifdef __TEASEOS
    printf("cannot allocate memory.\n");
    tExit();
#else
    fprintf(stderr, "cannot allocate memory.\n");
    exit(1);
#endif
  }
  mp->next = NULL;
  mp->size = size;
  mp->id = id;
  mp->p = p;
  for (mpp = &current->messages; *mpp; mpp = &((*mpp)->next))
    ;
  *mpp = mp;

  if (putcurrent() == 0) {
    /* M鑤ubN̏ꍇɂ͎Ms */
    recvmsg();
  }
}

static int thread_send(int id, int size, char *p)
{
  putcurrent();
  sendmsg((kz_thread *)id, (int)current, size, p);
  return size;
}

static int thread_recv(int *idp, char **pp)
{
  if (current->messages == NULL) {
    /* bZ[ŴŃubN */
    return -1;
  }

  recvmsg();
  putcurrent();
  return current->syscall.param->un.recv.ret;
}

static void syscall_proc()
{
  /* VXeR[̎scurrent̂Ń|C^ۑĂ */
  kz_syscall_param_t *p = current->syscall.param;

  getcurrent();

  switch (current->syscall.type) {
  case KZ_SYSCALL_TYPE_RUN:
    p->un.run.ret = thread_run(p->un.run.func, p->un.run.name, p->un.run.pri,
			       p->un.run.argc, p->un.run.argv);
    break;
  case KZ_SYSCALL_TYPE_EXIT:
    /* XbĥŖ߂lȂǂł͂Ȃ */
    thread_exit();
    break;
  case KZ_SYSCALL_TYPE_WAIT:
    p->un.wait.ret = thread_wait();
    break;
  case KZ_SYSCALL_TYPE_SLEEP:
    p->un.sleep.ret = thread_sleep();
    break;
  case KZ_SYSCALL_TYPE_WAKEUP:
    p->un.wakeup.ret = thread_wakeup(p->un.wakeup.id);
    break;
  case KZ_SYSCALL_TYPE_GETID:
    p->un.getid.ret = thread_getid();
    break;
  case KZ_SYSCALL_TYPE_CHPRI:
    p->un.chpri.ret = thread_chpri(p->un.chpri.pri);
    break;
  case KZ_SYSCALL_TYPE_SEND:
    p->un.send.ret = thread_send(p->un.send.id, p->un.send.size, p->un.send.p);
    break;
  case KZ_SYSCALL_TYPE_RECV:
    p->un.recv.ret = thread_recv(p->un.recv.idp, p->un.recv.pp);
    break;
  default:
    break;
  }
  return;
}

static void dispatch()
{
  int i;
  for (i = 0; i < PRI_NUM; i++) {
    if (readyque[i]) break;
  }
  if (i == PRI_NUM) {
    /* s\ȃXbh݂Ȃ̂ŁCI */
#ifdef __TEASEOS
    tExit();
#else
    exit(0);
#endif
  }
  current = readyque[i];
}

static void thread_intrvec(int signo)
{
  switch (signo) {
  case SIGSYS: /* VXeR[ */
    syscall_proc();
    break;
#ifndef __TEASEOS
  case SIGBUS: /* _Ev */
  case SIGSEGV:
  case SIGTRAP:
  case SIGILL:
    {
      fprintf(stderr, "error %s\n", current->name);
      /* _Evɂps\Ȃ̂ŁCX[vԂɂ*/
      getcurrent();
    }
    break;
#endif
  default:
    break;
  }
  dispatch();
  longjmp(&current->context.env, 1);
}

static void thread_intr(int signo)
{
  /*
   * setjmp()/longjmp() ̓VOi}XNۑ邪C
   * _setjmp()/_longjmp() ̓VOi}XNۑȂD
   * (WX^ZbgƃX^bNۑѕȂ)
   */
  if (setjmp(&current->context.env) == 0) {
    longjmp(&intr_env, signo);
  }
}

static void thread_start(kz_func func, char *name, int pri, int argc, char *argv[])
{
#ifdef __TEASEOS
  threads = (kz_thread *) malloc(sizeof(kz_thread) * THREAD_NUM);
  readyque = (kz_thread **) malloc(sizeof(kz_thread *) * PRI_NUM);
#endif
  memset(threads, 0, sizeof(kz_thread) * THREAD_NUM);
  memset(readyque, 0, sizeof(kz_thread *) * PRI_NUM);

  signal(SIGSYS, thread_intr);

  /*
   * current ̂߂ɃVXeR[s͂łȂ̂ŁC
   * ڊ֐ĂяoăXbh쐬D
   */
  current = NULL;
  current = (kz_thread *)thread_run(func, name, pri, argc, argv);

  longjmp(&current->context.env, 1);
}

void kz_start(kz_func func, char *name, int pri, int argc, char *argv[])
{
  int signo;

  /*
   * setjmp()͍Œʂ̊֐ĂԕKv̂ŁC{̂ thread_start() 
   * u setjmp() Ăяoɖ{̂ĂяoD
   * (setjmp()֐ return  longjmp() ĂяoĂ͂Ȃ)
   */
  if ((signo = setjmp(&intr_env)) == 0) {
    thread_start(func, name, pri, argc, argv);
  }
  thread_intrvec(signo);

  /* ɂ͕ԂĂȂ */
#ifdef __TEASEOS
  tExit();
#else
  abort();
#endif
}
