#include <tapi.h>
#include <tlisp.h>
#include <stdio.h>
#include <string.h>

#define TEMP	16
#define PAGES	64
#define XSIZE	624
#define YSIZE	420
struct pres {
	struct cell *pages[PAGES];
	unsigned int xsize, ysize, xtitle, xfont;
	unsigned int win, now, all;
};
#define MIN(a, b)		(a < b) ? a : b

void print_page(struct pres *pres)
{
	struct cell *tp = CDR(CDR(CDR(pres->pages[pres->now - 1]))), *cp;
	struct pict pict;
	int fh, y, i, j;

	if (ISTCELL(CAR(CDR(CDR(pres->pages[pres->now - 1]))))) {
		cp = ISTCELL(CAR(CDR(CDR(pres->pages[pres->now - 1]))));
		if ((fh = tFopen((unsigned char *) CAR(ISTATOM(CAR(cp))))) == 0)
			goto pout;
		tPcheck(fh, &pict);
		if (!pict.m)
			goto pout;
		i = 8 + (int) CAR(ISTNUM(CAR(CDR(cp))));
		j = 28 + (int) CAR(ISTNUM(CAR(CDR(CDR(cp)))));
		tWpict(pres->win, i, j, MIN(i + pict.sx, 9 + pres->xsize), MIN(j + pict.sy, 29 + pres->ysize), fh);
	}
pout:
	tWputsex(pres->win + 1, _000000, 8, 28,
		(unsigned char *) CAR(ISTATOM(CAR(CDR(pres->pages[pres->now - 1])))),
		XSIZE / (8 * (pres->xtitle - 1)), pres->xtitle);
	for (y = 28 + (pres->xtitle + 1) * 16; ISTATOM(CAR(tp)); tp = CDR(tp)) {
		tWputsex(pres->win + 1, _000000, 8, y,
			(unsigned char *) CAR(ISTATOM(CAR(tp))),
			XSIZE / (8 * (pres->xfont - 1)), pres->xfont);
		y += pres->xfont * 16;
	}
	return;
}

void print(struct pres *pres)
{
	unsigned char s[31];

	tWbox(pres->win + 1, _FFFFFF, 8, 28, XSIZE + 8, YSIZE + 28);
	tWbox(pres->win + 1, _C6C6C6, 8, YSIZE + 36, XSIZE + 8, YSIZE + 52);
	sprintf(s, "%d / %d", pres->now, pres->all);
	tWputs(pres->win + 1, _000000, XSIZE + 8 - strlen(s) * 8, YSIZE + 36, s, -1);
	print_page(pres);
	tWrefresh(pres->win, 8, 28, XSIZE + 8, YSIZE + 52);
	return;
}

void HariMain(void)
{
	struct tlisp lisp;
	struct pres pres;
	unsigned char fbuf[TEMP * 1024 + 1], wbuf[(XSIZE + 16) * (YSIZE + 60)], line[31], s[31];
	struct cell *cp;
	int i, j;

	i = tFinput(line, 31);
	j = tFsize(i, 0);
	if (j > TEMP * 1024)
		j = TEMP * 1024;
	tFread(i, fbuf, j);
	fbuf[j] = 0;
	pres.now = pres.all = 0;

	tlispInit(&lisp, fbuf);
	for (; *lisp.tp; ) {
		if ((cp = tlisp(&lisp)) != 0) {
			if (strcmp((unsigned char *) CAR(ISTATOM(CAR(cp))), "size") == 0) {
				pres.xsize = (unsigned int) CAR(ISTNUM(CAR(CDR(cp))));
				pres.ysize = (unsigned int) CAR(ISTNUM(CAR(CDR(CDR(cp)))));
				pres.xtitle = (unsigned int) CAR(ISTNUM(CAR(CDR(CDR(CDR(cp))))));
				pres.xfont = (unsigned int) CAR(ISTNUM(CAR(CDR(CDR(CDR(CDR(cp)))))));
				if (XSIZE < pres.xsize || YSIZE < pres.ysize) {
					tDialog("EBhETCY傫܂B\n");
					return;
				}
			} else if (strcmp((unsigned char *) CAR(ISTATOM(CAR(cp))), "page") == 0) {
				pres.pages[pres.all] = cp;
				if (!pres.now)
					pres.now++;
				pres.all++;
			}
		}
	}
	sprintf(s, "%s - v[e[V", line);
	pres.win = tWopen(wbuf, pres.xsize + 16, pres.ysize + 60, -1, s);
	for (;;) {
		print(&pres);
		i = tGetc(1);
		if (i == KEY_RIGHT) {
			if (++pres.now > pres.all)
				pres.now--;
		} else if (i == KEY_LEFT) {
			if (--pres.now < 1)
				pres.now = 1;
		}
	}
	return;
}
