#include "main.h"
#include <stdio.h>
struct timers *tms;

void gdtInit(void)
{
	struct segdesc *sd = (struct segdesc *) GDT_ADDR;
	int i;
	for (i = 0; i <= GDT_LIMIT / 8; i++) {
		segdescSet(sd + i, 0, 0, 0);
	}
	segdescSet(sd + 1, 0x00000000, 0xffffffff, RWDATA);
	segdescSet(sd + 2, MAIN_ADDR, MAIN_LIMIT, RXCODE);
	gdtrLoad(GDT_LIMIT, GDT_ADDR);
	return;
}

void idtInit(void)
{
	struct gatedesc *gd = (struct gatedesc *) IDT_ADDR;
	int i;
	for (i = 0; i <= IDT_LIMIT / 8; i++) {
		gatedescSet(gd + i, 0, 0, 0);
	}
	idtrLoad(IDT_LIMIT, IDT_ADDR);
	gatedescSet(gd + 0x00, (int) int00Asm, 2 * 8, INT);			/* 0ZO */
	gatedescSet(gd + 0x06, (int) int06Asm, 2 * 8, INT);			/* ߗO */
	gatedescSet(gd + 0x07, (int) int07Asm, 2 * 8, INT);			/* FPU */
	gatedescSet(gd + 0x0c, (int) int0cAsm, 2 * 8, INT);			/* X^bNO */
	gatedescSet(gd + 0x0d, (int) int0dAsm, 2 * 8, INT);			/* ʕیO */
	gatedescSet(gd + 0x20, (int) int20Asm, 2 * 8, INT);			/* PIT */
	gatedescSet(gd + 0x21, (int) int21Asm, 2 * 8, INT);			/* PS/2L[{[h */
	gatedescSet(gd + 0x26, (int) int26Asm, 2 * 8, INT);			/* FDC */
	gatedescSet(gd + 0x27, (int) int27Asm, 2 * 8, INT);			/* }X^PIC̕sS荞 */
	gatedescSet(gd + 0x2c, (int) int2cAsm, 2 * 8, INT);			/* PS/2}EX */
	gatedescSet(gd + 0x30, (int)   apiAsm, 2 * 8, INT + 0x60);	/* API */
	return;
}

void segdescSet(struct segdesc *sd, int base, unsigned int limit, int ar)
{
	if (limit > 0xfffff) {
		ar |= 0x8000;	/* G-bit */
		limit /= 0x1000;
	}
	sd->limit_low = limit & 0xffff;
	sd->base_low = base & 0xffff;
	sd->base_mid = (base >> 16) & 0xff;
	sd->access_right = ar & 0xff;
	sd->limit_high = ((limit >> 16) & 0x0f) | ((ar >> 8) & 0xf0);
	sd->base_high = (base >> 24) &0xff;
	return;
}

void gatedescSet(struct gatedesc *gd, int offset, int selector, int ar)
{
	gd->offset_low = offset & 0xffff;
	gd->selector = selector;
	gd->dw_count = (ar >> 8) & 0xff;
	gd->access_right = ar & 0xff;
	gd->offset_high = (offset >> 16) & 0xffff;
	return;
}

void picInit(void)
{
	out8(0x0021, 0xff);
	out8(0x00a1, 0xff);

	out8(0x0020,   0x11);
	out8(0x0021,   0x20);
	out8(0x0021, 1 << 2);
	out8(0x0021,   0x01);

	out8(0x00a0, 0x11);
	out8(0x00a1, 0x28);
	out8(0x00a1, 0x02);
	out8(0x00a1, 0x01);

	out8(0x0021, 0xfb);	/* 11111011 */
	out8(0x00a1, 0xff);	/* 11111111 */
	return;
}

int *int00(int *esp)
{
	struct task *task = taskNow();
	unsigned char s[32];
	sprintf(s, "%s 0ZO\n    eip = 0x%08x", task->name, esp[11]);
	dialog(s);
	return &(task->tss.esp0);
}

int *int06(int *esp)
{
	struct task *task = taskNow();
	unsigned char s[32];
	sprintf(s, "%s ߗO\n    eip = 0x%08x", task->name, esp[11]);
	dialog(s);
	return &(task->tss.esp0);
}

int *int07(int *esp)
{
	extern struct tasks *tctl;
	struct task *task = taskNow();
	cli();
	clts();
	if (tctl->tfpu != task) {
		if (tctl->tfpu != 0) {
			fnsave(tctl->tfpu->fpu);
		}
		frstor(task->fpu);
		tctl->tfpu = task;
	}
	sti();
	return 0;
}

int *int0c(int *esp)
{
	struct task *task = taskNow();
	unsigned char s[32];
	sprintf(s, "%s X^bNیO\n    eip = 0x%08x", task->name, esp[11]);
	dialog(s);
	return &(task->tss.esp0);
}

int *int0d(int *esp)
{
	struct task *task = taskNow();
	unsigned char s[32];
	sprintf(s, "%s ʕیO\n    eip = 0x%08x", task->name, esp[11]);
	dialog(s);
	return &(task->tss.esp0);
}

void int27(int *esp)
{
	out8(0x0020, 0x67);
	return;
}

void keyInit(void)
{
	keyReady();
	out8(0x0064, 0x60);
	keyReady();
	out8(0x0060, 0x47);
	return;
}

void int21(int *esp)
{
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	int data;
	out8(0x0020, 0x61);
	data = in8(0x0060);
	fifoPut(fifo, 256 + data);
	return;
}

void keyReady(void)
{
	for (;;) {
		if ((in8(0x0064) & 0x02) == 0) {
			return;
		}
	}
}

void mouseSendcmd(unsigned char code)
{
	keyReady();
	out8(0x0064, 0xd4);
	keyReady();
	out8(0x0060, code);
	return;
}

void mouseEnable(void)
{
	struct mouse *mouse = (struct mouse *) *((int *) MOUSE_ADDR);
	static unsigned char data[7] = { 0xf3, 200, 0xf3, 100, 0xf3, 80, 0xf2 };
	int i;

	cli();
	for (i = 0; i < 7; i++) {
		mouseSendcmd(data[i]);
		while (in8(0x0060) != 0xfa);
	}
	mouse->wheel = in8(0x0060);
	if (mouse->wheel != 0x03) {
		mouse->wheel = 0;
		mouse->scroll = 0;
	}
	sti();

	mouse->phase = 0;
	mouseSendcmd(0xf4);
	return;
}

void int2c(int *esp)
{
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	int data;
	out8(0x00a0, 0x64);
	out8(0x0020, 0x62);
	data = in8(0x0060);
	fifoPut(fifo, 512 + data);
	return;
}

int mouseDecode(unsigned char data)
{
	struct mouse *mouse = (struct mouse *) *((int *) MOUSE_ADDR);
	if (mouse->phase == 0) {
		if (data == 0xfa) {
			mouse->phase = 1;
		}
		return 0;
	} else if (mouse->phase == 1) {
		if ((data & 0xc8) == 0x08) {
			mouse->buf[0] = data;
			mouse->phase = 2;
		}
		return 0;
	} else if (mouse->phase == 2) {
		mouse->buf[1] = data;
		mouse->phase = 3;
		return 0;
	} else if (mouse->phase == 3) {
		mouse->buf[2] = data;
		mouse->btn = mouse->buf[0] & 0x07;
		mouse->x = mouse->buf[1];
		mouse->y = mouse->buf[2];
		if ((mouse->buf[0] & 0x10) != 0) {
			mouse->x |= 0xffffff00;
		}
		if ((mouse->buf[0] & 0x20) != 0) {
			mouse->y |= 0xffffff00;
		}
		mouse->y = -mouse->y;
		if (mouse->x == 0 && mouse->y == 0) {
			if (mouse->btn == 0) {
				mouse->stat = MOUSE_RELEASED;
			} else {
				mouse->stat = MOUSE_PRESSED;
			}
		} else {
			if (mouse->btn == 0) {
				mouse->stat = MOUSE_MOVED;
			} else {
				mouse->stat = MOUSE_DRAGGED;
			}
		}
		if (mouse->wheel) {
			mouse->phase = 4;
			return 0;
		}
		mouse->phase = 1;
		return 1;
	} else if (mouse->phase == 4) {
		mouse->buf[3] = data;
		mouse->phase = 1;
		mouse->scroll = mouse->buf[3] & 0x0f;
		if (mouse->scroll & 0x08) {
			mouse->scroll |= 0xfffffff0;
		}
		return 1;
	}
	return -1;
}

void mouseGet(struct mapi *m)
{
	struct mouse *mouse = (struct mouse *) *((int *) MOUSE_ADDR);
	m->x = mouse->mx;
	m->y = mouse->my;
	m->btn = mouse->btn;
	m->stat = mouse->stat;
	m->scroll = mouse->scroll;
	return;
}

void pitInit(void)
{
	out8(0x0043, 0x34);	/* NbNݒ */
	out8(0x0040, 0x9c);	/* 100hz */
	out8(0x0040, 0x2e);
	tms = 0;
	return;
}

void timersInit(void)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct timer *t;
	int i;
	tms = (struct timers *) memAlloc(mem, sizeof (struct timers));
	tms->count = 0;
	for (i = 0; i < TIMERS; i++) {
		tms->timer[i].flag = 0;
	}

	t = timerAlloc();
	t->tout = 0xffffffff;
	t->flag = TIMER_USING;
	t->next = 0;
	tms->t = t;
	return;
}

void int20(int *esp)
{
	extern struct timer *tts;
	struct timer *t;
	char fts = 0;
	out8(0x0020, 0x60);
	if (tms == 0) {
		return;
	}
	tms->count++;
	t = tms->t;
	for (;;) {
		if (t->tout > tms->count) {
			tms->t = t;
			if(fts == 1) {
				taskSwitch();
			}
			return;
		}

		t->flag = TIMER_ALLOC;
		if (t != tts) {
			fifoPut(t->fifo, t->data);
		} else {
			fts = 1;
		}
		t = t->next;
	}
}

struct timer *timerAlloc(void)
{
	int i;
	for (i = 0; i < TIMERS; i++) {
		if (tms->timer[i].flag == 0) {
			tms->timer[i].flag = TIMER_ALLOC;
			return &tms->timer[i];
		}
	}
	return 0;
}			

void timerFree(struct timer *timer)
{
	timerCancel(timer);
	timer->flag = 0;
	timer->fapp = 0;
	return;
}

void timerInit(struct timer *timer, struct fifo *fifo)
{
	timer->fifo = fifo;
	return;
}

void timerSet(struct timer *timer, unsigned int tout, int data)
{
	struct timer *t, *s;
	int e;
	timer->tout = tms->count + tout;
	timer->data = data;
	timer->flag = TIMER_USING;
	e = eflagsLoad();
	cli();
	t = tms->t;
	if (timer->tout <= t->tout) {
		tms->t = timer;
		timer->next = t;
		eflagsStore(e);
		return;
	}
	for (;;) {
		s = t;
		t = t->next;
		if (timer->tout <= t->tout) {
			s->next = timer;
			timer->next = t;
			eflagsStore(e);
			return;
		}
	}
}

void timerAllcancel(struct fifo *fifo)
{
	struct timer *t;
	int e, i;
	e = eflagsLoad();
	cli();
	for (i = 0; i < TIMERS; i++) {
		t = &tms->timer[i];
		if (t->flag != 0 && t->fapp != 0 && t->fifo == fifo) {
			timerFree(t);
		}
	}
	eflagsStore(e);
	return;
}

int timerCancel(struct timer *timer)
{
	struct timer *t;
	int e;
	e = eflagsLoad();
	cli();
	if (timer->flag == TIMER_USING) {
		if (timer == tms->t) {
			tms->t = timer->next;
		} else {
			t = tms->t;
			for (;;) {
				if (t->next == timer) {
					break;
				}
				t = t->next;
			}
			t->next = timer->next;
		}
		timer->flag = TIMER_ALLOC;
		eflagsStore(e);
		return 1;
	}
	eflagsStore(e);
	return 0;
}

void clockGet(struct clock *c)
{
	unsigned char t[7];

	clockRtc(t);
	c->year = (unsigned short) ((t[6] * 100) | t[5]);
	c->month = (unsigned char) t[4];
	c->day = (unsigned char) t[3];
	c->hour = (unsigned char) t[2];
	c->min = (unsigned char) t[1];
	c->sec = (unsigned char) t[0];
	return;
}

void clockRtc(unsigned char *t)
{
	static unsigned char addr[7] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
	static unsigned char max[7] = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
	unsigned char t2[7], err;
	int i;

	for (;;) {	/* ǂݍ݂܂ */
		err = 0;
		for (i = 0; i < 7; i++) {
			out8(0x70, addr[i]);
			t2[i] = in8(0x71);
		}
		for (i = 0; i < 7; i++) {
			out8(0x70, addr[i]);
			if (t2[i] != in8(0x71) || (t2[i] & 0x0f) > 9 || t2[i] > max[i]) {
				err = 1;
			}
		}
		if (err == 0) {
			break;
		}
	}
	t[0] = (t2[0] >> 4) * 10 + (t2[0] & 0x0f);
	t[1] = (t2[1] >> 4) * 10 + (t2[1] & 0x0f);
	t[2] = (t2[2] >> 4) * 10 + (t2[2] & 0x0f);
	t[3] = (t2[3] >> 4) * 10 + (t2[3] & 0x0f);
	t[4] = (t2[4] >> 4) * 10 + (t2[4] & 0x0f);
	t[5] = (t2[5] >> 4) * 10 + (t2[5] & 0x0f);
	t[6] = (t2[6] >> 4) * 10 + (t2[6] & 0x0f);
	return;
}

void beep(int mhz)
{
	int i;
	if (mhz == 0) {
		i = in8(0x61);
		out8(0x61, i & 0x0d);
	} else {
		i = 1193180000 / mhz;
		out8(0x43, 0xb6);
		out8(0x42, i & 0xff);
		out8(0x42, i >> 8);
		i = in8(0x61);
		out8(0x61, (i | 0x03) & 0x0f);
	}
	return;
}
