#include "main.h"
#include <tlisp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void reset(void)
{
	cli();
	keyReady();
	out8(0x0064, 0xfe);
	for (;;) {
    	hlt();
	}
}

void settingRead(unsigned char *p, struct sheet *sback, int *fat, struct menu *menu)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct tlisp *lisp = (struct tlisp *) memAlloc(mem, sizeof(struct tlisp));
	struct cell *cp;
	struct menu *m;
	int i;

	tlispInit(lisp, p);
	for (; *lisp->tp;) {
		if ((cp = tlisp(lisp)) != 0) {
			if (strcmp((unsigned char *) CAR(ISTATOM(CAR(cp))), "background") == 0) {
				screenInit(sback, fat, (unsigned char *) CAR(ISTATOM(CAR(CDR(cp)))));
			} else if (strcmp((unsigned char *) CAR(ISTATOM(CAR(cp))), "file-assoc") == 0) {
				fileassAdd((unsigned char *) CAR(ISTATOM(CAR(CDR(cp)))),
					(unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(cp))))),
					(unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(CDR(cp)))))));
			} else if (strcmp((unsigned char *) CAR(ISTATOM(CAR(cp))), "start-prog") == 0) {
				if ((int) CAR(ISTNUM(CAR(CDR(cp)))) != 0) {
					m = (struct menu *) memAlloc(mem, sizeof(struct menu));
					menuInit(m, 0);
					menuAdd(menu, (unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(CDR(cp)))))),
						(unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(cp))))), m);
				} else {
					if ((int) CAR(ISTNUM(CAR(CDR(cp))))) {
						for (i = 0; i < SELECTS; i++) {
							if (menu->sel[i].mode != 0) {
								if ((int) menu->sel[i].line[0] == (int) cp->car->car) {
									menuAdd(menu->sel[i].menu, (unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(CDR(cp)))))),
										(unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(cp))))), 0);
									break;
								}
							}
						}
					} else {
						menuAdd(menu, (unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(CDR(cp)))))),
							(unsigned char *) CAR(ISTATOM(CAR(CDR(CDR(cp))))), 0);
					}
				}
			}
		}
	}
	memFree(mem, (int) lisp, sizeof(struct tlisp));
	return;
}

void HariMain(void)
{
	extern struct tasks *tctl;
	extern struct sheets *shts;
	extern unsigned char english[4096];
	static unsigned char tkey[0x80] = {
		  0,   0, '1',  '2', '3', '4', '5', '6', '7', '8', '9', '0',  '-',  '^', 0x08, 0x09,
		'Q', 'W', 'E',  'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a,    0,  'A',  'S',
		'D', 'F', 'G',  'H', 'J', 'K', 'L', ';', ':',   0,   0, ']',  'Z',  'X',  'C',  'V',
		'B', 'N', 'M',  ',', '.', '/',   0, '*',   0, ' ',   0,   0,    0,    0,    0,    0,
		  0,   0,   0,    0,   0,   0,   0, '7', '8', '9', '-', '4',  '5',  '6',  '+',  '1',
		'2', '3', '0',  '.',   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,    0,    0,
		  0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,    0,    0,
		  0,   0,   0, 0x5c,   0,   0,   0,   0,   0,   0,   0,   0,    0, 0x5c,    0,    0
	};
	static unsigned char tkey1[0x80] = {
		  0,   0, '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~',  '=', '~', 0x08, 0x09,
		'Q', 'W', 'E',  'R', 'T', 'Y', 'U', 'I',  'O', 'P', '@', '{', 0x0a,   0,  'A',  'S',
		'D', 'F', 'G',  'H', 'J', 'K', 'L', '+',  '*',   0,   0, '}',  'Z', 'X',  'C',  'V',
		'B', 'N', 'M',  '<', '>', '?',   0, '*',    0, ' ',   0,   0,    0,   0,    0,    0,
		  0,   0,   0,    0,   0,   0,   0, '7',  '8', '9', '-', '4',  '5', '6',  '+',  '1',
		'2', '3', '0',  '.',   0,   0,   0,   0,    0,   0,   0,   0,    0,   0,    0,    0,
		  0,   0,   0,    0,   0,   0,   0,   0,    0,   0,   0,   0,    0,   0,    0,    0,
		  0,   0,   0,  '_',   0,   0,   0,   0,    0,   0,   0,   0,    0, '|',    0,    0
	};
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	struct fifo fifo, fkey;
	struct mouse mouse;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct task *tsys, *task, *sstask;
	struct sheet *sback, *smcur, *skey = 0, *sht = 0, *sht2;
	unsigned char *bback, *bmcur, *nihongo, s[6];
	int bfifo[96], bfkey[32], x, y, i, j;
	int mmx = -1, mmy = -1, mmx2 = 0, nmx = -1, nmy = 0, nwx = 0x7fffffff, nwy = 0;
	int kshf = 0, kleds = (binfo->leds >> 4) & 7, kwait = -1, kpcode = 0;
	struct file *file;
	struct clock clock;
	struct timer *tclock;
	struct menu mstart, mapp;
	unsigned char *p;

	gdtInit();
	idtInit();
	picInit();
	fifoInit(&fifo, bfifo, 96, 0);
	fifoInit(&fkey, bfkey, 32, 0);
	*((int *) FIFO_ADDR) = (int) &fifo;
	*((int *) MOUSE_ADDR) = (int) &mouse;
	pitInit();
	out8(0x0021, 0xb8);	/* 10111000 */
	out8(0x00a1, 0xef);	/* 11101111 */
	sti();
	keyInit();
	mouseEnable();
	mem->allsize = memTest(0x00400000, 0xbfffffff);
	memInit(mem);
	memFree(mem, 0x00001000, 0x0009e000);
	memFree(mem, 0x00400000, mem->allsize - 0x00400000);
	timersInit();

	tclock = timerAlloc();
	timerInit(tclock, &fifo);
	timerSet(tclock, 0, 1);

	tsys = taskInit();
	fifo.task = tsys;
	fkey.task = tsys;

	tsys->fat = (int *) memAlloc(mem, 4 * 2880);
	fatRead(tsys->fat);
	fdcInit(tsys->fat);
	fileInit(mem, binfo->cyls);

	palInit();
	shtInit();
	sback = shtAlloc();
	bback = (unsigned char *) memAlloc(mem, binfo->scrnx * binfo->scrny);
	shtSet(sback, bback, binfo->scrnx, binfo->scrny, -1);
	file = fileSearch("nihongo.fnt");
	if (file != 0) {
		i = file->size;
		nihongo = fileReadTek(tsys->fat, file->cno, &i);
		for (i = 0; i < 512; i++) {
			nihongo[i] = english[i];
		}
	} else {
		nihongo = (unsigned char *) memAlloc(mem, 16 * 256 + 32 * 94 * 47);
		for (i = 0; i < 16 * 256; i++) {
			nihongo[i] = english[i];
		}
		for (; i < 16 * 256 + 32 * 94 * 47; i++) {
			nihongo[i] = 0xff;
		}
	}
	*((int *) NIHONGO_ADDR) = (int) nihongo;
	screenInit(sback, tsys->fat, "");
	menuInit(&mapp, 0);
	file = fileSearch("settings.tl");
	if (file != 0) {
		p = fileRead(tsys->fat, file->cno, file->size);
		p[file->size] = 0;
		settingRead(p, sback, tsys->fat, &mapp);
		memFree(mem, (int) p, file->size);
	}
	tbarInit(sback);
	menuInit(&mstart, "TeaseOS 1.0");
	menuAdd(&mstart, "vO", 0, &mapp);
	menuAdd(&mstart, "^XN}l[W", "\4", 0);
	menuAdd(&mstart, "t@C", "\3", 0);
	menuAdd(&mstart, "R\[", "\1", 0);
	menuAdd(&mstart, "ċN", "\2", 0);
	sstask = ssaverInit();

	smcur = shtAlloc();
	bmcur = (unsigned char *) memAlloc(mem, 160);
	shtSet(smcur, bmcur, 10, 16, 99);
	mouse.mx = (binfo->scrnx - 10) / 2;
	mouse.my = (binfo->scrny - 44) / 2;
	mcurInit(smcur);

	shtSlide(sback,  0,  0);
	shtSlide(smcur, mouse.mx, mouse.my);
	shtUpdown(sback, 0);
	shtUpdown(smcur, 1);

	fifoPut(&fkey, 0xed);
	fifoPut(&fkey, kleds);

	for (;;) {
		if (fifoStat(&fkey) != 0 && kwait < 0) {
			kwait = fifoGet(&fkey);
			keyReady();
			out8(0x0060, kwait);
		}
		cli();
		if (fifoStat(&fifo) == 0) {
			if (nmx >= 0) {
				sti();
				shtSlide(smcur, nmx, nmy);
				nmx = -1;
			} else if (nwx != 0x7fffffff) {
				sti();
				shtSlide(sht, nwx, nwy);
				nwx = 0x7fffffff;
			} else {
				taskSleep(tsys);
				sti();
			}
		} else {
			i = fifoGet(&fifo);
			sti();
			if (skey != 0 && skey->flag == 0) {
close:
				winOff(skey);
				if (shts->top > 1) {
					skey = shts->sht[shts->top - 1];
					winOn(skey);
					menuRun(sback, &mstart, mouse.mx, mouse.my, skey->height);
				} else {
					skey = 0;
					menuRun(sback, &mstart, mouse.mx, mouse.my, 0);
				}
			}
			if (i == 1) {
				clockGet(&clock);
				sprintf(s, "%2d:%02d", clock.hour, clock.min);
				graphicBox(sback, _C6C6C6, sback->sx - 45, sback->sy - 21, sback->sx - 6, sback->sy - 6);
				graphicPuts(sback, _000000, sback->sx - 45, sback->sy - 21, s);
				shtRefresh(sback, sback->sx - 45, sback->sy - 21, sback->sx - 5, sback->sy - 5);
				timerSet(tclock, 100, 1);
			} else if (i == 2) {
				i = 0;
 				goto close;
			} else if (256 <= i && i <= 511) {
				fifoPut(&sstask->fifo, 2);
				i -= 256;
				if (kpcode != 0) {
					kpcode = 0;
					if (skey != 0) {
						if (i == 0x48) {
							fifoPut(&skey->task->fifo, 256 + KEY_UP);
							continue;
						} else if (i == 0x4b) {
							fifoPut(&skey->task->fifo, 256 + KEY_LEFT);
							continue;
						} else if (i == 0x4d) {
							fifoPut(&skey->task->fifo, 256 + KEY_RIGHT);
							continue;
						} else if (i == 0x50) {
							fifoPut(&skey->task->fifo, 256 + KEY_DOWN);
							continue;
						} else if (i == 0x52) {
							fifoPut(&skey->task->fifo, 256 + KEY_INSERT);
							continue;
						}
					}
				}
				if (i < 0x80) {
					if (kshf == 0) {
						s[0] = tkey[i];
					} else {
						s[0] = tkey1[i];
					}
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z') {
					if (((kleds & 4) == 0 && kshf == 0) ||
						((kleds & 4) != 0 && kshf != 0)) {
						s[0] += 0x20;
					}
				}
				if (s[0] != 0 && skey != 0) {
					fifoPut(&skey->task->fifo, 256 + s[0]);
				} else if (i == 0x01 && skey != 0) {
					task = skey->task;
					if (task != 0 && task->tss.ss0 != 0) {
						cli();
						task->tss.eax = (int) &(task->tss.esp0);
						task->tss.eip = (int) appEnd;
						sti();
						taskRun(task, -1, 0);
					}
				} else if (i == 0x2a) {
					kshf |= 1;
				} else if (i == 0x36) {
					kshf |= 2;
				} else if (i == 0x3a) {
					kleds ^= 4;
					fifoPut(&fkey, 0xed);
					fifoPut(&fkey, kleds);
				} else if (i == 0x45) {
					kleds ^= 2;
					fifoPut(&fkey, 0xed);
					fifoPut(&fkey, kleds);
				} else if (i == 0x46) {
					kleds ^= 1;
					fifoPut(&fkey, 0xed);
					fifoPut(&fkey, kleds);
				} else if (i == 0xaa) {
					kshf &= ~1;
				} else if (i == 0xb6) {
					kshf &= ~2;
				} else if (i == 0xe0) {
					kpcode = 1;
				} else if (i == 0xfa) {
					kwait = -1;
				} else if (i == 0xfe) {
					keyReady();
					out8(0x0060, kwait);
				}
			} else if (512 <= i && i <= 767) {
				if (mouseDecode(i - 512) == 1) {
					fifoPut(&sstask->fifo, 2);
					mouse.mx += mouse.x;
					mouse.my += mouse.y;
					if (mouse.mx < 0) { mouse.mx = 0; }
					if (mouse.my < 0) { mouse.my = 0; }
					if (mouse.mx > binfo->scrnx - 1) { mouse.mx = binfo->scrnx - 1; }
					if (mouse.my > binfo->scrny - 1) { mouse.my = binfo->scrny - 1; }
					nmx = mouse.mx;
					nmy = mouse.my;
					if (mstart.mode != 0) {
						menuLight(&mstart, mouse.mx, mouse.my);
					}
					if (mouse.scroll) {
						if (skey) {
							fifoPut(&skey->task->fifo, 1040 + mouse.scroll);
						}
					}
					if ((mouse.btn & 0x01) != 0) {
						if (mmx < 0) {
							for (j = shts->top - 1; j > 0; j--) {
								sht = shts->sht[j];
								x = mouse.mx - sht->x;
								y = mouse.my - sht->y;
								if (0 <= x && x < sht->sx && 0 <= y && y < sht->sy) {
									if (sht->buf[y * sht->sx + x] != sht->cinv) {
										if ((sht->flag & SHEET_MENU) != 0) {
											break;
										}
										shtUpdown(sht, shts->top - 1);
										j = shts->top - 1;
										if (skey != sht) {
											winOff(skey);
											skey = sht;
											winOn(skey);
										}
										if ((sht->flag & SHEET_FILER) != 0) {
											if (8 <= x && x < sht->sx - 22 && 28 <= y && y < 156) {
												fifoPut(&sht->task->fifo, 512 + (y - 28) / 16);
											} else if (sht->sx - 20 <= x && x < sht->sx - 7 && 27 <= y && y < 48) {
												fifoPut(&sht->task->fifo, 5);
											} else if (sht->sx - 20 <= x && x < sht->sx - 7 && sht->sy - 29 <= y && y < sht->sy - 9) {
												fifoPut(&sht->task->fifo, 6);
											}
										} else if ((sht->flag & SHEET_TMGR) != 0) {
											if (8 <= x && x < sht->sx - 22 && 48 <= y && y < 176) {
												fifoPut(&sht->task->fifo, 512 + (y - 48) / 16);
											} else if (sht->sx - 20 <= x && x < sht->sx - 7 && 27 <= y && y < 48) {
												fifoPut(&sht->task->fifo, 5);
											} else if (sht->sx - 20 <= x && x < sht->sx - 7 && sht->sy - 69 <= y && y < sht->sy - 49) {
												fifoPut(&sht->task->fifo, 6);
											}
										}
										if (sht->sx - 39 <= x && x < sht->sx - 23 && 5 <= y && y < 19) {
											shtUpdown(skey, -1);
											menuRun(sback, &mstart, mouse.mx, mouse.my, j);
											tbarRun(j, mouse.mx, mouse.my);
											i = 0;
											goto close;
										} else if (sht->sx - 21 <= x && x < sht->sx - 5 && 5 <= y && y < 19) {
											if ((sht->flag & SHEET_APP) != 0) {
												task = sht->task;
												cli();
												task->tss.eax = (int) &(task->tss.esp0);
												task->tss.eip = (int) appEnd;
												taskRun(task, -1, 0);
												sti();
											} else if ((sht->flag & SHEET_DIALOGUE) != 0) {
												sht->flag &= ~SHEET_DIALOGUE;
												taskRun(sht->task, -1, 0);
											} else {
												task = sht->task;
												shtUpdown(sht, -1);
												cli();
												fifoPut(&task->fifo, 1);
												sti();
											}
										}
										if (3 <= x && x < sht->sx - 3 && 3 <= y && y < 21) {
											mmx = mouse.mx;
											mmy = mouse.my;
											mmx2 = sht->x;
											nwy = sht->y;
										} else if ((sht->flag & SHEET_MOUSE) != 0) {
											fifoPut(&sht->task->fifo, 4);
										}
										break;
									}
								}
							}
							if (j == 0) {
								winOff(skey);
								skey = 0;
							}
							if (j >= 0) {
								menuRun(sback, &mstart, mouse.mx, mouse.my, j);
								tbarRun(j, mouse.mx, mouse.my);
							}
						} else {
							x = mouse.mx - mmx;
							y = mouse.my - mmy;
							nwx = (mmx2 + x + 2) & ~3;
							nwy += y;
							mmy = mouse.my;
						}
					} else if ((mouse.btn & 0x06) != 0) {
						for (j = shts->top - 1; j > 0; j--) {
							sht = shts->sht[j];
							x = mouse.mx - sht->x;
							y = mouse.my - sht->y;
							if (0 <= x && x < sht->sx && 0 <= y && y < sht->sy) {
								if (sht->buf[y * sht->sx + x] != sht->cinv) {
									if ((sht->flag & SHEET_FILER) != 0) {
										if (8 <= x && x < sht->sx - 22 && 28 <= y && y < 156) {
											fifoPut(&sht->task->fifo, 768 + (y - 28) / 16);
										}
									}
									if ((sht->flag & SHEET_MOUSE) != 0) {
										fifoPut(&sht->task->fifo, 4);
									}
								}
							}
						}
					} else {
						mmx = -1;
						if (nwx != 0x7fffffff) {
							shtSlide(sht, nwx, nwy);
							nwx = 0x7fffffff;
						}
					}
				}
			} else if (768 <= i && i <= 1023) {
				consClose((struct sheet *) (shts->sheet + (i - 768)));
			} else if (1024 <= i && i <= 2023) {
				consClose0((struct task *) (tctl->task + (i - 1024)));
			} else if (2024 <= i && i <= 2279) {
				sht2 = shts->sheet + (i - 2024);
				memFree(mem, (int) sht2->buf, 42240);
				shtFree(sht2);
			} else if (2280 <= i && i <= 2535) {
				filerClose((struct sheet *) (shts->sheet + (i - 2280)));
			} else if (2536 <= i && i <= 2791) {
				tmgrClose((struct sheet *) (shts->sheet + (i - 2536)));
			}
		}
	}
}
