#include <tlisp.h>
#include <string.h>
#include <ctype.h>

int isspace(char c)
{
	switch (c) {
		case ' ':
		case '\n':
		case '\r':
		case '\t':
			return c;
	}
	return 0;
}

int isesc(char c)
{
	switch(c) {
		case '(':
		case ')':
		case '\"':
		case '\\':
			return c;
	}
	return 0;
}

int tlispSpace(struct tlisp *lisp)
{
	while (isspace(*lisp->tp)) {
		++lisp->tp;
	}
	return *lisp->tp;
}

void tlispInit(struct tlisp *lisp, unsigned char *text)
{
	lisp->cp = lisp->cell;
	lisp->sp = lisp->str;
	lisp->tp = text;
	return;
}

struct cell *tlispGetnum(struct tlisp *lisp, unsigned int i)
{
	struct cell *np = lisp->cp++;

	np->id = TLISP_NUM;
	np->car = (struct cell *) i;
	np->cdr = (struct cell *) 0;
	return np;
}

struct cell *tlispGetcell(struct tlisp *lisp)
{
	struct cell *cp = lisp->cp++;

	cp->id = TLISP_CELL;
	cp->car = cp->cdr = (struct cell *) 0;
	return cp;
}

struct cell *tlispGetatom(struct tlisp *lisp, unsigned char *str)
{
	struct cell *ap = lisp->cp++;

	ap->id = TLISP_ATOM;
	ap->car = (struct cell *) str;
	ap->cdr = (struct cell *) 0;
	return ap;
}

struct cell *tlispNum(struct tlisp *lisp)
{
	unsigned int i = 0;

	while (isdigit(*lisp->tp))
		i = i * 10 + *lisp->tp++ - '0';
	return tlispGetnum(lisp, i);
};

struct cell *tlispList(struct tlisp *lisp)
{
	struct cell *cp, *cp1, *cp2;

	lisp->tp++;
	if (tlispSpace(lisp) == 0)
		return 0;
	if (*lisp->tp == ')') {
		++lisp->tp;
		cp = tlispGetcell(lisp);
	}
	if (*lisp->tp == '.')
		return 0;
	cp1 = cp = tlispGetcell(lisp);
	if ((cp1->car = tlisp(lisp)) == 0)
		return 0;
	if (tlispSpace(lisp) == 0)
		return 0;
	for (; *lisp->tp != ')';) {
		if (*lisp->tp == '.') {
			++lisp->tp;
			if (tlispSpace(lisp) == 0 || *lisp->tp == ')')
				return 0;
			if ((cp1->cdr = tlisp(lisp)) == 0)
				return 0;
			break;
		}
		cp2 = tlispGetcell(lisp);
		cp1->cdr = cp2;
		if ((cp2->car = tlisp(lisp)) == 0)
			return 0;
		cp1 = cp2;
		if (tlispSpace(lisp) == 0)
			return 0;
	}
	++lisp->tp;
	return cp;
}

int tlispGetname(struct tlisp *lisp, unsigned char *name)
{
	int i, esc = 0;

	for (i = 0; i < 81; i++) {
		while (*lisp->tp == '\"') {
			if (esc)
				esc = 0;
			else
				esc = 1;
			++lisp->tp;
		}
		if (!esc) {
			if (*lisp->tp == '\\')
				++lisp->tp;
			else if (isspace(*lisp->tp) || isesc(*lisp->tp)) {
				*name = 0;
				return 1;
			}
		}
		if (!*lisp->tp)
			break;
		if (iskanji(*lisp->tp)) {
			*name++ = *lisp->tp++;
			if (!*lisp->tp)
				break;
			else if (iskanji2(*lisp->tp)) {
				*name++ = *lisp->tp++;
				++i;
				continue;
			}
		}
		if (!isprkana(*lisp->tp))
			return 0;
		*name++ = *lisp->tp++;
	}
	*name = 0;
	return 1;
}

struct cell *tlispMkatom(struct tlisp *lisp, unsigned char *name)
{
	int len = strlen(name);
	struct cell *ap;

	name = strcpy(lisp->sp, name);
	lisp->sp += len;
	*lisp->sp++ = 0;
	ap = tlispGetatom(lisp, name);
	return ap;
}

struct cell *tlispAtom(struct tlisp *lisp)
{
	unsigned char name[81];

	if (tlispGetname(lisp, name) == 0)
		return 0;
	return tlispMkatom(lisp, name);
}

struct cell *tlispEsc(struct tlisp *lisp)
{
	switch (*lisp->tp) {
		case '(':
			return tlispList(lisp);
		case '\"':
		case '\\':
			return tlispAtom(lisp);
	}
	return 0;
}

struct cell *tlisp(struct tlisp *lisp)
{
	if (tlispSpace(lisp) == 0)
		return 0;
	else if (isdigit(*lisp->tp))
		return tlispNum(lisp);
	else if (isesc(*lisp->tp))
		return tlispEsc(lisp);
	else if (isprkana(*lisp->tp) || iskanji(*lisp->tp))
		return tlispAtom(lisp);
	return 0;
}
