/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class Compile {
    private boolean m_verbose;
    private boolean m_load;
    private boolean m_verify;

    public Compile() {
    }

    public Compile(boolean verbose, boolean load, boolean verify) {
        this.m_verbose = verbose;
        this.m_load = load;
        this.m_verify = verify;
    }

    private static void recursePathJars(String path, ArrayList paths) {
        block5: {
            try {
                Attributes attrs;
                String cpath;
                JarFile jfile = new JarFile(path, false);
                Manifest mfst = jfile.getManifest();
                if (mfst == null || (cpath = (String)(attrs = mfst.getMainAttributes()).get(Attributes.Name.CLASS_PATH)) == null) break block5;
                int split = path.lastIndexOf(File.separatorChar);
                String base = split >= 0 ? path.substring(0, split + 1) : "";
                while (cpath != null) {
                    String item;
                    split = cpath.indexOf(32);
                    if (split >= 0) {
                        item = cpath.substring(0, split);
                        cpath = cpath.substring(split + 1).trim();
                    } else {
                        item = cpath;
                        cpath = null;
                    }
                    String ipath = base + item;
                    if (paths.contains(ipath)) continue;
                    paths.add(ipath);
                    split = ipath.lastIndexOf(46);
                    if (split < 0 || !"jar".equalsIgnoreCase(ipath.substring(split + 1))) continue;
                    Compile.recursePathJars(ipath, paths);
                }
            }
            catch (IOException ex) {}
        }
    }

    public static String[] getClassPaths() {
        String path = System.getProperty("java.class.path");
        ArrayList<String> paths = new ArrayList<String>();
        int start = 0;
        while (path != null) {
            String item;
            int mark = path.indexOf(File.pathSeparatorChar, start);
            if (mark >= 0) {
                item = path.substring(start, mark);
            } else {
                item = path.substring(start);
                path = null;
            }
            if (!paths.contains(item)) {
                paths.add(item);
                int split = item.lastIndexOf(46);
                if (split >= 0 && "jar".equalsIgnoreCase(item.substring(split + 1))) {
                    Compile.recursePathJars(item, paths);
                }
            }
            start = mark + 1;
        }
        paths.add(".");
        String[] clsspths = new String[paths.size()];
        paths.toArray(clsspths);
        return clsspths;
    }

    private boolean verifyBCEL(ClassFile file) {
        try {
            Verifier verifier = VerifierFactory.getVerifier(file.getName());
            boolean verified = false;
            VerificationResult vr = verifier.doPass1();
            if (vr.getStatus() == 1) {
                vr = verifier.doPass2();
                if (vr.getStatus() == 1) {
                    Method[] methods = file.getRawClass().getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        vr = verifier.doPass3a(j);
                        if (vr.getStatus() == 1) {
                            vr = verifier.doPass3b(j);
                        }
                        if (vr.getStatus() == 1) {
                            verified = true;
                        } else {
                            System.out.println("Verification failure on method " + methods[j].getName() + " of class " + file.getName() + ":");
                            System.out.println("  " + vr.toString());
                        }
                        ++j;
                    }
                } else {
                    System.out.println("Verification failure on class " + file.getName() + ":");
                    System.out.println("  " + vr.toString());
                }
            } else {
                System.out.println("Verification failure on class " + file.getName() + ":");
                System.out.println("  " + vr.toString());
            }
            return verified;
        }
        catch (Exception ex) {
            System.out.println("BCEL failure:");
            ex.printStackTrace();
            return false;
        }
    }

    private void handleOutput() throws JiBXException, IOException {
        int i;
        ClassFile[][] lists = MungedClass.writeFiles();
        ClassFile[] files = lists[0];
        if (this.m_verbose) {
            System.out.println("\nWrote " + files.length + " files");
        }
        if (this.m_verbose || this.m_load) {
            i = 0;
            while (i < files.length) {
                ClassFile file = files[i];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                file.writeFile(bos);
                byte[] bytes = bos.toByteArray();
                if (this.m_verbose) {
                    System.out.println("\n " + file.getName() + " output file size is " + bytes.length + " bytes");
                }
                if (this.m_verify) {
                    this.verifyBCEL(file);
                }
                if (this.m_load) {
                    DirectLoader cloader = new DirectLoader();
                    Class clas = cloader.load(file.getName(), bytes);
                    if (this.m_verbose) {
                        java.lang.reflect.Method[] methods = clas.getDeclaredMethods();
                        System.out.println(" Found " + methods.length + " methods:");
                        int j = 0;
                        while (j < methods.length) {
                            java.lang.reflect.Method method = methods[j];
                            System.out.println("  " + method.getReturnType().getName() + " " + method.getName());
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.m_verbose) {
            files = lists[1];
            System.out.println("\nKept " + files.length + " files unchanged:");
            i = 0;
            while (i < files.length) {
                System.out.println(" " + files[i].getName());
                ++i;
            }
            files = lists[2];
            System.out.println("\nDeleted " + files.length + " files:");
            int i2 = 0;
            while (i2 < files.length) {
                System.out.println(" " + files[i2].getName());
                ++i2;
            }
        }
    }

    private BindingDefinition loadBinding(String path) throws JiBXException, FileNotFoundException {
        StringBuffer buff;
        int split = path.lastIndexOf(File.separatorChar);
        String name = path.substring(split + 1);
        if ((split = name.indexOf(46)) > 0) {
            name = name.substring(0, split);
        }
        if (!Character.isJavaIdentifierStart((buff = new StringBuffer(name)).charAt(0))) {
            buff.insert(0, 'X');
        }
        int i = 1;
        while (i < buff.length()) {
            if (!Character.isJavaIdentifierPart(buff.charAt(i))) {
                buff.setCharAt(i, '_');
            }
            ++i;
        }
        name = buff.toString();
        UnmarshallingContext uctx = new UnmarshallingContext(0, new String[0], new String[0], new String[0], new String[0]);
        uctx.setDocument(new FileInputStream(path), path, null);
        BindingDefinition def = BindingBuilder.unmarshalBindingDefinition(uctx, name);
        return def;
    }

    public void compile(String[] classpath, String[] bindingFiles) throws JiBXException {
        try {
            ClassCache.setPaths(classpath);
            ClassFile.setPaths(classpath);
            BindingDefinition[] defs = new BindingDefinition[bindingFiles.length];
            int i = 0;
            while (i < bindingFiles.length) {
                defs[i] = this.loadBinding(bindingFiles[i]);
                if (this.m_verbose) {
                    defs[i].print();
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < defs.length) {
                defs[i2].generateCode();
                ++i2;
            }
            this.handleOutput();
        }
        catch (IOException ex) {
            throw new JiBXException("IOException in compile", ex);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                boolean verbose = false;
                boolean load = false;
                boolean verify = false;
                int offset = 0;
                while (offset < 3 && offset < args.length) {
                    String arg = args[offset];
                    if ("-v".equalsIgnoreCase(arg)) {
                        verbose = true;
                    } else if ("-l".equalsIgnoreCase(arg)) {
                        load = true;
                    } else {
                        if (!"-b".equalsIgnoreCase(arg)) break;
                        verify = true;
                    }
                    ++offset;
                }
                String[] clsspths = Compile.getClassPaths();
                String[] bindings = new String[args.length - offset];
                System.arraycopy(args, offset, bindings, 0, bindings.length);
                if (verbose) {
                    System.out.println("Using paths:");
                    int i = 0;
                    while (i < clsspths.length) {
                        System.out.println(" " + clsspths[i]);
                        ++i;
                    }
                    System.out.println("Using bindings:");
                    int i2 = 0;
                    while (i2 < bindings.length) {
                        System.out.println(" " + bindings[i2]);
                        ++i2;
                    }
                }
                Compile compiler = new Compile(verbose, load, verify);
                compiler.compile(clsspths, bindings);
            }
            catch (JiBXException ex) {
                ex.printStackTrace(System.out);
                System.exit(1);
            }
        } else {
            System.out.println("\nUsage: java org.jibx.binding.Compile [-b] [-l] [-v] binding1 binding2 ...\nwhere:\n -b  turns on BCEL verification (debug option),\n -l  turns on test loading of modified or generated classes for validation, and\n -v  turns on verbose output\nThe bindingn files are different bindings to be compiled.\n");
            System.exit(1);
        }
    }

    public void setLoad(boolean load) {
        this.m_load = load;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setVerify(boolean verify) {
        this.m_verify = verify;
    }

    private static class DirectLoader
    extends SecureClassLoader {
        private DirectLoader() {
        }

        protected Class load(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

