/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassPath;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.ExistingMethod;
import org.jibx.binding.classes.InstructionBuilder;
import org.jibx.runtime.JiBXException;

public class ClassFile {
    protected static final int PRIVATEFIELD_ACCESS = 2;
    protected static final ExistingMethod[] EMPTY_METHOD_ARRAY = new ExistingMethod[0];
    private static ClassPath s_loader;
    protected String m_name;
    protected String m_signature;
    protected Type m_type;
    protected File m_root;
    protected File m_file;
    protected boolean m_isSamePackage;
    protected boolean m_isWritable;
    protected ClassFile m_superClass;
    protected String[] m_interfaces;
    protected String[] m_instanceOfs;
    protected JavaClass m_curClass;
    protected ClassGen m_genClass;
    protected ConstantPoolGen m_genPool;
    protected InstructionBuilder m_instBuilder;
    protected HashMap m_suffixMap;
    protected HashMap m_itemMap;
    protected boolean m_isModified;
    protected int m_useCount;
    protected boolean m_isHashCurrent;
    protected int m_hashCode;
    protected int m_inheritDepth;
    protected int m_uniqueIndex;

    public ClassFile(String name, String path, InputStream ins) throws JiBXException {
        this.init(name, path, ins);
    }

    public ClassFile(String name, File root, File file) throws IOException, JiBXException {
        this.init(name, root.getPath(), new FileInputStream(file));
        this.m_root = root;
        this.m_file = file;
        this.m_isWritable = file.canWrite();
    }

    public ClassFile(String name) throws IOException, JiBXException {
        ClassPath.ClassFile cf = null;
        try {
            cf = s_loader.getClassFile(name);
        }
        catch (IOException ex) {
            try {
                cf = ClassPath.SYSTEM_CLASS_PATH.getClassFile(name);
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        if (cf == null) {
            throw new JiBXException("Class " + name + " not found in any classpath");
        }
        this.init(name, cf.getPath(), cf.getInputStream());
    }

    public ClassFile(String name, File root, ClassFile sclas, int access, String[] impls) throws JiBXException {
        String fname = name.replace('.', File.separatorChar) + ".class";
        File file = new File(root, fname);
        this.m_name = name;
        this.m_signature = Utility.getSignature(name);
        this.m_type = new ObjectType(name);
        this.m_root = root;
        this.m_superClass = sclas;
        this.m_interfaces = impls;
        this.m_file = file;
        this.m_isWritable = true;
        this.m_genClass = new ClassGen(name, sclas.getName(), "", access, impls);
        this.m_genPool = this.m_genClass.getConstantPool();
        this.m_instBuilder = new InstructionBuilder(this.m_genClass, this.m_genPool);
        this.m_itemMap = new HashMap();
    }

    private void init(String name, String path, InputStream ins) throws JiBXException {
        this.m_name = name;
        this.m_signature = Utility.getSignature(name);
        this.m_type = new ObjectType(name);
        this.m_itemMap = new HashMap();
        String fname = name.replace('.', File.separatorChar) + ".class";
        ClassParser parser = new ClassParser(ins, fname);
        try {
            this.m_curClass = parser.parse();
            this.m_interfaces = this.m_curClass.getInterfaceNames();
        }
        catch (Exception ex) {
            throw new JiBXException("Error reading path " + path + " for class " + name);
        }
    }

    public boolean isModifiable() {
        return this.m_isWritable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public Type getType() {
        return this.m_type;
    }

    public String getPackage() {
        int split = this.m_name.lastIndexOf(46);
        if (split >= 0) {
            return this.m_name.substring(0, split);
        }
        return "";
    }

    public File getRoot() {
        return this.m_root;
    }

    public File getFile() {
        return this.m_file;
    }

    public JavaClass getRawClass() {
        return this.m_curClass;
    }

    public String getSuperName() {
        return this.m_curClass.getSuperclassName();
    }

    public void setSuperFile(ClassFile sclas) {
        this.m_superClass = sclas;
        this.m_isSamePackage = this.getPackage().equals(sclas.getPackage());
    }

    public ClassFile getSuperFile() {
        return this.m_superClass;
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public boolean addInterface(String intf) throws JiBXException {
        ClassGen gen = this.getClassGen();
        String[] intfs = gen.getInterfaceNames();
        int i = 0;
        while (i < intfs.length) {
            if (intf.equals(intfs[i])) {
                return false;
            }
            ++i;
        }
        gen.addInterface(intf);
        this.m_isModified = true;
        return true;
    }

    protected void accumulateInterfaces(String[] intfs, HashMap map, ArrayList accs) throws JiBXException {
        int i = 0;
        while (i < intfs.length) {
            String name = intfs[i];
            if (map.get(name) == null) {
                ClassFile cf = ClassCache.getClassFile(name);
                String sig = cf.getSignature();
                map.put(name, sig);
                accs.add(sig);
                String[] inherits = cf.m_curClass.getInterfaceNames();
                this.accumulateInterfaces(inherits, map, accs);
            }
            ++i;
        }
    }

    public String[] getInstanceSigs() throws JiBXException {
        if (this.m_instanceOfs == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<String> iofs = new ArrayList<String>();
            ClassFile cur = this;
            while (cur != null) {
                String sig = cur.getSignature();
                map.put(cur.getName(), sig);
                iofs.add(sig);
                this.accumulateInterfaces(cur.getInterfaces(), map, iofs);
                cur = cur.getSuperFile();
            }
            String[] sigs = new String[iofs.size()];
            this.m_instanceOfs = iofs.toArray(sigs);
        }
        return this.m_instanceOfs;
    }

    public boolean isImplements(String sig) throws JiBXException {
        String[] sigs = this.getInstanceSigs();
        int i = 0;
        while (i < sigs.length) {
            if (sig.equals(sigs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSuperclass(String name) throws JiBXException {
        ClassFile cur = this;
        while (cur != null) {
            if (cur.getName().equals(name)) {
                return true;
            }
            cur = cur.getSuperFile();
        }
        return false;
    }

    protected Field getDefinedField(String name) {
        Field[] fields = this.m_curClass.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(name)) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    protected Field getAccessibleField(String name) {
        Field field = this.getDefinedField(name);
        if (!(field != null || this.m_superClass == null || (field = this.m_superClass.getAccessibleField(name)) == null || this.m_isSamePackage && !field.isPrivate() || field.isPublic() || field.isProtected())) {
            field = null;
        }
        return field;
    }

    public ClassItem getDirectField(String name) throws JiBXException {
        Field field = this.getAccessibleField(name);
        if (field == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(field);
        if (item == null) {
            item = new ClassItem(name, this, field);
            this.m_itemMap.put(field, item);
        }
        return item;
    }

    public ClassItem getField(String name) throws JiBXException {
        Field field = this.getAccessibleField(name);
        if (field == null) {
            throw new JiBXException("Field " + name + " not found in class " + this.m_name);
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(field);
        if (item == null) {
            item = new ClassItem(name, this, field);
            this.m_itemMap.put(field, item);
        }
        return item;
    }

    protected Method getAccessibleMethod(String name, String sig) {
        Method method;
        Method[] methods = this.m_curClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            if (method.getName().equals(name) && method.getSignature().startsWith(sig)) {
                return method;
            }
            ++i;
        }
        if (this.m_superClass != null && (method = this.m_superClass.getAccessibleMethod(name, sig)) != null && (this.m_isSamePackage && !method.isPrivate() || method.isPublic() || method.isProtected())) {
            return method;
        }
        return null;
    }

    public ClassItem getMethod(String name, String sig) {
        Method method = this.getAccessibleMethod(name, sig);
        if (method == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(method);
        if (item == null) {
            item = new ClassItem(name, this, method);
            this.m_itemMap.put(method, item);
        }
        return item;
    }

    public ClassItem getMethod(String name, String[] sigs) {
        Method method = null;
        int i = 0;
        while (method == null && i < sigs.length) {
            method = this.getAccessibleMethod(name, sigs[i]);
            ++i;
        }
        if (method == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(method);
        if (item == null) {
            item = new ClassItem(name, this, method);
            this.m_itemMap.put(method, item);
        }
        return item;
    }

    public ClassItem getInitializerMethod(String sig) {
        Method[] methods = this.m_curClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals("<init>") && method.getSignature().startsWith(sig)) {
                ClassItem item = (ClassItem)this.m_itemMap.get(method);
                if (item == null) {
                    item = new ClassItem("<init>", this, method);
                    this.m_itemMap.put(method, item);
                }
                return item;
            }
            ++i;
        }
        return null;
    }

    public ClassItem getStaticMethod(String name, String sig) {
        Method[] methods = this.m_curClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals(name) && method.isStatic() && method.getSignature().startsWith(sig)) {
                ClassItem item = (ClassItem)this.m_itemMap.get(method);
                if (item == null) {
                    item = new ClassItem(name, this, method);
                    this.m_itemMap.put(method, item);
                }
                return item;
            }
            ++i;
        }
        return null;
    }

    public ExistingMethod[] getBindingMethods(String prefix, String[] matches) {
        if (this.m_curClass == null) {
            return EMPTY_METHOD_ARRAY;
        }
        Method[] methods = this.m_curClass.getMethods();
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String name = method.getName();
            if (name.startsWith(prefix)) {
                ++count;
            } else {
                String sig = method.getSignature();
                int j = 0;
                while (j < matches.length) {
                    if (name.equals(matches[j]) && sig.equals(matches[j + 1])) {
                        ++count;
                        break;
                    }
                    j += 2;
                }
            }
            ++i;
        }
        if (count == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        ExistingMethod[] exists = new ExistingMethod[count];
        int fill = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            Method method = methods[i2];
            String name = method.getName();
            boolean match = name.startsWith(prefix);
            if (!match) {
                String sig = method.getSignature();
                int j = 0;
                while (j < matches.length) {
                    if (name.equals(matches[j]) && sig.equals(matches[j + 1])) {
                        match = true;
                        break;
                    }
                    j += 2;
                }
            }
            if (match) {
                ClassItem item = (ClassItem)this.m_itemMap.get(method);
                if (item == null) {
                    item = new ClassItem(name, this, method);
                    this.m_itemMap.put(method, item);
                }
                exists[fill++] = new ExistingMethod(method, item, this);
            }
            ++i2;
        }
        return exists;
    }

    public boolean isAccessible(ClassItem item) {
        if (item.getClassFile() == this) {
            return true;
        }
        int access = item.getAccessFlags();
        if ((access & 1) != 0) {
            return true;
        }
        if ((access & 2) != 0) {
            return false;
        }
        if (this.getPackage().equals(item.getClassFile().getPackage())) {
            return true;
        }
        if ((access & 4) != 0) {
            ClassFile target = item.getClassFile();
            ClassFile ancestor = this;
            while ((ancestor = ancestor.getSuperFile()) != null) {
                if (ancestor != target) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private ClassGen getClassGen() throws JiBXException {
        if (this.m_genClass == null) {
            if (this.m_isWritable) {
                this.m_genClass = new ClassGen(this.m_curClass);
                this.m_genPool = this.m_genClass.getConstantPool();
                this.m_instBuilder = new InstructionBuilder(this.m_genClass, this.m_genPool);
                this.m_isHashCurrent = false;
            } else {
                throw new JiBXException("Cannot modify class " + this.m_name);
            }
        }
        return this.m_genClass;
    }

    public ConstantPoolGen getConstPoolGen() throws JiBXException {
        if (this.m_genPool == null) {
            this.getClassGen();
        }
        return this.m_genPool;
    }

    public InstructionBuilder getInstructionBuilder() throws JiBXException {
        if (this.m_instBuilder == null) {
            this.getClassGen();
        }
        return this.m_instBuilder;
    }

    public ClassItem addMethod(Method method) throws JiBXException {
        this.getClassGen().addMethod(method);
        this.setModified();
        String mname = method.getName();
        if (this.m_suffixMap != null && ClassFile.isSuffixName(mname)) {
            this.m_suffixMap.put(mname, method);
        }
        return new ClassItem(mname, this, method);
    }

    public void removeMethod(Method method) throws JiBXException {
        this.getClassGen().removeMethod(method);
        this.setModified();
        String mname = method.getName();
        if (this.m_suffixMap != null && ClassFile.isSuffixName(mname)) {
            this.m_suffixMap.remove(mname);
        }
    }

    public ClassItem addField(String type, String name, int access, String init) throws JiBXException {
        this.deleteField(name);
        FieldGen fgen = new FieldGen(access, Type.getType(Utility.getSignature(type)), name, this.getConstPoolGen());
        fgen.setInitValue(init);
        Field field = fgen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(name, this, field);
    }

    public ClassItem updateField(String type, String name, int access, String init) throws JiBXException {
        Field[] fields = this.m_curClass.getFields();
        int i = 0;
        while (i < fields.length) {
            ConstantValue cval;
            String sig;
            Field field = fields[i];
            if (field.getName().equals(name) && field.getAccessFlags() == access && type.equals(Utility.signatureToString(sig = field.getSignature(), false)) && (cval = field.getConstantValue()) != null) {
                Object value;
                int index = cval.getConstantValueIndex();
                ConstantPool cp = this.m_curClass.getConstantPool();
                Constant cnst = cp.getConstant(index);
                if (cnst instanceof ConstantString && init.equals(value = ((ConstantString)cnst).getConstantValue(cp))) {
                    return new ClassItem(name, this, field);
                }
            }
            ++i;
        }
        this.deleteField(name);
        FieldGen fgen = new FieldGen(access, Type.getType(Utility.getSignature(type)), name, this.getConstPoolGen());
        fgen.setInitValue(init);
        Field field = fgen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(name, this, field);
    }

    public ClassItem addField(String type, String name, int access) throws JiBXException {
        this.deleteField(name);
        FieldGen fgen = new FieldGen(access, Type.getType(Utility.getSignature(type)), name, this.getConstPoolGen());
        Field field = fgen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(name, this, field);
    }

    public ClassItem addPrivateField(String type, String name) throws JiBXException {
        return this.addField(type, name, 2);
    }

    public ClassItem addDefaultConstructor() throws JiBXException {
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder("<init>", Type.VOID, new Type[0], this, 1);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendCallInit(this.m_superClass.getName(), "()V");
        mb.append(InstructionConstants.RETURN);
        mb.codeComplete(false);
        return mb.addMethod();
    }

    private static boolean isSuffixName(String name) {
        int last;
        int i = last = name.length() - 1;
        while (i > 0) {
            char chr = name.charAt(i);
            if (chr == '_') {
                return i < last;
            }
            if (!Character.isDigit(chr)) break;
            --i;
        }
        return false;
    }

    public String makeUniqueMethodName(String name) {
        if (this.m_suffixMap == null) {
            this.m_suffixMap = new HashMap();
            if (this.m_curClass != null) {
                Method[] methods = this.m_curClass.getMethods();
                int i = 0;
                while (i < methods.length) {
                    Method method = methods[i];
                    String mname = method.getName();
                    if (ClassFile.isSuffixName(mname)) {
                        this.m_suffixMap.put(mname, method);
                    }
                    ++i;
                }
            }
        }
        if (this.m_inheritDepth == 0) {
            ClassFile cf = this;
            while ((cf = cf.getSuperFile()) != null) {
                ++this.m_inheritDepth;
            }
        }
        String uname;
        while (this.m_suffixMap.get(uname = name + '_' + this.m_inheritDepth + '_' + this.m_uniqueIndex) != null) {
            ++this.m_uniqueIndex;
        }
        return uname;
    }

    public boolean deleteField(String name) throws JiBXException {
        ClassGen cg = this.getClassGen();
        Field field = cg.containsField(name);
        if (field == null) {
            return false;
        }
        cg.removeField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return true;
    }

    public int getUseCount() {
        return this.m_useCount;
    }

    public int incrementUseCount() {
        return ++this.m_useCount;
    }

    public boolean isModified() {
        return this.m_isModified;
    }

    public void setModified() {
        this.m_isModified = true;
    }

    public boolean isComplete() {
        return this.m_genClass == null;
    }

    protected int computeHashCode() {
        int hash = this.getPackage().hashCode();
        ClassFile sfile = this.getSuperFile();
        if (sfile != null) {
            hash += sfile.getName().hashCode();
        }
        String[] intfs = this.getInterfaces();
        int i = 0;
        while (i < intfs.length) {
            hash += intfs[i].hashCode();
            ++i;
        }
        hash += this.m_curClass.getAccessFlags();
        Field[] fields = this.m_curClass.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            hash = hash * 49 + fields[i2].getName().hashCode();
            ++i2;
        }
        Method[] methods = this.m_curClass.getMethods();
        int i3 = 0;
        while (i3 < methods.length) {
            hash = hash * 49 + methods[i3].getName().hashCode();
            ++i3;
        }
        Constant[] cnsts = this.m_curClass.getConstantPool().getConstantPool();
        int i4 = this.m_curClass.getClassNameIndex() + 1;
        while (i4 < cnsts.length) {
            Constant cnst = cnsts[i4];
            if (cnst != null) {
                int value = 0;
                switch (cnst.getTag()) {
                    case 6: {
                        value = (int)Double.doubleToRawLongBits(((ConstantDouble)cnst).getBytes());
                        break;
                    }
                    case 4: {
                        value = Float.floatToRawIntBits(((ConstantFloat)cnst).getBytes());
                        break;
                    }
                    case 3: {
                        value = ((ConstantInteger)cnst).getBytes();
                        break;
                    }
                    case 5: {
                        value = (int)((ConstantLong)cnst).getBytes();
                        break;
                    }
                    case 1: {
                        String text = ((ConstantUtf8)cnst).getBytes();
                        if (text.equals(this.m_signature)) break;
                        value = text.hashCode();
                        break;
                    }
                }
                hash = hash * 49 + value;
            }
            ++i4;
        }
        return hash;
    }

    public void codeComplete() {
        if (this.m_genClass != null) {
            this.m_curClass = this.m_genClass.getJavaClass();
            this.m_interfaces = this.m_curClass.getInterfaceNames();
            this.m_genClass = null;
        }
    }

    public int hashCode() {
        if (!this.m_isHashCurrent) {
            if (this.m_genClass != null) {
                throw new IllegalStateException("Class still being constructed");
            }
            this.m_hashCode = this.computeHashCode();
            this.m_isHashCurrent = true;
        }
        return this.m_hashCode;
    }

    public static boolean equalFieldOrMethods(FieldOrMethod a, FieldOrMethod b) {
        return a.getName().equals(b.getName()) && a.getSignature().equals(b.getSignature());
    }

    public static boolean equalMethods(Method a, Method b) {
        CodeException[] bcexs;
        Object[] bexcepts;
        Object[] aexcepts;
        ExceptionTable etaba = a.getExceptionTable();
        ExceptionTable etabb = b.getExceptionTable();
        if (etaba != null && etabb != null ? !Arrays.equals(aexcepts = etaba.getExceptionNames(), bexcepts = etabb.getExceptionNames()) : etaba != null || etabb != null) {
            return false;
        }
        Code acode = a.getCode();
        Code bcode = b.getCode();
        CodeException[] acexs = acode.getExceptionTable();
        if (acexs.length == (bcexs = bcode.getExceptionTable()).length) {
            int i = 0;
            while (i < acexs.length) {
                CodeException acex = acexs[i];
                CodeException bcex = bcexs[i];
                if (acex.getCatchType() != bcex.getCatchType() || acex.getStartPC() != bcex.getStartPC() || acex.getEndPC() != bcex.getEndPC() || acex.getHandlerPC() != bcex.getHandlerPC()) {
                    return false;
                }
                ++i;
            }
        }
        return Arrays.equals(acode.getCode(), bcode.getCode());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFile && obj.hashCode() == this.hashCode()) {
            Constant[] ccnsts;
            Method[] cmethods;
            Field[] cfields;
            ClassFile comp = (ClassFile)obj;
            if (!org.jibx.runtime.Utility.isEqual(this.getPackage(), comp.getPackage()) || this.getSuperFile() != comp.getSuperFile() || !Arrays.equals(this.getInterfaces(), comp.getInterfaces())) {
                return false;
            }
            JavaClass tjc = this.m_curClass;
            JavaClass cjc = comp.m_curClass;
            if (tjc.getAccessFlags() != cjc.getAccessFlags()) {
                return false;
            }
            Field[] tfields = tjc.getFields();
            if (tfields.length != (cfields = cjc.getFields()).length) {
                return false;
            }
            int i = 0;
            while (i < tfields.length) {
                if (!ClassFile.equalFieldOrMethods(tfields[i], cfields[i])) {
                    return false;
                }
                ++i;
            }
            Method[] tmethods = tjc.getMethods();
            if (tmethods.length != (cmethods = cjc.getMethods()).length) {
                return false;
            }
            int i2 = 0;
            while (i2 < tmethods.length) {
                Method tmethod = tmethods[i2];
                Method cmethod = cmethods[i2];
                if (!ClassFile.equalFieldOrMethods(tmethod, cmethod) || !ClassFile.equalMethods(tmethod, cmethod)) {
                    return false;
                }
                ++i2;
            }
            Constant[] tcnsts = tjc.getConstantPool().getConstantPool();
            if (tcnsts.length != (ccnsts = cjc.getConstantPool().getConstantPool()).length) {
                return false;
            }
            int i3 = tjc.getClassNameIndex() + 1;
            while (i3 < tcnsts.length) {
                Constant tcnst = tcnsts[i3];
                Constant ccnst = ccnsts[i3];
                if (tcnst != null && ccnst != null) {
                    byte tag = tcnst.getTag();
                    if (tag != ccnst.getTag()) {
                        return false;
                    }
                    boolean equal = true;
                    switch (tag) {
                        case 6: {
                            equal = ((ConstantDouble)tcnst).getBytes() == ((ConstantDouble)ccnst).getBytes();
                            break;
                        }
                        case 4: {
                            equal = ((ConstantFloat)tcnst).getBytes() == ((ConstantFloat)ccnst).getBytes();
                            break;
                        }
                        case 3: {
                            equal = ((ConstantInteger)tcnst).getBytes() == ((ConstantInteger)ccnst).getBytes();
                            break;
                        }
                        case 5: {
                            equal = ((ConstantLong)tcnst).getBytes() == ((ConstantLong)ccnst).getBytes();
                            break;
                        }
                        case 1: {
                            String ttext = ((ConstantUtf8)tcnst).getBytes();
                            String ctext = ((ConstantUtf8)ccnst).getBytes();
                            if (ttext.equals(this.m_signature)) {
                                equal = ctext.equals(comp.m_signature);
                                break;
                            }
                            equal = ttext.equals(ctext);
                            break;
                        }
                    }
                    if (!equal) {
                        return false;
                    }
                } else if (tcnst != null || ccnst != null) {
                    return false;
                }
                ++i3;
            }
            return true;
        }
        return false;
    }

    public void delete() throws IOException {
        if (this.m_file.exists()) {
            this.m_file.delete();
        }
    }

    public void writeFile(OutputStream os) throws IOException {
        this.codeComplete();
        this.m_curClass.dump(os);
        os.close();
    }

    public void writeFile() throws IOException {
        if (this.m_isModified) {
            FileOutputStream os = new FileOutputStream(this.m_file);
            this.writeFile(os);
        }
    }

    public static void setPaths(String[] paths) {
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (i > 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(paths[i]);
            ++i;
        }
        s_loader = new ClassPath(path.toString());
    }
}

