/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.security.InvalidParameterException;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassItem;

public class InstructionBuilder
extends InstructionFactory {
    public InstructionBuilder(ClassGen cg, ConstantPoolGen cp) {
        super(cg, cp);
    }

    public ConstantPoolGen getConstantPoolGen() {
        return this.cp;
    }

    public CompoundInstruction createLoadConstant(int value) {
        return new PUSH(this.cp, value);
    }

    public CompoundInstruction createLoadConstant(String value) {
        return new PUSH(this.cp, value);
    }

    public CompoundInstruction createLoadConstant(Object value) {
        if (value instanceof Boolean) {
            return new PUSH(this.cp, (Boolean)value);
        }
        if (value instanceof Character) {
            return new PUSH(this.cp, (Character)value);
        }
        if (value instanceof Number) {
            return new PUSH(this.cp, (Number)value);
        }
        throw new InvalidParameterException("Internal code generation error!");
    }

    public FieldInstruction createGetField(ClassItem item) {
        String cname = item.getClassFile().getName();
        String fname = item.getName();
        return new GETFIELD(this.cp.addFieldref(cname, fname, item.getSignature()));
    }

    public FieldInstruction createPutField(ClassItem item) {
        String cname = item.getClassFile().getName();
        String fname = item.getName();
        return new PUTFIELD(this.cp.addFieldref(cname, fname, item.getSignature()));
    }

    public FieldInstruction createGetStatic(ClassItem item) {
        String cname = item.getClassFile().getName();
        String fname = item.getName();
        return new GETSTATIC(this.cp.addFieldref(cname, fname, item.getSignature()));
    }

    public FieldInstruction createPutStatic(ClassItem item) {
        String cname = item.getClassFile().getName();
        String fname = item.getName();
        return new PUTSTATIC(this.cp.addFieldref(cname, fname, item.getSignature()));
    }

    public InvokeInstruction createCallStatic(ClassItem item) {
        String cname = item.getClassFile().getName();
        String mname = item.getName();
        int index = this.cp.addMethodref(cname, mname, item.getSignature());
        return new INVOKESTATIC(index);
    }

    public InvokeInstruction createCallVirtual(ClassItem item) {
        String cname = item.getClassFile().getName();
        String mname = item.getName();
        int index = this.cp.addMethodref(cname, mname, item.getSignature());
        return new INVOKEVIRTUAL(index);
    }

    public InvokeInstruction createCallStatic(String method, String signature) {
        int split = method.lastIndexOf(46);
        String cname = method.substring(0, split);
        String mname = method.substring(split + 1);
        int index = this.cp.addMethodref(cname, mname, signature);
        return new INVOKESTATIC(index);
    }

    public InvokeInstruction createCallVirtual(String method, String signature) {
        int split = method.lastIndexOf(46);
        String cname = method.substring(0, split);
        String mname = method.substring(split + 1);
        int index = this.cp.addMethodref(cname, mname, signature);
        return new INVOKEVIRTUAL(index);
    }

    public InvokeInstruction createCallInterface(String method, String signature) {
        int split = method.lastIndexOf(46);
        String cname = method.substring(0, split);
        String mname = method.substring(split + 1);
        return this.createInvoke(cname, mname, Type.getReturnType(signature), Type.getArgumentTypes(signature), (short)185);
    }

    public InvokeInstruction createCallInit(String name, String signature) {
        int index = this.cp.addMethodref(name, "<init>", signature);
        return new INVOKESPECIAL(index);
    }

    public CPInstruction createInstanceOf(ObjectType type) {
        int index = this.cp.addClass(type);
        return new INSTANCEOF(index);
    }
}

