/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.io.File;
import java.util.ArrayList;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.ArrayMap;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.ObjectStringConversion;
import org.jibx.binding.def.PrimitiveStringConversion;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class BindingDefinition
extends BindingBuilder.ContainerBase
implements IContainer {
    public static final String GENERATE_PREFIX = "JiBX_";
    static final String DEFAULT_AUTOPREFIX = "id_";
    private static final ArrayList s_bindings = new ArrayList();
    private static final ArrayMap s_mappedClasses = new ArrayMap();
    private static StringConversion s_byteConversion = new PrimitiveStringConversion(Byte.TYPE, new Byte(0), "B", "serializeByte", "parseByte", "attributeByte", "parseElementByte");
    private static StringConversion s_charConversion = new PrimitiveStringConversion(Character.TYPE, new Character('\u0000'), "C", "serializeChar", "parseChar", "attributeChar", "parseElementChar");
    private static StringConversion s_doubleConversion = new PrimitiveStringConversion(Double.TYPE, new Double(0.0), "D", "serializeDouble", "parseDouble", "attributeDouble", "parseElementDouble");
    private static StringConversion s_floatConversion = new PrimitiveStringConversion(Float.TYPE, new Float(0.0f), "F", "serializeFloat", "parseFloat", "attributeFloat", "parseElementFloat");
    private static StringConversion s_intConversion = new PrimitiveStringConversion(Integer.TYPE, new Integer(0), "I", "serializeInt", "parseInt", "attributeInt", "parseElementInt");
    private static StringConversion s_longConversion = new PrimitiveStringConversion(Long.TYPE, new Long(0L), "J", "serializeLong", "parseLong", "attributeLong", "parseElementLong");
    private static StringConversion s_shortConversion = new PrimitiveStringConversion(Short.TYPE, new Short(0), "S", "serializeShort", "parseShort", "attributeShort", "parseElementShort");
    private static StringConversion s_booleanConversion = new PrimitiveStringConversion(Boolean.TYPE, Boolean.FALSE, "Z", "serializeBoolean", "parseBoolean", "attributeBoolean", "parseElementBoolean");
    private static StringConversion s_dateConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeDateTime", "org.jibx.runtime.Utility.deserializeDateTime", "java.util.Date");
    public static StringConversion s_stringConversion = new ObjectStringConversion(null, null, null, "java.lang.String");
    public static StringConversion s_objectConversion = new ObjectStringConversion(null, null, null, "java.lang.Object");
    private static final String FACTORY_SUFFIX = "Factory";
    private static final String FACTORY_INTERFACE = "org.jibx.runtime.IBindingFactory";
    private static final String[] FACTORY_INTERFACES = new String[]{"org.jibx.runtime.IBindingFactory"};
    private static final String FACTORY_INSTNAME = "m_inst";
    private static final int FACTORY_INSTACCESS = 10;
    private static final String MARSHALLER_ARRAYNAME = "m_marshallers";
    private static final String UNMARSHALLER_ARRAYNAME = "m_unmarshallers";
    private static final String STRING_ARRAYTYPE = "java.lang.String[]";
    private static final String CLASSES_ARRAYNAME = "m_classes";
    private static final String URIS_ARRAYNAME = "m_uris";
    private static final String GNAMES_ARRAYNAME = "m_globalNames";
    private static final String GURIS_ARRAYNAME = "m_globalUris";
    private static final String IDNAMES_ARRAYNAME = "m_idNames";
    private static final String CREATEMARSHAL_METHODNAME = "createMarshallingContext";
    private static final String MARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IMarshallingContext";
    private static final String MARSHALCONTEXT_IMPLEMENTATION = "org.jibx.runtime.impl.MarshallingContext";
    private static final String MARSHALCONTEXTINIT_SIGNATURE = "([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V";
    private static final String CREATEUNMARSHAL_METHODNAME = "createUnmarshallingContext";
    private static final String UNMARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IUnmarshallingContext";
    private static final String UNMARSHALCONTEXT_IMPLEMENTATION = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String UNMARSHALCONTEXTINIT_SIGNATURE = "(I[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V";
    private static final String GETINST_METHODNAME = "getInstance";
    private final String m_name;
    private final int m_index;
    private final boolean m_isInput;
    private final boolean m_isOutput;
    private final boolean m_isIdGlobal;
    private final boolean m_isForwards;
    private final String m_autoPrefix;
    private String m_targetPackage;
    private File m_targetRoot;
    private ArrayMap m_uniqueIds;
    private ArrayMap m_namespaceUris;
    private DefinitionContext m_outerContext;
    private DefinitionContext m_activeContext;
    private boolean m_isMappedDone;
    private int m_mumIndex;
    private static byte[] s_blanks = "                                                   ".getBytes();

    public BindingDefinition(String name, boolean ibind, boolean obind, String auto, boolean glob, boolean forward) throws JiBXException {
        super(null);
        this.m_name = name;
        this.m_isInput = ibind;
        this.m_isOutput = obind;
        this.m_isIdGlobal = glob;
        this.m_isForwards = forward;
        this.m_autoPrefix = auto;
        this.m_styleDefault = 1;
        this.m_autoLink = 1;
        this.m_accessLevel = 0;
        this.m_nameStyle = 0;
        this.m_outerContext = this.m_activeContext = new DefinitionContext(this);
        this.m_activeContext = new DefinitionContext(this);
        this.m_namespaceUris = new ArrayMap();
        this.m_namespaceUris.findOrAdd("");
        this.m_outerContext.addNamespace(NamespaceDefinition.buildNamespace("http://www.w3.org/XML/1998/namespace", "xml"));
        this.m_outerContext.setDefaultConversion("byte:default", s_byteConversion);
        this.m_outerContext.setDefaultConversion("char:default", s_charConversion);
        this.m_outerContext.setDefaultConversion("double:default", s_doubleConversion);
        this.m_outerContext.setDefaultConversion("float:default", s_floatConversion);
        this.m_outerContext.setDefaultConversion("int:default", s_intConversion);
        this.m_outerContext.setDefaultConversion("long:default", s_longConversion);
        this.m_outerContext.setDefaultConversion("short:default", s_shortConversion);
        this.m_outerContext.setDefaultConversion("boolean:default", s_booleanConversion);
        this.m_outerContext.setDefaultConversion("Date:default", s_dateConversion);
        this.m_outerContext.setDefaultConversion("String:default", s_stringConversion);
        this.m_outerContext.setDefaultConversion("Object:default", s_objectConversion);
        this.m_index = s_bindings.size();
        s_bindings.add(this);
    }

    public BoundClass getBoundClass() {
        return null;
    }

    public int getStyleDefault() {
        return this.m_styleDefault;
    }

    public boolean setIdChild(IComponent child) {
        throw new IllegalStateException("Internal error - setIdChild for root");
    }

    public void setFactoryLocation(String tpack, File root) {
        this.m_targetPackage = tpack;
        this.m_targetRoot = root;
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean isInput() {
        return this.m_isInput;
    }

    public boolean isOutput() {
        return this.m_isOutput;
    }

    public boolean isIdGlobal() {
        return this.m_isIdGlobal;
    }

    public boolean isForwards() {
        return this.m_isForwards;
    }

    public String getPrefix() {
        return GENERATE_PREFIX + this.m_name;
    }

    public int getMappedClassIndex(String name) {
        if (this.m_isMappedDone) {
            throw new IllegalStateException("Internal error: Call out of sequence");
        }
        return s_mappedClasses.findOrAdd(name);
    }

    public int getMarshallerUnmarshallerIndex() {
        if (!this.m_isMappedDone) {
            this.m_isMappedDone = true;
            this.m_mumIndex = s_mappedClasses.size();
        }
        return this.m_mumIndex++;
    }

    public int getIdClassIndex(String name) {
        if (this.m_isIdGlobal) {
            return 0;
        }
        if (this.m_uniqueIds == null) {
            this.m_uniqueIds = new ArrayMap();
        }
        return this.m_uniqueIds.findOrAdd(name);
    }

    public int getNamespaceUriIndex(String name) {
        return this.m_namespaceUris.findOrAdd(name);
    }

    public void generateCode() throws JiBXException {
        this.m_activeContext.setLinkages();
        this.m_activeContext.generateCode();
        String name = this.m_targetPackage.length() == 0 ? this.getPrefix() + FACTORY_SUFFIX : this.m_targetPackage + '.' + this.getPrefix() + FACTORY_SUFFIX;
        ClassFile base = ClassCache.getClassFile("java.lang.Object");
        ClassFile cf = new ClassFile(name, this.m_targetRoot, base, 1, FACTORY_INTERFACES);
        ArrayList maps = this.m_activeContext.getMappings();
        int i = 0;
        while (i < maps.size()) {
            IMapping map = (IMapping)maps.get(i);
            map.getBoundClass().addFactory(name);
            ++i;
        }
        int count = s_mappedClasses.size();
        ClassItem inst = cf.addField(FACTORY_INTERFACE, FACTORY_INSTNAME, 10);
        ClassItem marshs = cf.addPrivateField(STRING_ARRAYTYPE, MARSHALLER_ARRAYNAME);
        ClassItem umarshs = cf.addPrivateField(STRING_ARRAYTYPE, UNMARSHALLER_ARRAYNAME);
        ClassItem classes = cf.addPrivateField(STRING_ARRAYTYPE, CLASSES_ARRAYNAME);
        ClassItem uris = cf.addPrivateField(STRING_ARRAYTYPE, URIS_ARRAYNAME);
        ClassItem gnames = cf.addPrivateField(STRING_ARRAYTYPE, GNAMES_ARRAYNAME);
        ClassItem guris = cf.addPrivateField(STRING_ARRAYTYPE, GURIS_ARRAYNAME);
        ClassItem idnames = cf.addPrivateField(STRING_ARRAYTYPE, IDNAMES_ARRAYNAME);
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder("<init>", Type.VOID, new Type[0], cf, 2);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendCallInit("java.lang.Object", "()V");
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        int i2 = 0;
        while (i2 < count) {
            String cname = (String)s_mappedClasses.get(i2);
            mb.append(InstructionConstants.DUP);
            mb.appendLoadConstant(i2);
            IMapping map = this.m_activeContext.getMappingAtLevel(cname);
            if (map == null) {
                mb.append(InstructionConstants.ACONST_NULL);
            } else {
                mb.appendLoadConstant(map.getUnmarshaller().getName());
            }
            mb.append(InstructionConstants.AASTORE);
            ++i2;
        }
        mb.appendPutField(umarshs);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        int i3 = 0;
        while (i3 < count) {
            String cname = (String)s_mappedClasses.get(i3);
            mb.append(InstructionConstants.DUP);
            mb.appendLoadConstant(i3);
            IMapping map = this.m_activeContext.getMappingAtLevel(cname);
            if (map == null) {
                mb.append(InstructionConstants.ACONST_NULL);
            } else {
                mb.appendLoadConstant(map.getMarshaller().getName());
            }
            mb.append(InstructionConstants.AASTORE);
            ++i3;
        }
        mb.appendPutField(marshs);
        int mcnt = this.m_isMappedDone ? this.m_mumIndex : count;
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendLoadConstant(mcnt);
        mb.appendCreateArray("java.lang.String");
        int i4 = 0;
        while (i4 < count) {
            mb.append(InstructionConstants.DUP);
            mb.appendLoadConstant(i4);
            mb.appendLoadConstant((String)s_mappedClasses.get(i4));
            mb.append(InstructionConstants.AASTORE);
            ++i4;
        }
        mb.appendPutField(classes);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendLoadConstant(this.m_namespaceUris.size());
        mb.appendCreateArray("java.lang.String");
        int i5 = 0;
        while (i5 < this.m_namespaceUris.size()) {
            mb.append(InstructionConstants.DUP);
            mb.appendLoadConstant(i5);
            mb.appendLoadConstant((String)this.m_namespaceUris.get(i5));
            mb.append(InstructionConstants.AASTORE);
            ++i5;
        }
        mb.appendPutField(uris);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        int i6 = 0;
        while (i6 < count) {
            NameDefinition ndef;
            String cname = (String)s_mappedClasses.get(i6);
            IMapping map = this.m_activeContext.getMappingAtLevel(cname);
            if (map != null && (ndef = map.getName()) != null) {
                mb.append(InstructionConstants.DUP);
                mb.appendLoadConstant(i6);
                ndef.genPushName(mb);
                mb.append(InstructionConstants.AASTORE);
            }
            ++i6;
        }
        mb.appendPutField(gnames);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        int i7 = 0;
        while (i7 < count) {
            NameDefinition ndef;
            String cname = (String)s_mappedClasses.get(i7);
            IMapping map = this.m_activeContext.getMappingAtLevel(cname);
            if (map != null && (ndef = map.getName()) != null) {
                mb.append(InstructionConstants.DUP);
                mb.appendLoadConstant(i7);
                ndef.genPushUri(mb);
                mb.append(InstructionConstants.AASTORE);
            }
            ++i7;
        }
        mb.appendPutField(guris);
        mb.append(InstructionConstants.ALOAD_0);
        if (this.m_uniqueIds != null && this.m_uniqueIds.size() > 0) {
            mb.appendLoadConstant(this.m_uniqueIds.size());
            mb.appendCreateArray("java.lang.String");
            int i8 = 0;
            while (i8 < this.m_uniqueIds.size()) {
                mb.append(InstructionConstants.DUP);
                mb.appendLoadConstant(i8);
                mb.appendLoadConstant((String)this.m_uniqueIds.get(i8));
                mb.append(InstructionConstants.AASTORE);
                ++i8;
            }
        } else {
            mb.append(InstructionConstants.ACONST_NULL);
        }
        mb.appendPutField(idnames);
        mb.append(InstructionConstants.RETURN);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(CREATEMARSHAL_METHODNAME, new ObjectType(MARSHALCONTEXT_INTERFACE), new Type[0], cf, 1);
        mb.appendCreateNew(MARSHALCONTEXT_IMPLEMENTATION);
        mb.append(InstructionConstants.DUP);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(classes);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(marshs);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(uris);
        mb.appendCallInit(MARSHALCONTEXT_IMPLEMENTATION, MARSHALCONTEXTINIT_SIGNATURE);
        mb.append(InstructionConstants.ARETURN);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(CREATEUNMARSHAL_METHODNAME, new ObjectType(UNMARSHALCONTEXT_INTERFACE), new Type[0], cf, 1);
        mb.appendCreateNew(UNMARSHALCONTEXT_IMPLEMENTATION);
        mb.append(InstructionConstants.DUP);
        mb.appendLoadConstant(mcnt);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(umarshs);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(guris);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(gnames);
        mb.append(InstructionConstants.ALOAD_0);
        mb.appendGetField(idnames);
        mb.appendCallInit(UNMARSHALCONTEXT_IMPLEMENTATION, UNMARSHALCONTEXTINIT_SIGNATURE);
        mb.append(InstructionConstants.ARETURN);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETINST_METHODNAME, new ObjectType(FACTORY_INTERFACE), new Type[0], cf, 9);
        mb.appendGetStatic(inst);
        BranchHandle ifdone = mb.append(new IFNONNULL(null));
        mb.appendCreateNew(cf.getName());
        mb.append(InstructionConstants.DUP);
        mb.appendCallInit(cf.getName(), "()V");
        mb.appendPutStatic(inst);
        ifdone.setTarget(mb.appendGetStatic(inst));
        mb.append(InstructionConstants.ARETURN);
        mb.codeComplete(false);
        mb.addMethod();
        MungedClass.getUniqueSupportClass(cf);
    }

    public static BindingDefinition getBinding(int index) {
        return (BindingDefinition)s_bindings.get(index);
    }

    public boolean isContentOrdered() {
        return true;
    }

    public boolean hasNamespaces() {
        return false;
    }

    public BindingDefinition getBindingRoot() {
        return this;
    }

    public DefinitionContext getDefinitionContext() {
        return this.m_activeContext;
    }

    public static void indent(int depth) {
        if (depth < s_blanks.length) {
            System.out.write(s_blanks, 0, depth);
        } else {
            System.out.print(s_blanks);
        }
    }

    public void print() {
        System.out.println("binding " + this.m_name + ":");
        this.m_activeContext.print(1);
    }
}

