/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.NestedBase;
import org.jibx.runtime.JiBXException;

public class NestedCollection
extends NestedBase {
    private final String m_itemType;
    private final CollectionLoad m_loadStrategy;
    private final CollectionStore m_storeStrategy;

    public NestedCollection(IContainer parent, IContextObj objc, boolean ord, String type, CollectionLoad load, CollectionStore store) {
        super(parent, objc, ord, false);
        this.m_itemType = type;
        this.m_loadStrategy = load;
        this.m_storeStrategy = store;
    }

    public boolean hasAttribute() {
        return false;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes present");
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes present");
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes present");
    }

    public boolean hasContent() {
        return this.m_contents.size() > 0;
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        BranchHandle link;
        if (this.m_contents.size() > 0) {
            this.m_storeStrategy.genStoreInit(mb);
            link = null;
            int count = this.m_contents.size();
            if (this.m_isOrdered) {
                int i = 0;
                while (i < count) {
                    InstructionHandle start = mb.append(InstructionConstants.NOP);
                    if (link != null) {
                        link.setTarget(start);
                    }
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.append(new IFEQ(null));
                    child.genContentUnmarshal(mb);
                    this.m_storeStrategy.genStoreItem(mb);
                    mb.append(new GOTO(start));
                    ++i;
                }
            } else {
                InstructionHandle first = mb.append(InstructionConstants.NOP);
                int i = 0;
                while (i < count) {
                    if (link != null) {
                        mb.targetNext(link);
                    }
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.append(new IFEQ(null));
                    child.genContentUnmarshal(mb);
                    this.m_storeStrategy.genStoreItem(mb);
                    mb.append(new GOTO(first));
                    ++i;
                }
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
        this.m_storeStrategy.genStoreDone(mb);
        mb.targetNext(link);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            String type;
            IComponent child;
            BranchHandle[] ifempties;
            BranchHandle link = null;
            this.m_loadStrategy.genLoadInit(mb);
            int count = this.m_contents.size();
            if (this.m_isOrdered) {
                ifempties = new BranchHandle[count];
                int i = 0;
                while (i < count) {
                    InstructionHandle start = mb.append(InstructionConstants.NOP);
                    ifempties[i] = this.m_loadStrategy.genLoadItem(mb);
                    mb.targetNext(link);
                    child = (IComponent)this.m_contents.get(i);
                    type = child.getType();
                    if (count > 1 || !"java.lang.Object".equals(type)) {
                        mb.append(InstructionConstants.DUP);
                        mb.appendInstanceOf(type);
                        link = mb.append(new IFEQ(null));
                        mb.appendCreateCast(type);
                    }
                    child.genContentMarshal(mb);
                    mb.append(new GOTO(start));
                    ++i;
                }
                mb.targetNext(link);
            } else {
                InstructionHandle start = mb.append(InstructionConstants.NOP);
                ifempties = new BranchHandle[]{this.m_loadStrategy.genLoadItem(mb)};
                int i = 0;
                while (i < count) {
                    mb.targetNext(link);
                    child = (IComponent)this.m_contents.get(i);
                    type = child.getType();
                    if (count > 1 || !"java.lang.Object".equals(type)) {
                        mb.append(InstructionConstants.DUP);
                        mb.appendInstanceOf(type);
                        link = mb.append(new IFEQ(null));
                        mb.appendCreateCast(type);
                    }
                    child.genContentMarshal(mb);
                    mb.append(new GOTO(start));
                    ++i;
                }
            }
            if (link != null) {
                mb.targetNext(link);
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.append(InstructionConstants.DUP);
                mb.appendLoadConstant("Collection item of type ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.append(InstructionConstants.SWAP);
                mb.append(InstructionConstants.DUP);
                BranchHandle ifnull = mb.append(new IFNULL(null));
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", "()Ljava/lang/String;");
                BranchHandle toend = mb.append(new GOTO(null));
                ifnull.setTarget(mb.append(InstructionConstants.POP));
                mb.appendLoadConstant("NULL");
                toend.setTarget(mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;"));
                mb.appendLoadConstant(" has no binding defined");
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", "()Ljava/lang/String;");
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.append(InstructionConstants.DUP_X1);
                mb.append(InstructionConstants.SWAP);
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.append(InstructionConstants.ATHROW);
            }
            this.m_loadStrategy.genLoadDone(mb);
            int i = 0;
            while (i < ifempties.length) {
                mb.targetNext(ifempties[i]);
                ++i;
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public boolean hasId() {
        return false;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        throw new IllegalStateException("No ID child");
    }

    public boolean checkContentSequence(boolean text) throws JiBXException {
        int i = 0;
        while (i < this.m_contents.size()) {
            IComponent content = (IComponent)this.m_contents.get(i);
            content.checkContentSequence(false);
            ++i;
        }
        return false;
    }

    public void setLinkages() throws JiBXException {
        int i = 0;
        while (i < this.m_contents.size()) {
            ((IComponent)this.m_contents.get(i)).setLinkages();
            ++i;
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("collection " + (this.m_isOrdered ? "ordered" : "unordered"));
        System.out.println();
        int i = 0;
        while (i < this.m_contents.size()) {
            IComponent comp = (IComponent)this.m_contents.get(i);
            comp.print(depth + 1);
            ++i;
        }
    }

    static class AddStore
    extends CollectionStore {
        private final ClassItem m_addMethod;
        private final boolean m_isReturned;

        AddStore(ClassItem add, boolean ret) {
            this.m_addMethod = add;
            this.m_isReturned = ret;
        }

        protected void genStoreItem(ContextMethodBuilder mb) throws JiBXException {
            mb.loadObject();
            mb.append(InstructionConstants.SWAP);
            mb.appendCall(this.m_addMethod);
            if (this.m_isReturned) {
                mb.append(InstructionConstants.POP);
            }
        }
    }

    static class IteratorLoad
    extends CollectionLoad {
        private final ClassItem m_iterMethod;
        private final String m_moreName;
        private final String m_nextName;

        IteratorLoad(ClassItem iter, String more, String next) {
            this.m_iterMethod = iter;
            this.m_moreName = more;
            this.m_nextName = next;
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
            mb.loadObject();
            mb.appendCall(this.m_iterMethod);
            mb.defineSlot(this.m_iterMethod, Type.INT);
        }

        protected BranchHandle genLoadItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_iterMethod);
            mb.append(InstructionFactory.createLoad(Type.INT, islot));
            mb.appendCallVirtual(this.m_moreName, "()Z");
            BranchHandle ifempty = mb.append(new IFEQ(null));
            mb.append(InstructionFactory.createLoad(Type.INT, islot));
            mb.appendCallVirtual(this.m_nextName, "()Ljava/lang/Object;");
            return ifempty;
        }

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_iterMethod);
        }
    }

    static class IndexedStore
    extends CollectionStore {
        private final ClassItem m_setMethod;

        IndexedStore(ClassItem set) {
            this.m_setMethod = set;
        }

        protected void genStoreInit(ContextMethodBuilder mb) throws JiBXException {
            mb.appendLoadConstant(-1);
            mb.defineSlot(this.m_setMethod, Type.INT);
        }

        protected void genStoreItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_setMethod);
            mb.loadObject();
            mb.append(InstructionConstants.SWAP);
            mb.append(new IINC(islot, 1));
            mb.append(InstructionFactory.createLoad(Type.INT, islot));
            mb.append(InstructionConstants.SWAP);
            mb.appendCall(this.m_setMethod);
        }

        protected void genStoreDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_setMethod);
        }
    }

    static class IndexedLoad
    extends CollectionLoad {
        private final ClassItem m_sizeMethod;
        private final ClassItem m_getMethod;

        IndexedLoad(ClassItem size, ClassItem get) {
            this.m_sizeMethod = size;
            this.m_getMethod = get;
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
            mb.appendLoadConstant(-1);
            mb.defineSlot(this.m_getMethod, Type.INT);
            mb.loadObject();
            mb.appendCall(this.m_sizeMethod);
            mb.defineSlot(this.m_sizeMethod, Type.INT);
        }

        protected BranchHandle genLoadItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_getMethod);
            int sslot = mb.getSlot(this.m_sizeMethod);
            mb.append(new IINC(islot, 1));
            mb.append(InstructionFactory.createLoad(Type.INT, islot));
            mb.append(InstructionFactory.createLoad(Type.INT, sslot));
            mb.append(InstructionConstants.ISUB);
            BranchHandle ifempty = mb.append(new IFGE(null));
            mb.loadObject();
            mb.append(InstructionFactory.createLoad(Type.INT, islot));
            mb.appendCall(this.m_getMethod);
            return ifempty;
        }

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_getMethod);
            mb.freeSlot(this.m_sizeMethod);
        }
    }

    static abstract class CollectionStore {
        CollectionStore() {
        }

        protected void genStoreInit(ContextMethodBuilder mb) throws JiBXException {
        }

        protected abstract void genStoreItem(ContextMethodBuilder var1) throws JiBXException;

        protected void genStoreDone(ContextMethodBuilder mb) throws JiBXException {
        }
    }

    static abstract class CollectionLoad {
        CollectionLoad() {
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
        }

        protected abstract BranchHandle genLoadItem(ContextMethodBuilder var1) throws JiBXException;

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
        }
    }
}

