/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.MarshalBuilder;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.runtime.JiBXException;

public class ObjectBinding
extends PassThroughComponent
implements IComponent,
IContextObj {
    private static final String[] MARSHAL_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)V", "(Ljava/lang/Object;)V", "()V"};
    private static final String[] FACTORY_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IUnmarshallingContext;)", "(Ljava/lang/Object;)", "()"};
    private static final String[] UNMARSHAL_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IUnmarshallingContext;)V", "(Ljava/lang/Object;)V", "()V"};
    private static final String UNMARSHAL_GETSTACKTOPMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.getStackTop";
    private static final String MARSHAL_GETSTACKTOPMETHOD = "org.jibx.runtime.impl.MarshallingContext.getStackTop";
    private static final String GETSTACKTOP_SIGNATURE = "()Ljava/lang/Object;";
    private static final String MARSHALLING_CONTEXT = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHALLING_CONTEXT = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String NEWINSTANCE_SIGNATURE = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)";
    private static final String UNMARSHAL_PUSHOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.pushObject";
    private static final String MARSHAL_PUSHOBJECTMETHOD = "org.jibx.runtime.impl.MarshallingContext.pushObject";
    private static final String PUSHOBJECT_SIGNATURE = "(Ljava/lang/Object;)V";
    private static final String UNMARSHAL_POPOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.popObject";
    private static final String MARSHAL_POPOBJECTMETHOD = "org.jibx.runtime.impl.MarshallingContext.popObject";
    private static final String POPOBJECT_SIGNATURE = "()V";
    private static final String NEWINSTANCE_SUFFIX = "_newinstance";
    private static final String UNMARSHAL_ATTR_SUFFIX = "_unmarshalAttr";
    private static final String MARSHAL_ATTR_SUFFIX = "_marshalAttr";
    private static final String UNMARSHAL_SUFFIX = "_unmarshal";
    private static final String MARSHAL_SUFFIX = "_marshal";
    private final IContainer m_container;
    private BoundClass m_class;
    private int m_styleDefault;
    private final ClassItem m_factoryMethod;
    private final ClassItem m_preSetMethod;
    private final ClassItem m_postSetMethod;
    private final ClassItem m_preGetMethod;
    private ClassItem m_newInstanceMethod;
    private ClassItem m_unmarshalAttributeMethod;
    private ClassItem m_marshalAttributeMethod;
    private ClassItem m_unmarshalContentMethod;
    private ClassItem m_marshalContentMethod;
    private IComponent m_idChild;

    public ObjectBinding(IContainer contain, IContextObj objc, String type, String fact, String pres, String posts, String pget) throws JiBXException {
        this.m_container = contain;
        BoundClass ctxc = objc == null ? null : objc.getBoundClass();
        this.m_class = BoundClass.getInstance(type, ctxc);
        if (fact == null) {
            this.m_factoryMethod = null;
        } else {
            int split = fact.lastIndexOf(46);
            if (split >= 0) {
                String cname = fact.substring(0, split);
                String mname = fact.substring(split + 1);
                ClassFile cf = ClassCache.getClassFile(cname);
                this.m_factoryMethod = cf.getMethod(mname, FACTORY_HOOK_SIGNATURES);
                if (!this.m_factoryMethod.getTypeName().equals(type)) {
                    throw new JiBXException("Factory method " + fact + " return type is not " + type);
                }
            } else {
                this.m_factoryMethod = null;
            }
            if (this.m_factoryMethod == null) {
                throw new JiBXException("Factory method " + fact + " not found.");
            }
        }
        if (pres == null) {
            this.m_preSetMethod = null;
        } else {
            this.m_preSetMethod = this.m_class.getClassFile().getMethod(pres, UNMARSHAL_HOOK_SIGNATURES);
            if (this.m_preSetMethod == null) {
                throw new JiBXException("User method " + pres + " not found.");
            }
        }
        if (posts == null) {
            this.m_postSetMethod = null;
        } else {
            this.m_postSetMethod = this.m_class.getClassFile().getMethod(posts, UNMARSHAL_HOOK_SIGNATURES);
            if (this.m_postSetMethod == null) {
                throw new JiBXException("User method " + posts + " not found.");
            }
        }
        if (pget == null) {
            this.m_preGetMethod = null;
        } else {
            this.m_preGetMethod = this.m_class.getClassFile().getMethod(pget, MARSHAL_HOOK_SIGNATURES);
            if (this.m_preGetMethod == null) {
                throw new JiBXException("User method " + pget + " not found.");
            }
        }
    }

    private void genUserMethodCall(boolean in, ClassItem method, ContextMethodBuilder mb) {
        int flags = method.getAccessFlags();
        if ((flags & 8) == 0) {
            mb.loadObject();
        }
        if (method.getArgumentCount() > 0) {
            mb.loadContext();
            String type = method.getArgumentType(0);
            if ("java.lang.Object".equals(type)) {
                String name = in ? UNMARSHAL_GETSTACKTOPMETHOD : MARSHAL_GETSTACKTOPMETHOD;
                mb.appendCallVirtual(name, GETSTACKTOP_SIGNATURE);
            }
        }
        mb.appendCall(method);
        mb.addMethodExceptions(method);
    }

    private void genNewInstanceCode(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_factoryMethod == null) {
            ClassFile cf = this.m_class.getClassFile();
            mb.appendCreateNew(cf.getName());
            mb.append(InstructionConstants.DUP);
            mb.appendCallInit(cf.getName(), POPOBJECT_SIGNATURE);
        } else {
            this.genUserMethodCall(true, this.m_factoryMethod, mb);
        }
    }

    private void genNewInstanceCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_newInstanceMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + NEWINSTANCE_SUFFIX;
            String sig = NEWINSTANCE_SIGNATURE + this.m_class.getClassFile().getSignature();
            ClassFile cf = this.m_class.getMungedFile();
            ContextMethodBuilder meth = new ContextMethodBuilder(name, sig, cf, 9, -1, this.m_class.getClassName(), 0, UNMARSHALLING_CONTEXT);
            this.genNewInstanceCode(meth);
            if (this.m_preSetMethod != null) {
                meth.storeObject();
                this.genUserMethodCall(true, this.m_preSetMethod, meth);
                meth.loadObject();
            }
            meth.append(InstructionConstants.ARETURN);
            this.m_newInstanceMethod = this.m_class.getUniqueMethod(meth).getItem();
        }
        mb.loadContext(UNMARSHALLING_CONTEXT);
        mb.appendCall(this.m_newInstanceMethod);
    }

    private void genUnmarshalAttributeCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_unmarshalAttributeMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + UNMARSHAL_ATTR_SUFFIX;
            UnmarshalBuilder meth = new UnmarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(UNMARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadObject();
            this.m_component.genAttributeUnmarshal(meth);
            meth.loadContext();
            meth.appendCallVirtual(UNMARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            if (this.m_postSetMethod != null && !this.hasContent()) {
                this.genUserMethodCall(true, this.m_postSetMethod, meth);
            }
            meth.append(InstructionConstants.RETURN);
            this.m_unmarshalAttributeMethod = this.m_class.getUniqueMethod(meth).getItem();
        }
        mb.loadContext(UNMARSHALLING_CONTEXT);
        mb.appendCall(this.m_unmarshalAttributeMethod);
    }

    private void genMarshalAttributeCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_marshalAttributeMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + MARSHAL_ATTR_SUFFIX;
            MarshalBuilder meth = new MarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            if (this.m_preGetMethod != null) {
                this.genUserMethodCall(false, this.m_preGetMethod, meth);
            }
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(MARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadContext();
            this.m_component.genAttributeMarshal(meth);
            meth.loadContext();
            meth.appendCallVirtual(MARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            meth.append(InstructionConstants.RETURN);
            this.m_marshalAttributeMethod = this.m_class.getUniqueMethod(meth).getItem();
        }
        mb.loadContext(MARSHALLING_CONTEXT);
        mb.appendCall(this.m_marshalAttributeMethod);
    }

    private void genUnmarshalContentCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_unmarshalContentMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + UNMARSHAL_SUFFIX;
            UnmarshalBuilder meth = new UnmarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(UNMARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadObject();
            this.m_component.genContentUnmarshal(meth);
            meth.loadContext();
            meth.appendCallVirtual(UNMARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            if (this.m_postSetMethod != null) {
                this.genUserMethodCall(true, this.m_postSetMethod, meth);
            }
            meth.append(InstructionConstants.RETURN);
            this.m_unmarshalContentMethod = this.m_class.getUniqueMethod(meth).getItem();
        }
        mb.loadContext(UNMARSHALLING_CONTEXT);
        mb.appendCall(this.m_unmarshalContentMethod);
    }

    private void genMarshalContentCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_marshalContentMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + MARSHAL_SUFFIX;
            MarshalBuilder meth = new MarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            if (this.m_preGetMethod != null && !this.hasAttribute()) {
                this.genUserMethodCall(false, this.m_preGetMethod, meth);
            }
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(MARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadContext();
            this.m_component.genContentMarshal(meth);
            meth.loadContext();
            meth.appendCallVirtual(MARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            meth.append(InstructionConstants.RETURN);
            this.m_marshalContentMethod = this.m_class.getUniqueMethod(meth).getItem();
        }
        mb.loadContext(MARSHALLING_CONTEXT);
        mb.appendCall(this.m_marshalContentMethod);
    }

    public BoundClass getBoundClass() {
        return this.m_class;
    }

    public boolean setIdChild(IComponent child) {
        if (this.m_idChild == null) {
            this.m_idChild = child;
            return true;
        }
        return false;
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genUnmarshalAttributeCall(mb);
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genMarshalAttributeCall(mb);
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genUnmarshalContentCall(mb);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genMarshalContentCall(mb);
    }

    public void genNewInstance(ContextMethodBuilder mb) throws JiBXException {
        this.genNewInstanceCall(mb);
    }

    public String getType() {
        return this.m_class.getClassName();
    }

    public boolean hasId() {
        return this.m_idChild != null;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_idChild == null) {
            throw new IllegalStateException("Internal error: no id defined");
        }
        this.m_idChild.genLoadId(mb);
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.println("object binding for " + this.m_class.getClassFile().getName());
        this.m_component.print(depth + 1);
    }
}

