/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.StackInstruction;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class PrimitiveStringConversion
extends StringConversion {
    private static ClassFile s_unmarshalClass;
    private static final int INT_TYPE = 0;
    private static final int LONG_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    private static final int DOUBLE_TYPE = 3;
    private static final String UTILITY_CLASS_NAME = "org.jibx.runtime.Utility";
    private static final String UNMARSHAL_CLASS_NAME = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String UNMARSHAL_SIG_LEAD = "(Ljava/lang/String;Ljava/lang/String;";
    private static final Class[] SINGLE_STRING_ARGS;
    private boolean m_isMarshalText;
    private boolean m_isUnmarshalText;
    private ClassItem m_unmarshalOptAttribute;
    private ClassItem m_unmarshalOptElement;
    private ClassItem m_unmarshalReqAttribute;
    private ClassItem m_unmarshalReqElement;
    private int m_valueType;
    private String m_stackType;
    static /* synthetic */ Class class$java$lang$String;

    protected PrimitiveStringConversion(String type, PrimitiveStringConversion inherit) {
        super(type, inherit);
        try {
            s_unmarshalClass = ClassCache.getClassFile(UNMARSHAL_CLASS_NAME);
        }
        catch (JiBXException ex) {
            // empty catch block
        }
        this.m_isMarshalText = inherit.m_isMarshalText;
        this.m_isUnmarshalText = inherit.m_isUnmarshalText;
        this.m_unmarshalOptAttribute = inherit.m_unmarshalOptAttribute;
        this.m_unmarshalOptElement = inherit.m_unmarshalOptElement;
        this.m_unmarshalReqAttribute = inherit.m_unmarshalReqAttribute;
        this.m_unmarshalReqElement = inherit.m_unmarshalReqElement;
        this.m_valueType = inherit.m_valueType;
        this.m_stackType = inherit.m_stackType;
    }

    public PrimitiveStringConversion(Class cls, Object dflt, String code, String ts, String fs, String uattr, String uelem) {
        super(dflt, "org.jibx.runtime.Utility." + ts, "org.jibx.runtime.Utility." + fs, cls.getName());
        try {
            s_unmarshalClass = ClassCache.getClassFile(UNMARSHAL_CLASS_NAME);
        }
        catch (JiBXException ex) {
            // empty catch block
        }
        this.m_isUnmarshalText = false;
        this.m_isMarshalText = false;
        String sig = UNMARSHAL_SIG_LEAD + code + ')' + code;
        this.m_unmarshalOptAttribute = s_unmarshalClass.getMethod(uattr, sig);
        this.m_unmarshalOptElement = s_unmarshalClass.getMethod(uelem, sig);
        sig = "(Ljava/lang/String;Ljava/lang/String;)" + code;
        this.m_unmarshalReqAttribute = s_unmarshalClass.getMethod(uattr, sig);
        this.m_unmarshalReqElement = s_unmarshalClass.getMethod(uelem, sig);
        if (cls == Long.TYPE) {
            this.m_valueType = 1;
            this.m_stackType = "long";
        } else if (cls == Float.TYPE) {
            this.m_valueType = 2;
            this.m_stackType = "float";
        } else if (cls == Double.TYPE) {
            this.m_valueType = 3;
            this.m_stackType = "double";
        } else {
            this.m_valueType = 0;
            this.m_stackType = "int";
        }
    }

    public void genFromText(MethodBuilder mb) {
        if (this.m_deserializer != null) {
            mb.addMethodExceptions(this.m_deserializer);
            mb.appendCall(this.m_deserializer);
        }
    }

    protected void pushDefault(MethodBuilder mb) {
        mb.appendLoadConstant(this.m_default);
    }

    public void genParseOptional(boolean attr, MethodBuilder mb) throws JiBXException {
        if (this.m_isUnmarshalText) {
            mb.appendLoadConstant((String)this.m_default);
            String name = attr ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
            mb.appendCallVirtual(name, "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
            this.genFromText(mb);
        } else {
            this.pushDefault(mb);
            mb.appendCall(attr ? this.m_unmarshalOptAttribute : this.m_unmarshalOptElement);
        }
    }

    public void genParseRequired(boolean attr, MethodBuilder mb) throws JiBXException {
        if (this.m_isUnmarshalText) {
            String name = attr ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
            mb.appendCallVirtual(name, "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
            this.genFromText(mb);
        } else {
            mb.appendCall(attr ? this.m_unmarshalReqAttribute : this.m_unmarshalReqElement);
        }
    }

    protected BranchHandle genToOptionalText(String type, MethodBuilder mb, int extra) throws JiBXException {
        StackInstruction dup;
        if (this.m_valueType == 1 || this.m_valueType == 3) {
            dup = InstructionConstants.DUP2;
            extra += 2;
        } else {
            dup = InstructionConstants.DUP;
            ++extra;
        }
        mb.append(dup);
        this.pushDefault(mb);
        BranchHandle ifne = null;
        switch (this.m_valueType) {
            case 1: {
                mb.append(InstructionConstants.LCMP);
                break;
            }
            case 2: {
                mb.append(InstructionConstants.FCMPG);
                break;
            }
            case 3: {
                mb.append(InstructionConstants.DCMPG);
                break;
            }
            default: {
                ifne = mb.append(new IF_ICMPNE(null));
            }
        }
        if (ifne == null) {
            ifne = mb.append(new IFNE(null));
        }
        this.genPopValues(extra, mb);
        BranchHandle toend = mb.append(new GOTO(null));
        mb.targetNext(ifne);
        this.genToText(this.m_stackType, mb);
        return toend;
    }

    protected Object convertDefault(String text) throws JiBXException {
        if (!this.m_isUnmarshalText) {
            try {
                String mname = this.m_deserializer.getName();
                String cname = this.m_deserializer.getClassFile().getName();
                Thread thread = Thread.currentThread();
                Class<?> clas = thread.getContextClassLoader().loadClass(cname);
                Method meth = clas.getMethod(mname, SINGLE_STRING_ARGS);
                return meth.invoke(null, text);
            }
            catch (IllegalAccessException ex) {
                throw new JiBXException("Conversion method not accessible", ex);
            }
            catch (InvocationTargetException ex) {
                throw new JiBXException("Internal error", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new JiBXException("Internal error", ex);
            }
            catch (ClassNotFoundException ex) {
                throw new JiBXException("Internal error", ex);
            }
        }
        return text;
    }

    public boolean isPrimitive() {
        return true;
    }

    protected void setSerializer(String ser) throws JiBXException {
        super.setSerializer(ser);
        this.m_isMarshalText = true;
    }

    protected void setDeserializer(String deser) throws JiBXException {
        super.setDeserializer(deser);
        this.m_isUnmarshalText = true;
    }

    public StringConversion derive(String type, String ser, String dser, String dflt) throws JiBXException {
        if (type == null) {
            type = this.m_typeName;
        }
        PrimitiveStringConversion inst = new PrimitiveStringConversion(type, this);
        if (ser != null) {
            ((StringConversion)inst).setSerializer(ser);
        }
        if (dser != null) {
            ((StringConversion)inst).setDeserializer(dser);
        }
        if (dflt != null) {
            inst.m_default = ((StringConversion)inst).convertDefault(dflt);
        }
        return inst;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SINGLE_STRING_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PrimitiveStringConversion.class$("java.lang.String")) : class$java$lang$String};
    }
}

