//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SortedTableModel.java
//	DATE:		2003.10.2
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model;

import javax.swing.table.TableModel;
import javax.swing.event.TableModelListener;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableInsertable;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;

public class SortedTableModel implements TableModel, TableInsertable {
	private TableModel mDecoratedModel;
	private TableInsertable mDecoratedInserter;
	private TableSortHandler mSortHandler;
	
	public SortedTableModel(
		TableModel inModel, TableInsertable inInserter, TableSortHandler inHandler) 
	{
		mDecoratedModel = inModel;
		mDecoratedInserter = inInserter;
		
		mSortHandler = inHandler;
		
		if (null != mSortHandler) {
			mSortHandler.setModel(this);
		}
	}
	
    /**
     * Returns the number of rows in the model. A
     * <code>JTable</code> uses this method to determine how many rows it
     * should display.  This method should be quick, as it
     * is called frequently during rendering.
     *
     * @return the number of rows in the model
     * @see #getColumnCount
     */
	public int getRowCount() {
		return mDecoratedModel.getRowCount();
	}

    /**
     * Returns the number of columns in the model. A
     * <code>JTable</code> uses this method to determine how many columns it
     * should create and display by default.
     *
     * @return the number of columns in the model
     * @see #getRowCount
     */
	public int getColumnCount() {
		return mDecoratedModel.getColumnCount();
	}

    /**
     * Returns the name of the column at <code>columnIndex</code>.  This is used
     * to initialize the table's column header name.  Note: this name does
     * not need to be unique; two columns in a table can have the same name.
     *
     * @param	inColIndex	the index of the column
     *
     * @return  the name of the column
     */
	public String getColumnName(int inColIndex) {
		return mDecoratedModel.getColumnName(inColIndex);
	}	

    /**
     * Returns the most specific superclass for all the cell values 
     * in the column.  This is used by the <code>JTable</code> to set up a 
     * default renderer and editor for the column.
     *
     * @param inColIndex  the index of the column
     *
     * @return the common ancestor class of the object values in the model.
     */
	public Class getColumnClass(int inColIndex) {
		return mDecoratedModel.getColumnClass(inColIndex);
	}

    /**
     * Returns true if the cell at <code>rowIndex</code> and
     * <code>columnIndex</code>
     * is editable.  Otherwise, <code>setValueAt</code> on the cell will not
     * change the value of that cell.
     *
     * @param	inRowIndex	the row whose value to be queried
     * @param	inColIndex	the column whose value to be queried
     *
     * @return	true if the cell is editable
     *
     * @see #setValueAt
     */
	public boolean isCellEditable(int inRowIndex, int inColIndex) {
		return mDecoratedModel.isCellEditable(inRowIndex, inColIndex);
	}

    /**
     * Returns the value for the cell at <code>columnIndex</code> and
     * <code>rowIndex</code>.
     *
     * @param	inRowIndex	the row whose value is to be queried
     * @param	inColIndex 	the column whose value is to be queried
     *
     * @return	the value Object at the specified cell
     */
	public Object getValueAt(int inRowIndex, int inColIndex) {
		int aResolvedIndex = inRowIndex;
		
		if (null != mSortHandler) {
			aResolvedIndex = mSortHandler.resolveRowIndex(inRowIndex);
		}
		
		return mDecoratedModel.getValueAt(aResolvedIndex, inColIndex);
	}

    /**
     * Sets the value in the cell at <code>columnIndex</code> and
     * <code>rowIndex</code> to <code>aValue</code>.
     *
     * @param	inValue		 the new value
     * @param	inRowIndex	 the row whose value is to be changed
     * @param	inColIndex 	 the column whose value is to be changed
     *
     * @see #getValueAt
     * @see #isCellEditable
     */
	public void setValueAt(Object inValue, int inRowIndex, int inColIndex) {
		int aResolvedIndex = inRowIndex;
		
		if (null != mSortHandler) {
			aResolvedIndex = mSortHandler.resolveRowIndex(inRowIndex);
		}
		
		mDecoratedModel.setValueAt(inValue, aResolvedIndex, inColIndex);
	}

    /**
     * Adds a listener to the list that is notified each time a change
     * to the data model occurs.
     *
     * @param	inListener		the TableModelListener
     */
	public void addTableModelListener(TableModelListener inListener) {
		mDecoratedModel.addTableModelListener(inListener);
	}

    /**
     * Removes a listener from the list that is notified each time a
     * change to the data model occurs.
     *
     * @param	inListener		the TableModelListener
     */
	public void removeTableModelListener(TableModelListener inListener) {
		mDecoratedModel.removeTableModelListener(inListener);
	}
	
	// TableInsertable interface
	
	/** 
	 *	s̍ŌɃf[^ǉ
	 *
	 *	@param	inRowData	ǉf[^
	 */
	public void addRow(Object[] inRowData) {
		mDecoratedInserter.addRow(inRowData);
	}
	
	/** 
	 *	w肵sɃf[^ǉ
	 *
	 *	@param	inRow		}sԍ
	 *	@param	inRowData	ǉf[^
	 */
	public void insertRow(final int inRow, Object[] inRowData) {
		mDecoratedInserter.insertRow(inRow, inRowData);
	}
	
	/** 
	 *	inColmunNameŎw肳ꂽɃf[^ǉ
	 *
	 *	@param	inColName	ǉ̖O
	 *	@param	inRowData		ǉf[^
	 */
	public void addColumn(Object inColName, Object[] inColData) {
		mDecoratedInserter.addColumn(inColName, inColData);
	}	
}