// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Board.java
//	DATE:		2003.7.11
//	CREATOR:	Kazuhiko TAMURA
// ***************************************************************************************


package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.Mutex;
import jp.gr.java_conf.ktz.puzzle.framework.view.Monitor;
import jp.gr.java_conf.ktz.puzzle.framework.view.AlreadyMonitoredException;

import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;

import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;

import jp.gr.java_conf.ktz.puzzle.framework.util.Command;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;


import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.RendererFactory;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;

/**
 *	ՖʂViewKw
 */
public final class Board extends java.awt.Canvas implements BoardView {
	/** Ֆʂ̃ftHg̕ */
	private static final int DEFAULT_BOARD_WIDTH = 9;

	/** Ֆʂ̃ftHg̍ */
	private static final int DEFAULT_BOARD_HEIGHT = 9;
	
	/** gbvxModelւ̎Q */
	private Model mModel = NullModel.getInstance();
	
	/** SolverHandler̎ */
	private SolverHandler mHandler;
	
	/** Ֆʂ̕`s_ */
	private DefaultRenderer mRenderer;
	
	/** View̐e */
	private BoardView mParent;
	
	private Mutex mMutex = new Mutex();
	private Monitor mMonitor;
	
	/** ՖʂɕύXꂽǂtO */
	private boolean mIsModified;
	
	/**
	 *	ftHgRXgN^
	 */
	public Board() {
	}
	
	/**
	 *	ViewKw
	 */
	public void initialize() {
		System.out.println("init");	
		
		// Rendereȑ
		mRenderer = SolverRendererFactory.create(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);
		
		// Canvas̏
		setBackground(AppColors.BACK_COLOR);
		createBoard(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);		

		// Piece size]
		PieceSizeCommand aCommand = new PieceSizeCommand(this, getPieceSize());
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
	
	/**
	 *	w肵Modelŏʂɉ
	 */
	public void addModel(AbstractDecoratedModel inModel) {
		inModel.addModel(mModel);
		mModel = inModel;
	}
		
	/**
	 *	w肵RendererZbg
	 */
	public void setRenderer(DefaultRenderer inRenderer) {
		mRenderer = inRenderer;
	}
	
	/** 
	 *	Command̏s
	 *	̎ł́ÃvZXŏłȂƂA
	 *	ʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		// ̃vZXŏłȂƂA
		// ܂́AʂCommandContainerŎw肵CommandƂ
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractBottomUpCommand) {
				mParent.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	ftHgCommand̎
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
			
			setComponentSize(aWidth, aHeight);
		}
		else if (aClass == LoadCommand.class) {
			ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
			load(aInfo);
			inCommand.consume();
		}
		else if (aClass == ResetCommand.class) {
			clear();
			inCommand.consume();
		}
		else if (aClass == NextCommand.class) {
			nextSolute();
			inCommand.consume();
		}
		else if (aClass == NextAllCommand.class) {
			nextSoluteAll();
			inCommand.consume();
		}
	}
	
	/**
	 *	ViewKw̐eݒ肷
	 *
	 *	@param	inBoard	eView
	 */
	public void setParent(BoardView inBoard) {
		mParent = inBoard;
	}
	
	/**
	 *	w肵[h
	 *
	 *	@param	inInfo	蕶
	 *
	 *	@throws	IllegalArgumentException inInfonullnꂽƂ
	 */
	private void load(final ProblemInfo inInfo) {
		class LoadRunner implements Runnable {
			private final int ONCE_READ_COUNT = 100;
			
			public synchronized void run() {
				final long t1 = System.currentTimeMillis();
				
				System.out.println("set problem");	
				
				if (mModel instanceof NullModel) {
					mModel = new SolverStateModel(
								new  BoardModel(mModel)
					);
					mHandler = new HashikakeSolverHandler(mModel);
				}
				
				createBoard(inInfo.getWidth(), inInfo.getHeight());
				
				try {
					int aReadPos = 0;
					int aOffset;
					
					do {
						ProblemInfo aInfo = new ProblemInfo(aReadPos, ONCE_READ_COUNT, inInfo);
						
						synchronized (mMutex) {
							aOffset = mModel.setProblem(aInfo);
						}
						
						aReadPos += aOffset;
						
						repaint();
						
						while (mModel.isModified()) {
							mMonitor.suspend();
						}
					}
					while(Integer.MIN_VALUE != aOffset);
				}
				finally {
					synchronized (mMutex) {
						// ՖʂύXꂽƂtOOFFɂ
						setModified(false);
						
						// handler
						mHandler.reset();
					}
					
					final long t2 = System.currentTimeMillis();
					System.out.println("ellapsed tile for load : " + (t2-t1) + " msec\n");
				}
			}
		}

		if (null == inInfo) throw new IllegalArgumentException("null object is passed to inInfo");
		
		if (isMonitored()) return;
		
		try {
			invokeInternalAction(new LoadRunner(), "Load Thread");
		}
		catch (AlreadyMonitoredException e) {
			System.out.println(e);
			return;
		}
	}
	
	/**
	 *	w肵TCY̔Ֆʂ쐬
	 *
	 *	@param	inWidth		Ֆʂ̕iBoardWnj
	 *	@param	inHeight	Ֆʂ̍iBoardWnj
	 */
	private void createBoard(final int inWidth, final int inHeight) {
		mRenderer.setSize(inWidth, inHeight);
		mModel.createBoard(inWidth, inHeight);
		
		java.awt.Dimension aSize = mRenderer.getBoardSize();

		BoardSizeCommand aCommand = new BoardSizeCommand(
								this, aSize.width, aSize.height
		);
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
	
	/**
	 *	w肵t@Cɖۑ
	 *	̎ł́Aۑ̓T|[gĂȂ
	 *
	 *	@param	inFile	ۑ
	 *
	 *	@throws	
	 */
	public void save(java.io.File inFile) {
		throw new UnsupportedOperationException(
			"This view isnot supported save method."
		);
	}
	
	/**
	 *	ՖʂύXĂ邩ǂmF
	 */
	public boolean isModified() {
		synchronized (mMutex) {
			return mIsModified;
		}
	}
	
	void setModified(final boolean inModified) {
		synchronized (mMutex) {
			mIsModified = inModified;
		}
	}
	
	/**
	 *	ViewɊ֘AtꂽR|[lgԂ
	 *
	 *	@return ViewɊ֘AtꂽR|[lg
	 */
	public java.awt.Component getComponent() {
		return this;
	}
	
	/**
	 *	w肵ActionʃXbhŎs
	 *
	 *	@param	inAction	sAction
	 *	@param	inThreadName	ThreadifobOpj
	 *
	 *	@throws	AlreadyMonitoredEWxception	ʂActionɎsĂꍇɓ
	 */
	void invokeInternalAction(Runnable inAction, String inThreadName) 
										throws AlreadyMonitoredException
	{
		// ɕʂ̃ANVsĂꍇ
		if (isMonitored()) {
			throw new AlreadyMonitoredException(inThreadName);
		}
		
		mMutex.lock();
		mMonitor = new Monitor(mMutex);
		
		new Thread(new ActionProxy(inAction), inThreadName).start();
	}
	
	/**
	 *	ʂActionsĂ邩ǂmF
	 */
	boolean isMonitored() {
		synchronized (mMutex) {
			return (null != mMonitor);
		}
	}
	
	/**
	 *	Z̃s[XTCY擾
	 *
	 *	@return	s[XTCY
	 */
	private int getPieceSize() {
		return mRenderer.getPieceSize().width;
	}
	
	/**
	 *	ՖʃTCYZbg
	 *
	 *	@param	inWidth	Ֆʂ̕iScreenWnj
	 *	@param	inWidth	Ֆʂ̍iScreenWnj
	 */
	private void setComponentSize(final int inWidth, final int inHeight) {
		setSize(inWidth, inHeight);
	}

	private void nextSolute() {
		if (isMonitored()) return;
		
		mHandler.nextSolute();
		if (mModel.isModified()) {
			repaint();
			
			// ՖʂύXꂽƂtOONɂ
			setModified(true);
		}
	}

	private void nextSoluteAll() {
		class SolveRunner implements Runnable {
			public void run() {
				long t1 = System.currentTimeMillis();
				
				try {
					boolean aResolved;
					do {
						aResolved = false;
						
						synchronized (mMutex) {
							aResolved = mHandler.nextSoluteAll();
						}
						
						if (mModel.isModified()) {
							repaint();
						}
						
						// ĕ`D悳邽߁AThreadsuspend
						while (mModel.isModified()) {
							mMonitor.suspend();
						}
					}
					while(! aResolved);
				}
				catch (SolveDiscompleteException e) {
					System.out.println(e);
				}
				finally {
					// ՖʂύXꂽƂtOONɂ
					setModified(true);
					
					long t2 = System.currentTimeMillis();
					System.out.println("(" +(t2-t1) + " msec elapsed)\n");
				}
			}
		}
		
		// ---
		
		if (isMonitored()) return;
		
		try {
			invokeInternalAction(new SolveRunner(), "Solver Thread");
		}
		catch (AlreadyMonitoredException e) {
			System.out.println(e);
			return;
		}
	}
	
	/**
	 *	̃t[Ɋ֘AtꂽViewɃtH[JX邩ǂ߂
	 *
	 *	@param	inFocused	tH[JXꍇAtruwn
	 */
	public void setFocus(boolean inFocused) {
		mParent.setFocus(inFocused);
	}
	
	/**
	 *	̃t[Ɋ֘AtꂽViewtH[JXǂ`FbN
	 *
	 *	@return	tH[JXꍇAtruwԂ
	 */
	public boolean isFocused() {
		return mParent.isFocused();
	}
	
	/**
	 *	ՖʂԂɖ߂
	 */
	private void clear() {
		class ClearRunner implements Runnable {
			private final int LOOP_LIMIT = 100;
		
			public void run() {
				int aLimit = LOOP_LIMIT;
				
				try {
					for (int y = 0; y < mModel.getHeight(); ++y) {
						for (int x = 0; x < mModel.getWidth(); ++x) {
							--aLimit;
							
							synchronized (mMutex) {
								mModel.resetAt(x, y);
							}
							
							if (0 == aLimit) {
								repaint();
								aLimit = LOOP_LIMIT;
								
								while (mModel.isModified()) {
									mMonitor.suspend();
								}
							}
						}
					}
				}
				finally {
					
					// CfĂȂꍇ
					if (mModel.isModified()) {
						repaint();
					}
					
					while (mModel.isModified()) {
						mMonitor.suspend();
					}
					
					synchronized (mMutex) {
						// ՖʂύXꂽƂtOOFFɂ
						setModified(false);
						
						// handler
						mHandler.reset();
					}
					
				}
			}
		}
		
		// --- 
		
		if (isMonitored()) return;
		
		// ՖʂύXĂȂꍇA͍sȂ
		if (! mIsModified) return;

		try {
			invokeInternalAction(new ClearRunner(), "Clear Thread");
		}
		catch (AlreadyMonitoredException e) {
			System.out.println(e);
			return;
		}
	}
	
	
	/**
	 *	w肵ScreenWn̈ʒuBoardWn̈ʒuɕϊ
	 *
	 *	@param	inX	XWiScreenWnj
	 *	@param	inY	YWiScreenWnj
	 *
	 *	@return	ϊ̍WiBoardWnj
	 */
	private Point calcPortToBoardPos(final int inX, final int inY) {
		return mRenderer.calcPortToBoardPos(inX, inY);
	}
	
	/**
	 *	ĕ`悷
	 */
	public void update(Graphics inGra) {
		paint(inGra);
	}
	
	/**
	 *	`悷
	 */
	public void paint(Graphics inGra) {
		Rectangle aBounds = inGra.getClipBounds();

		synchronized (mMutex) {
			if (mModel.isModified()) {
				aBounds = new Rectangle();
				
				Point[] aPos = mModel.lastModified();
				
				for (int i = 0; i < aPos.length; ++i) {
					mRenderer.render(aPos[i].x, aPos[i].y, mModel.getCurStateAt(aPos[i].x, aPos[i].y));
				}

				aBounds = getClipBounds();
			}
			
			inGra.drawImage(
					mRenderer.getImage(), 
					0, 0, 
					this
			);
			
			mModel.flush();
		}
		
		// 𓚓r̕`҂łꍇAThreadresume
		if (isMonitored()) {
			mMonitor.resume();
		}
	}
	
	/**
	 *	clip̈vZ
	 *
	 *	@return	clip̈
	 */
	private Rectangle getClipBounds() {
		return mRenderer.getClipBounds(mModel.lastModified());
	}
	
	private class ActionProxy implements Runnable {
		private Runnable mAction;
		
		ActionProxy(Runnable inAction) {
			mAction = inAction;
		}
		
		public void run() {
			try {
				mAction.run();
			}
			finally {
				synchronized (mMutex) {
					// bN
					mMutex.unlock();
					mMonitor = null;
				}
				System.gc();
			}
		}
	}
}