// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		TextUtility.java
//	DATE:		2003.6.4	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

/**
 *	eLXgɊւ郆[eBeBNX
 */
public class TextUtility {
	public static final int TRUNC_END = 0;
	public static final int TRUNC_MIDDLE = 1;
	
	/**
	 *	؂l߂
	 *	inTruncWhereTRUNC_ENDw肳ꂽꍇォA
	 *	TRUNC_MIDDLEw肳ꂽꍇ؂l߂
	 *
	 *	@param	inFM	\ɎgptHgFontMetrics
	 *	@param	inAvailWidth	\̕
	 *	@param	inString	̕
	 *	@param	inTruncWhere	؂l߂^Cv
	 */	 
	public static String truncText(
					java.awt.FontMetrics inFM, final int inAvailWidth, 
					String inString, final int inTruncWhere) 
	{
		if (inAvailWidth >= inFM.stringWidth(inString)) return inString;
		
		String aClip = "....";
		final int aClipWidth = inFM.stringWidth(aClip);
		String aRet = null;
		
		switch (inTruncWhere) {
		case TRUNC_END :
			for (int aTotalWidth = 0, i = 0; i < inString.length(); ++i) {
				aTotalWidth += inFM.charWidth(inString.charAt(i));
				if (inAvailWidth - aClipWidth <= aTotalWidth) {
					aRet = inString.substring(0, i) + aClip;
					break;
				}
			}
			
			break;
		
		case TRUNC_MIDDLE :
			for (int aTotalWidth = 0, i = 0; i < inString.length(); ++i) {
				aTotalWidth += inFM.charWidth(inString.charAt(i));
				if ((inAvailWidth - aClipWidth)/2 <= aTotalWidth) {
					aRet = inString.substring(0, i) + aClip;
					break;
				}
			}
			
			for (int aTotalWidth = 0, i = inString.length()-1; i >= 0; --i) {
				aTotalWidth += inFM.charWidth(inString.charAt(i));
				if ((inAvailWidth - aClipWidth)/2 <= aTotalWidth) {
					aRet += inString.substring(i+1);
					break;
				}
			}
			
			break;
			
		default :
			aRet = inString;
			break;
		} 
		
		return aRet;
	}
	
}
