/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.text;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class FileFormat
extends Format {
    private static final long serialVersionUID = 4128314642659824789L;
    private MessageFormat messageFormat = null;
    private String formatText = null;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileFormat(File file, String fileCharsetName) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        }
        if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        }
        if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        if (!file.isFile()) {
            throw new IOException("file-object is not a file.");
        }
        StringBuffer formatTextBuffer = new StringBuffer();
        InputStreamReader reader = null;
        try {
            int length = 0;
            int offset = 0;
            reader = new InputStreamReader(new FileInputStream(file));
            char[] ch = new char[8192];
            while ((length = reader.read(ch, offset, 8192)) > 0) {
                char[] ch2 = new char[length];
                System.arraycopy(ch, 0, ch2, 0, length);
                formatTextBuffer.append(ch2);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.formatText = new String(formatTextBuffer.toString().getBytes(fileCharsetName));
        this.messageFormat = new MessageFormat(formatTextBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileFormat(File file, String fileCharsetName, String formatLineSeparator) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this(file, fileCharsetName);
        if (formatLineSeparator == null) {
            throw new NullPointerException("format-line-separator is null.");
        }
        if (formatLineSeparator.length() == 0) {
            throw new IllegalArgumentException("format-line-separator is empty-string.");
        }
        BufferedReader br = null;
        StringBuffer formatTextBuffer = new StringBuffer();
        try {
            br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.formatText.getBytes())));
            String line = br.readLine();
            if (line != null) {
                formatTextBuffer.append(line);
            }
            while ((line = br.readLine()) != null) {
                formatTextBuffer.append(formatLineSeparator);
                formatTextBuffer.append(line);
            }
            char end = this.formatText.charAt(this.formatText.length() - 1);
            if (end == '\r' || end == '\n') {
                formatTextBuffer.append(formatLineSeparator);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        this.formatText = new String(formatTextBuffer.toString());
        this.messageFormat = new MessageFormat(formatTextBuffer.toString());
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return this.messageFormat.format(obj, toAppendTo, pos);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.messageFormat.parseObject(source, pos);
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        return this.messageFormat.formatToCharacterIterator(obj);
    }

    public Object parseObject(String source) throws ParseException {
        return this.messageFormat.parseObject(source);
    }

    public Object clone() {
        FileFormat other = (FileFormat)super.clone();
        other.formatText = new String(this.formatText);
        other.messageFormat = (MessageFormat)this.messageFormat.clone();
        return other;
    }
}

