/*
 * HFileWriter.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.io;

import java.io.*;

/**
 * t@Cói݁jsNXłB
 * t@C쐬ۂɓ̃t@C݂ꍇ̓V[PXԍtA
 * ̃t@C㏑̂h܂B
 * V[PXԍt^ꂽۂ̃t@C̃p^[
 * {@link HFile#getOtherFileName(String, int) HFile#getOtherFileName(String, int)},
 * {@link HFile#getOtherFileName(String) HFile#getOtherFileName(String)}Ɉˑ܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HFileWriter extends HWriter {
    
    //ۑt@C
    private HFile hFile = null;
    //fBNgtO
    private boolean directoryFlg = false;
    //V[PXԍ̕t
    private String alias = null;
    //V[PXԍ̌
    private int digit = 0;
//    //̓Xg[
//    private InputStream inputStream = null;

    /**
     * t@Cói݁jIuWFNg𐶐܂B
     * V[PXԍ̕t͗LłAw͂܂B
     * 
     * @param filePath 쐬t@CpX
     * @param directoryFlg fBNgꍇtrueAłȂfalse
     * @param alias GCAX
     * @throws IOException filePathsȏꍇ
     * @since 2.0
     */
    public HFileWriter(String filePath, boolean directoryFlg, String alias) throws IOException {
        this(new HFile(filePath), directoryFlg, alias);
    }
    
    /**
     * t@Cói݁jIuWFNg𐶐܂B
     * V[PXԍ̕t͗LłAw͂܂B
     * 
     * @param hFile 쐬t@CHFileIuWFNg
     * @param directoryFlg fBNgꍇtrueAłȂfalse
     * @param alias GCAX
     * @since 2.0
     */
    public HFileWriter(HFile hFile, boolean directoryFlg, String alias) {
        this(hFile, directoryFlg, alias, -1);
    }    

    /**
     * t@Cói݁jIuWFNg𐶐܂B
     * w肵̃V[PXԍ̕ts܂B
     * <br><br>
     * 1ȏw肷KvA̒lw肷ƌw肪Ȃ̂ƓlA
     * 0w肷ƃV[PXԍ̕tƂȂ܂B
     * 
     * @param filePath 쐬t@CpX
     * @param directoryFlg fBNgꍇtrueAłȂfalse
     * @param alias GCAX
     * @param digit tV[PXԍ̌
     * @throws IOException filePaths
     * @since 2.0
     */
    public HFileWriter(String filePath, boolean directoryFlg, String alias, int digit) throws IOException {
        this(new HFile(filePath), directoryFlg, alias, digit);
    }    

    /**
     * t@Cói݁jIuWFNg𐶐܂B
     * w肵̃V[PXԍ̕ts܂B
     * <br><br>
     * 1ȏw肷KvA̒lw肷ƌw肪Ȃ̂ƓlA
     * 0w肷ƃV[PXԍ̕tƂȂ܂B
     * 
     * @param hFile 쐬t@CHFileIuWFNg
     * @param directoryFlg fBNgꍇtrueAłȂfalse
     * @param alias GCAX
     * @param digit tV[PXԍ̌
     * @since 2.0
     */
    public HFileWriter(HFile hFile, boolean directoryFlg, String alias, int digit) {
        if(hFile == null){
            throw new NullPointerException("HFile-object is null.");
        }
        this.hFile = hFile;
        this.directoryFlg = directoryFlg;
        this.alias = alias;
        this.digit = digit;
    }

    /**
     * w肵Xg[̃f[^t@Cɏ݂܂B
     * t@C̓IuWFNgɃRXgN^Ŏw肵t@CłB
     * 
     * @param is ̓Xg[
     * @throws IOException
     *          ݂Ɏsꍇ
     * @since 2.0
     */
    public void write(InputStream is) throws IOException {
        try {
            makeOutputFile();
        } catch (IOException e) {
            throw e;
        }
        if (directoryFlg) {
            makeDirectory();
        }
        // o̓Xg[쐬Af[^擾E쐬
        FileOutputStream fos = new FileOutputStream(hFile);
        try {
            write(is, fos);
        } finally {
            if(fos != null){
                fos.close();
            }            
        }
    }

    /**
     * f[^ލۂɃfBNg쐬܂B
     * KvɉăI[o[ChĂB
     * 
     * @since 2.0
     */
    protected void makeDirectory(){
        File directory = hFile.getParentFile();
        if (directory != null) {
            if (!directory.exists()) {
                directory.mkdirs();
            }
        }
    }

    /**
     * f[^ނ߂̐VKo̓t@CIuWFNg쐬̂߂̃WbN`܂B
     * KvɉăI[o[ChĂB
     * 
     * @throws IOException VKo̓t@C̃pXsƂȂꍇ
     * @since 2.0
     */
    protected void makeOutputFile() throws IOException {        
        String outputFilePath = null;        
        if (digit <= -1) {
            outputFilePath = hFile.getOtherFileName(alias);
        } else {
            outputFilePath = hFile.getOtherFileName(alias, digit);
        }
        hFile = new HFile(outputFilePath);
    }

//    /**
//     * ݒ肵ĂXg[̃f[^t@Cɏ݂܂B
//     * t@C̓IuWFNgɃRXgN^Ŏw肵t@CłB
//     * 
//     * @throws IOException
//     *          ݂Ɏsꍇ
//     * @since 2.0
//     */
//    public void write() throws IOException {
//        if (inputStream == null) {
//            throw new NullPointerException("Input-stream is null.");
//        }
//        write(inputStream);
//    }
//
//    /**
//     * t@Cɏޓ͌̃Xg[w肵܂B
//     * 
//     * @param is ̓Xg[
//     * @since 2.0
//     */
//    public void setInputStream(InputStream is) {
//        this.inputStream = is;
//    }
//    
//    /**
//     * t@Cɏ񂾓͌̃Xg[܂B
//     * 
//     * @throws IOException
//     *          Xg[N[YłȂꍇ
//     * @since 2.0
//     */
//    public void close() throws IOException {
//        if (inputStream != null) {
//            inputStream.close();
//        }
//        inputStream = null;
//    }
}
