/*
 * HttpUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.net;

import java.net.*;

/**
 * HTTP֌W̃[eBeBNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HttpUtil {
    
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String HTTP2 = "http://";
    private static final String HTTPS2 = "https://";
    private static final String DELIMITER = "/";
    private static final String DOT = ".";

	// RXgN^͍쐬Ȃ
    private HttpUtil(){        
    }

    /**
     * HttpURLConnectionɃt@(Referer)ݒ肵܂B
     * 
     * @param connection HttpURLConnectionIuWFNg
     * @param referer t@(Referer)
     * @throws NullPointerException
     *          connectionnull̏ꍇ
     * @since 2.0
     */
    public static void setReferer(HttpURLConnection connection, String referer){
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        connection.setRequestProperty("Referer", referer);
    }


    /**
     * HttpURLConnectionɃt@(Referer)ݒ肵܂B
     * 
     * @param connection HttpURLConnectionIuWFNg
     * @return t@(Referer)
     * @throws NullPointerException
     *          connectionnull̏ꍇ
     * @since 2.0
     */
    public static String getReferer(HttpURLConnection connection){
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }        
        return connection.getRequestProperty("Referer");
    }
 

    /**
     * HttpURLConnectionɃ[UG[WFg(User-Agent)ݒ肵܂B
     * 
     * @param connection HttpURLConnectionIuWFNg
     * @param userAgent [UG[WFg(User-Agent)
     * @throws NullPointerException
     *          connectionnull̏ꍇ
     * @since 2.0
     */
    public static void setUserAgent(HttpURLConnection connection, String userAgent){
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        connection.setRequestProperty("User-Agent", userAgent);
    }
    

    /**
     * HttpURLConnection 烆[UG[WFg(User-Agent)擾܂B
     * 
     * @param connection HttpURLConnectionIuWFNg
     * @return [UG[WFg(User-Agent)
     * @throws NullPointerException
     *          connectionnull̏ꍇ
     * @since 2.0
     */
    public static String getUserAgent(HttpURLConnection connection){
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        return connection.getRequestProperty("User-Agent");
    }
    

    /**
     * ANZX̔F؂s܂B
     * F؉\ł̂WebT[osBasicF؂DigestF؂łB
     * 
     * @param user [U
     * @param pass pX[h
     * @throws NullPointerException
     *          null̏ꍇ
     * @since 2.0
     */
    public static void setAuthentication(final String user, final String pass){

        if (user == null) {
            throw new NullPointerException("User is null.");
        }
        if (pass == null) {
            throw new NullPointerException("Pass is null.");
        }
        
        class InAuth extends Authenticator {
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user , pass.toCharArray());
            }
        }

        Authenticator auth = new InAuth();
        Authenticator.setDefault(auth);
    }
    
    /**
     * w肳ꂽURĹAHTTP`ƂĂ̐𔻒肵܂B
     * HttpUtilŎgĂ郁\bhURĽ``FbN͂̃\bhA͓@𗘗pĂ܂B
     * <br><br>
     * ȉ̏𖞂̂URLƔf܂B
     * <ul>
     * <li>召֌WȂuhttp://vn܂</li>
     * <li>召֌WȂuhttps://vn܂</li>
     * </ul>
     * 
     * @param url 肷URL
     * @return `łtrueAȂfalse
     * @since 2.0
     */
    public static boolean checkFormat(String url) {
        if (url == null) {
            throw new NullPointerException("URL is null.");
        }
        String lUrl = url.toLowerCase();
        if (lUrl.startsWith(HTTP2)) {
            // http://
        } else if (lUrl.startsWith(HTTPS2)) {
            // https://
        } else {
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽURĹAHTTPHTTPS̃vgRƂĂ̐𔻒肵܂B
     * 
     * @param url URLIuWFNg
     * @return HTTPHTTPS̃vgRłtrueAȊOȂfalse
     * @throws NullPointerException
     *          urlnull̏ꍇ
     * @since 2.0
     */
    public static boolean checkProtocol(URL url) throws NullPointerException {
        if (url == null) {
            throw new NullPointerException("URL is null.");
        }
        return checkProtocol(url.getProtocol());
    }

    /**
     * w肳ꂽvgR()́AHTTPHTTPS̃vgRƂĂ̐𔻒肵܂B
     * 
     * @param protocol vgR
     * @return HTTPHTTPS̃vgRłtrueAȊOȂfalse
     * @throws NullPointerException
     *          protocolnull̏ꍇ
     * @since 2.0
     */
    public static boolean checkProtocol(String protocol) {
        if (protocol == null) {
            throw new NullPointerException("Protocol is null.");
        }

        if (protocol.compareToIgnoreCase(HTTP) == 0) {
            return true;
        } else if (protocol.compareToIgnoreCase(HTTPS) == 0) {
            return true;
        }
        return false;
    }
    
    /**
     * w肳ꂽURLgq𒊏o܂B
     * URLuhttp://v́uhttps://vn܂ꍇ̂ݒo܂B
     * gqw肳ĂȂt@CւURL̏ꍇA󕶎擾A
     * u/vŏIꍇzXĝ݂̏ꍇnull擾܂B
     * <br><br>
     * ȉ URL ̌`ɑ΂Ă̒oʂ̗łB
     * <ul>
     * <li>http://www.sample.com/abc.txt  txt</li>
     * <li>http://www.sample.com/.txt  txt</li>
     * <li>http://www.sample.com/abc/  null</li>
     * <li>http://www.sample.com/abc  &quot;&quot;</li>
     * <li>http://www.sample.com  null</li>
     * </ul>
     * 
     * @param url \[XURL
     * @return ogq
     * @throws NullPointerException
     *          urlnull̏ꍇ
     * @throws IllegalArgumentException
     *          urlHTTPHTTPS`ł͂Ȃꍇ
     * @since 2.0
     */
    public static String getExtension(String url) throws NullPointerException, IllegalArgumentException {
        if (url == null) {
            throw new NullPointerException("URL is null.");
        }
        
        String extension = null;
        String lUrl = url.toLowerCase();
        if (lUrl.startsWith(HTTP2)) {
            // http:// ̏ꍇ
            extension = getExtension2(url, HTTP2);
        } else if (lUrl.startsWith(HTTPS2)) {
            // https:// ̏ꍇ
            extension = getExtension2(url, HTTPS2);
        } else {
            throw new IllegalArgumentException("URL is not a http-format.");
        }
        return extension;
    }
    
    private static String getExtension2(String url, String protocol) {
        StringBuffer sbUrl = new StringBuffer(url);
        if (sbUrl.length() > protocol.length()) {
            sbUrl.delete(0, protocol.length());
            int pos = sbUrl.lastIndexOf(DELIMITER);
            if (pos == -1 && protocol.length() > 0) {
                return null;
            } else if (pos == sbUrl.length() - 1) {
                return null;
            } else {
                if (pos == -1) {
                    pos = 0;
                }
                sbUrl.delete(0, pos + 1);
                pos = sbUrl.lastIndexOf(DOT);
                if (pos == -1) {
                    return "";
                } else if (pos == sbUrl.length() - 1) {
                    return "";
                } else {
                    return sbUrl.delete(0, pos + 1).toString();
                }
            }
        }
        throw new IllegalArgumentException("url is not a " + protocol);
    }

    /**
     * w肵́AHTTP`ƂĂ̐𔻒肵܂B
     * 
     * @param str Ώۂ̕
     * @return HTTP`̕łtrueAȊOfalse
     * @since 2.0
     */
    public static boolean isHttpUrl(String str) {

        // null̏ꍇfalseԂ
        if (str == null) {
            return false;
        }
        // 擪"http://", "https://"łtrueԂ
        str = str.toLowerCase();
        if (str.startsWith("http://") || str.startsWith("https://")) {
            return true;
        }

        return false;
    }
}
