/*
 * NetUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.net;

/**
 * lbg֌W̃[eBeBNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class NetUtil {

    /** MACAhX̃INebgłB */
    public static final int MAC_ADDRESS_LENGTH = 6;

    /**
     * MACAhXINebg(byte)ɕ܂B
     * ɂ́u:v́u-vg܂B
     * 
     * @param macAddress MACAhX
     * @return MACAhXINebgɕϊl
     */
    public static byte[] octetMacAddress(String macAddress) {
        return octetMacAddress(macAddress, "(\\:|\\-)");
    }
    
    /**
     * MACAhXINebg(byte)ɕ܂B
     * 
     * @param macAddress MACAhX
     * @param delim ؂蕶
     * @return MACAhXINebgɕϊl
     */
    public static byte[] octetMacAddress(String macAddress, String delim) {

        //INebgϊMACAhX
        byte[] byteMacAddress = null;
        //String񕪊MACAhX
        String[] splitMacAddress = null;     

        //sMACAhX`FbN
        if (macAddress == null) {
            throw new NullPointerException("Mac-Address is null.");
        }
        
        //؂蕶null͋󕶎͋؂蕶Ƃĕ
        if (delim == null || delim.length() == 0) {
            
            //sMACAhX`FbN
            if (macAddress.length() != MAC_ADDRESS_LENGTH * 2) {
                throw new IllegalArgumentException("Mac-Address is invalid.");
            }

            //
            splitMacAddress = new String[MAC_ADDRESS_LENGTH];
            for (int i = 0; i < MAC_ADDRESS_LENGTH; i++) {
                int index = i * 2;
                splitMacAddress[i] = macAddress.substring(index, index + 2);
            }

        //؂蕶ŕ
        } else {
            //
            splitMacAddress = macAddress.split(delim);

            //sMACAhX`FbN
            if (splitMacAddress.length != MAC_ADDRESS_LENGTH) {
                throw new IllegalArgumentException("Mac-Address is invalid.");
            }
        }

        //INebg(byte)ɕϊ
        byteMacAddress = new byte[MAC_ADDRESS_LENGTH];
        for (int i = 0; i < MAC_ADDRESS_LENGTH; i++) {
            byteMacAddress[i] = (byte) Integer.parseInt(splitMacAddress[i], 16);
        }
        return byteMacAddress;
    }
}
