/*
 * FileFormat.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.text;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;

/**
 * eLXgt@C̓eMessageFormatƂĈ܂B
 * @version 2.1
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.1
 */
public class FileFormat extends Format{

    /**
     * 
     */
    private static final long serialVersionUID = 4128314642659824789L;

    private MessageFormat messageFormat = null;
    private String formatText = null;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;

    /**
     * RXgN^B
     * ̕R[h̓ftHg̕R[hAsR[h̓t@C̉sR[hƂȂ܂B
     * 
     * @param file t@C
     * @param fileCharsetName t@C̕R[h
     * @throws UnsupportedEncodingException R[hT|[gO
     * @throws FileNotFoundException t@C݂Ȃ
     * @throws IOException t@CIOG[
     */
    public FileFormat(File file, String fileCharsetName)
            throws UnsupportedEncodingException, FileNotFoundException, IOException {

        //`FbN
        if (file == null) {
            throw new NullPointerException("file is null.");
        } else if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        } else if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }

        //t@Cł邱Ƃ̃`FbN
        if (file.isFile() == false) {
            throw new IOException("file-object is not a file.");
        }
        
        StringBuffer formatTextBuffer = new StringBuffer();
        InputStreamReader reader = null;
        try {
            int length = 0;
            int offset = 0;
            reader = new InputStreamReader(new FileInputStream(file));
            char[] ch = new char[DEFAULT_BUFFER_SIZE];
            //DEFAULT_BUFFER_SIZEoCg̓ǂݍ
            while ((length = reader.read(ch, offset, DEFAULT_BUFFER_SIZE)) > 0) {
                char[] ch2 = new char[length];
                System.arraycopy(ch, 0, ch2, 0, length);
                formatTextBuffer.append(ch2);
            }
            
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        //t@C̕R[hw肵AftHg̕R[hɕϊ
        this.formatText = new String(formatTextBuffer.toString().getBytes(fileCharsetName));
        this.messageFormat = new MessageFormat(formatTextBuffer.toString());
    }

    /**
     * RXgN^B
     * ̕R[h̓ftHg̕R[hAsR[h͎w肵sR[hƂȂ܂B
     * 
     * @param file t@C
     * @param fileCharsetName t@C̕R[h
     * @param formatLineSeparator tH[}bg̉sR[h
     * @throws UnsupportedEncodingException R[hT|[gO
     * @throws FileNotFoundException t@C݂Ȃ
     * @throws IOException t@CIOG[
     */
    public FileFormat(File file, String fileCharsetName, String formatLineSeparator)
            throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this(file, fileCharsetName);

        if (formatLineSeparator == null) {
            throw new NullPointerException("format-line-separator is null.");
        } else if (formatLineSeparator.length() == 0) {
            throw new IllegalArgumentException("format-line-separator is empty-string.");
        }
        
        BufferedReader br = null;
        StringBuffer formatTextBuffer = new StringBuffer();
        try {
            //t@C̉sR[h̔ʂBufferedReader.readLineōs
            br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.formatText.getBytes())));
            String line = br.readLine();
            if (line != null) {
                formatTextBuffer.append(line);
            }
            while ((line = br.readLine()) != null) {
                formatTextBuffer.append(formatLineSeparator);
                formatTextBuffer.append(line);
            }
            char end = this.formatText.charAt(this.formatText.length() - 1);
            if (end == '\r' || end == '\n') {
                formatTextBuffer.append(formatLineSeparator);
            }
        } finally {
            if (br != null) {
                br.close();
            }
        }
        this.formatText = new String(formatTextBuffer.toString());
        this.messageFormat = new MessageFormat(formatTextBuffer.toString());
    }

    /*
     * ( Javadoc)
     * @see java.text.Format#format(java.lang.Object, java.lang.StringBuffer, java.text.FieldPosition)
     */
    public StringBuffer format(Object obj, StringBuffer toAppendTo,
            FieldPosition pos) {
        return this.messageFormat.format(obj, toAppendTo, pos);
    }

    /*
     * ( Javadoc)
     * @see java.text.Format#parseObject(java.lang.String, java.text.ParsePosition)
     */
    public Object parseObject(String source, ParsePosition pos) {
        return this.messageFormat.parseObject(source, pos);
    }

    /*
     * ( Javadoc)
     * @see java.text.Format#formatToCharacterIterator(java.lang.Object)
     */
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        return this.messageFormat.formatToCharacterIterator(obj);
    }

    /*
     * ( Javadoc)
     * @see java.text.Format#parseObject(java.lang.String)
     */
    public Object parseObject(String source) throws ParseException {
        return this.messageFormat.parseObject(source);
    }

    /*
     * ( Javadoc)
     * @see java.text.Format#clone()
     */
    public Object clone() {
        FileFormat other = (FileFormat)super.clone();
        other.formatText = new String(this.formatText);
        other.messageFormat = (MessageFormat)messageFormat.clone();
        return other;
    }

}
