/*
 * WakeOnLanTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.java.net;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;

import jp.hrtdotnet.java.HTestCase;

/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class WakeOnLanTest extends HTestCase {

    private String broadAddress = "255.255.255.255";
    private String macAddress = "";
    private String macAddress2 = "";
    private byte[] macAddressBytes = new byte[]{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00};
    
    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        broadAddress = testClassResources.getString("broadAddress");
        macAddress = testClassResources.getString("macAddress");
        macAddress2 = testClassResources.getString("macAddress2");
        String tmp = testClassResources.getString("macAddressBytes");
        if (tmp != null && tmp.length() != 0) {
            macAddressBytes = NetUtil.octetMacAddress(tmp);
        }
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#execute(java.lang.String, int, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws SocketException 
     * @throws UnknownHostException 
     */
    public void testExecute_StringIntString() throws UnknownHostException, SocketException, IOException {
        if (testClassResources.isTestMethod("testExecute_StringIntString") == false) return;
        WakeOnLan.execute(broadAddress, 7010, macAddress);
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#execute(java.lang.String, int, java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws SocketException 
     * @throws UnknownHostException 
     */
    public void testExecute_StringIntStringString() throws UnknownHostException, SocketException, IOException {
        if (testClassResources.isTestMethod("testExecute_StringIntStringString") == false) return;
        System.out.println("hoge");
        WakeOnLan.execute(broadAddress, 7010, macAddress2, ";");
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#execute(java.lang.String, int, byte[])} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws SocketException 
     * @throws UnknownHostException 
     */
    public void testExecute_StringIntByteArray() throws UnknownHostException, SocketException, IOException {
        if (testClassResources.isTestMethod("testExecute_StringIntByteArray") == false) return;
        System.out.println("hoge");
        WakeOnLan.execute(broadAddress, 7010, macAddressBytes);
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#executeMagicPacket(java.lang.String, int, byte[])} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws SocketException 
     * @throws SecurityException 
     * @throws UnknownHostException 
     */
    public void testExecuteMagicPacket() throws UnknownHostException, SecurityException, SocketException, IOException {
        if (testClassResources.isTestMethod("testExecuteMagicPacket") == false) return;
        System.out.println("hoge");
        byte[] magicPacket = new byte[102];
        for (int i = 0; i < 6; i++) {
            magicPacket[i] = (byte)0xff;
        }
        for (int i = 1; i < 17; i++) {
            magicPacket[i * 6] = macAddressBytes[0];
            magicPacket[i * 6 + 1] = macAddressBytes[1];
            magicPacket[i * 6 + 2] = macAddressBytes[2];
            magicPacket[i * 6 + 3] = macAddressBytes[3];
            magicPacket[i * 6 + 4] = macAddressBytes[4];
            magicPacket[i * 6 + 5] = macAddressBytes[5];
        }
        WakeOnLan.executeMagicPacket(broadAddress, 7010, magicPacket);
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#createMagicPacket(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCreateMagicPacket_String() {
        String macAddress = "AD:23:30:56:78:CE";
        byte[] magicPacket = WakeOnLan.createMagicPacket(macAddress);
        for (int i = 0; i < 6; i++) {
            assertEquals((byte)0xff, magicPacket[i]);
        }
        for (int i = 1; i < 17; i++) {
            assertEquals((byte)0xad, magicPacket[i * 6]);
            assertEquals((byte)0x23, magicPacket[i * 6 + 1]);
            assertEquals((byte)0x30, magicPacket[i * 6 + 2]);
            assertEquals((byte)0x56, magicPacket[i * 6 + 3]);
            assertEquals((byte)0x78, magicPacket[i * 6 + 4]);
            assertEquals((byte)0xce, magicPacket[i * 6 + 5]);
        }
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#createMagicPacket(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCreateMagicPacket_StringString() {
        String macAddress = "AD}23}30}56}78}CE";
        byte[] magicPacket = WakeOnLan.createMagicPacket(macAddress, "}");
        for (int i = 0; i < 6; i++) {
            assertEquals((byte)0xff, magicPacket[i]);
        }
        for (int i = 1; i < 17; i++) {
            assertEquals((byte)0xad, magicPacket[i * 6]);
            assertEquals((byte)0x23, magicPacket[i * 6 + 1]);
            assertEquals((byte)0x30, magicPacket[i * 6 + 2]);
            assertEquals((byte)0x56, magicPacket[i * 6 + 3]);
            assertEquals((byte)0x78, magicPacket[i * 6 + 4]);
            assertEquals((byte)0xce, magicPacket[i * 6 + 5]);
        }
    }

    /**
     * {@link jp.hrtdotnet.java.net.WakeOnLan#createMagicPacket(byte[])} ̂߂̃eXgE\bhB
     */
    public void testCreateMagicPacket_ByteArray() {
        byte[] macAddress = new byte[]{(byte)0xAD,(byte)0x23,(byte)0x30,(byte)0x56,(byte)0x78,(byte)0xCE};
        byte[] magicPacket = WakeOnLan.createMagicPacket(macAddress);
        for (int i = 0; i < 6; i++) {
            assertEquals((byte)0xff, magicPacket[i]);
        }
        for (int i = 1; i < 17; i++) {
            assertEquals((byte)0xad, magicPacket[i * 6]);
            assertEquals((byte)0x23, magicPacket[i * 6 + 1]);
            assertEquals((byte)0x30, magicPacket[i * 6 + 2]);
            assertEquals((byte)0x56, magicPacket[i * 6 + 3]);
            assertEquals((byte)0x78, magicPacket[i * 6 + 4]);
            assertEquals((byte)0xce, magicPacket[i * 6 + 5]);
        }
    }

}
