package jp.hrtdotnet.java.util;

import junit.framework.TestCase;

public class BooleanUtilTest extends TestCase {

    private final Boolean TRUE = new Boolean(true);
    private final Boolean FALSE = new Boolean(false);
    
    
    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBoolean(java.lang.String, boolean)} ̂߂̃eXgE\bhB
     */
    public void testToBoolean_StringBoolean() {
        assertEquals(BooleanUtil.toBoolean("true", false), true);
        assertEquals(BooleanUtil.toBoolean("TRUE", false), true);
        assertEquals(BooleanUtil.toBoolean("tRue", false), true);
        assertEquals(BooleanUtil.toBoolean("false", true), false);
        assertEquals(BooleanUtil.toBoolean("FALSE", true), false);
        assertEquals(BooleanUtil.toBoolean("fAlse", true), false);
        assertEquals(BooleanUtil.toBoolean("aaa", true), true);
        assertEquals(BooleanUtil.toBoolean("aaa", false), false);
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBooleanLowerCase(java.lang.String, boolean)} ̂߂̃eXgE\bhB
     */
    public void testToBooleanLowerCase_StringBoolean() {
        assertEquals(BooleanUtil.toBooleanLowerCase("true", false), true);
        assertEquals(BooleanUtil.toBooleanLowerCase("TRUE", false), false);
        assertEquals(BooleanUtil.toBooleanLowerCase("tRue", false), false);
        assertEquals(BooleanUtil.toBooleanLowerCase("false", true), false);
        assertEquals(BooleanUtil.toBooleanLowerCase("FALSE", true), true);
        assertEquals(BooleanUtil.toBooleanLowerCase("fAlse", true), true);
        assertEquals(BooleanUtil.toBooleanLowerCase("aaa", true), true);
        assertEquals(BooleanUtil.toBooleanLowerCase("aaa", false), false);
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBooleanUpperCase(java.lang.String, boolean)} ̂߂̃eXgE\bhB
     */
    public void testToBooleanUpperCase_StringBoolean() {
        assertEquals(BooleanUtil.toBooleanUpperCase("true", false), false);
        assertEquals(BooleanUtil.toBooleanUpperCase("TRUE", false), true);
        assertEquals(BooleanUtil.toBooleanUpperCase("tRue", false), false);
        assertEquals(BooleanUtil.toBooleanUpperCase("false", true), true);
        assertEquals(BooleanUtil.toBooleanUpperCase("FALSE", true), false);
        assertEquals(BooleanUtil.toBooleanUpperCase("fAlse", true), true);
        assertEquals(BooleanUtil.toBooleanUpperCase("aaa", true), true);
        assertEquals(BooleanUtil.toBooleanUpperCase("aaa", false), false);
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBoolean(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToBoolean_String() {
        assertEquals(BooleanUtil.toBoolean("true"), true);
        assertEquals(BooleanUtil.toBoolean("TRUE"), true);
        assertEquals(BooleanUtil.toBoolean("tRue"), true);
        assertEquals(BooleanUtil.toBoolean("false"), false);
        assertEquals(BooleanUtil.toBoolean("FALSE"), false);
        assertEquals(BooleanUtil.toBoolean("fAlse"), false);
        try {
            BooleanUtil.toBoolean("aaa");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBooleanLowerCase(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToBooleanLowerCase_String() {
        assertEquals(BooleanUtil.toBooleanLowerCase("true"), true);
        assertEquals(BooleanUtil.toBooleanLowerCase("false"), false);
        try {
            BooleanUtil.toBooleanLowerCase("TRUE");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBooleanLowerCase("FALSE");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBooleanLowerCase("tRue");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBooleanLowerCase("fAlse");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBooleanUpperCase(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToBooleanUpperCase_String() {
        assertEquals(BooleanUtil.toBooleanUpperCase("TRUE"), true);
        assertEquals(BooleanUtil.toBooleanUpperCase("FALSE"), false);
        try {
            BooleanUtil.toBooleanUpperCase("true");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBooleanUpperCase("false");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBooleanUpperCase("tRue");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBooleanUpperCase("fAlse");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBool(java.lang.String, java.lang.Boolean)} ̂߂̃eXgE\bhB
     */
    public void testToBool_StringBoolean() {
        assertEquals(BooleanUtil.toBool("true", FALSE), TRUE);
        assertEquals(BooleanUtil.toBool("TRUE", FALSE), TRUE);
        assertEquals(BooleanUtil.toBool("tRue", FALSE), TRUE);
        assertEquals(BooleanUtil.toBool("false", TRUE), FALSE);
        assertEquals(BooleanUtil.toBool("FALSE", TRUE), FALSE);
        assertEquals(BooleanUtil.toBool("fAlse", TRUE), FALSE);
        assertEquals(BooleanUtil.toBool("aaa", TRUE), TRUE);
        assertEquals(BooleanUtil.toBool("aaa", FALSE), FALSE);
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBoolLowerCase(java.lang.String, java.lang.Boolean)} ̂߂̃eXgE\bhB
     */
    public void testToBoolLowerCase_StringBoolean() {
        assertEquals(BooleanUtil.toBoolLowerCase("true", FALSE), TRUE);
        assertEquals(BooleanUtil.toBoolLowerCase("TRUE", FALSE), FALSE);
        assertEquals(BooleanUtil.toBoolLowerCase("tRue", FALSE), FALSE);
        assertEquals(BooleanUtil.toBoolLowerCase("false", TRUE), FALSE);
        assertEquals(BooleanUtil.toBoolLowerCase("FALSE", TRUE), TRUE);
        assertEquals(BooleanUtil.toBoolLowerCase("fAlse", TRUE), TRUE);
        assertEquals(BooleanUtil.toBoolLowerCase("aaa", TRUE), TRUE);
        assertEquals(BooleanUtil.toBoolLowerCase("aaa", FALSE), FALSE);
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBoolUpperCase(java.lang.String, java.lang.Boolean)} ̂߂̃eXgE\bhB
     */
    public void testToBoolUpperCase_StringBoolean() {
        assertEquals(BooleanUtil.toBoolUpperCase("true", FALSE), FALSE);
        assertEquals(BooleanUtil.toBoolUpperCase("TRUE", FALSE), TRUE);
        assertEquals(BooleanUtil.toBoolUpperCase("tRue", FALSE), FALSE);
        assertEquals(BooleanUtil.toBoolUpperCase("false", TRUE), TRUE);
        assertEquals(BooleanUtil.toBoolUpperCase("FALSE", TRUE), FALSE);
        assertEquals(BooleanUtil.toBoolUpperCase("fAlse", TRUE), TRUE);
        assertEquals(BooleanUtil.toBoolUpperCase("aaa", TRUE), TRUE);
        assertEquals(BooleanUtil.toBoolUpperCase("aaa", FALSE), FALSE);
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBool(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToBool_String() {
        assertEquals(BooleanUtil.toBool("true"), TRUE);
        assertEquals(BooleanUtil.toBool("TRUE"), TRUE);
        assertEquals(BooleanUtil.toBool("tRue"), TRUE);
        assertEquals(BooleanUtil.toBool("false"), FALSE);
        assertEquals(BooleanUtil.toBool("FALSE"), FALSE);
        assertEquals(BooleanUtil.toBool("fAlse"), FALSE);
        try {
            BooleanUtil.toBool("aaa");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBoolLowerCase(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToBoolLowerCase_String() {
        assertEquals(BooleanUtil.toBoolLowerCase("true"), TRUE);
        assertEquals(BooleanUtil.toBoolLowerCase("false"), FALSE);
        try {
            BooleanUtil.toBoolLowerCase("TRUE");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolLowerCase("tRue");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolLowerCase("FALSE");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolLowerCase("fAlse");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolLowerCase("aaa");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#toBoolUpperCase(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToBoolUpperCase_String() {
        assertEquals(BooleanUtil.toBoolUpperCase("TRUE"), TRUE);
        assertEquals(BooleanUtil.toBoolUpperCase("FALSE"), FALSE);
        try {
            BooleanUtil.toBoolUpperCase("true");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolUpperCase("tRue");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolUpperCase("false");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolUpperCase("fAlse");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            BooleanUtil.toBoolUpperCase("aaa");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#isBoolean(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsBoolean() {
        assertTrue(BooleanUtil.isBoolean("true"));
        assertTrue(BooleanUtil.isBoolean("TRUE"));
        assertTrue(BooleanUtil.isBoolean("tRue"));
        assertTrue(BooleanUtil.isBoolean("false"));
        assertTrue(BooleanUtil.isBoolean("FALSE"));
        assertTrue(BooleanUtil.isBoolean("fAlse"));
        assertFalse(BooleanUtil.isBoolean("aaa"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#isBooleanLowerCase(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsBooleanLowerCase() {
        assertTrue(BooleanUtil.isBooleanLowerCase("true"));
        assertFalse(BooleanUtil.isBooleanLowerCase("TRUE"));
        assertFalse(BooleanUtil.isBooleanLowerCase("tRue"));
        assertTrue(BooleanUtil.isBooleanLowerCase("false"));
        assertFalse(BooleanUtil.isBooleanLowerCase("FALSE"));
        assertFalse(BooleanUtil.isBooleanLowerCase("fAlse"));
        assertFalse(BooleanUtil.isBooleanLowerCase("aaa"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.BooleanUtil#isBooleanUpperCase(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsBooleanUpperCase() {
        assertFalse(BooleanUtil.isBooleanUpperCase("true"));
        assertTrue(BooleanUtil.isBooleanUpperCase("TRUE"));
        assertFalse(BooleanUtil.isBooleanUpperCase("tRue"));
        assertFalse(BooleanUtil.isBooleanUpperCase("false"));
        assertTrue(BooleanUtil.isBooleanUpperCase("FALSE"));
        assertFalse(BooleanUtil.isBooleanUpperCase("fAlse"));
        assertFalse(BooleanUtil.isBooleanUpperCase("aaa"));
    }

}
