/*
 * HMail.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw.util.mail;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.mail.Authenticator;

import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;

import jp.hrtdotnet.fw.common.HMailDefine;
import jp.hrtdotnet.fw.common.HNetCheck;
import jp.hrtdotnet.java.text.FileFormat;

/**
 * [M@\̒ۃNXłB
 *
 * @version 2.1
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.1
 */
public abstract class HSendMail{

    //[T[o
    private HSendMailServerModel serverModel = null;
    private boolean auth = false;
    private String hostName = null;
    private int smtpPort = HMailDefine.SMTP_PORT;
    private String userName = null;
    private String password = null;
    private Authenticator authenticator = null;
    private boolean sslSmtp = false;
    private int sslSmtpPort = HMailDefine.SMTP_PORT_SSL;
    private boolean tls = false;

    //M
    private HMailAddress from = null;
    private List to = null;
    private List cc = null;
    private List bcc = null;
    private List replyTo = null;

    //Me
    private String charset = HMailDefine.SEND_CHARSET;
    private Date sentDate = null;
    private String subject = null;
    private String msg = null;
    private Format msgFormat = null;
    private Object msgFormatParams = null;

    //̑
    private boolean debug = false;
    
    //POPF
    private boolean popBeforeSmtp = false;
    private String popHostName = null;
    private String popUserName = null;
    private String popPassword = null;
    
    /**
     * RXgN^
     */
    public HSendMail() {
    }

    /**
     * RXgN^
     * @param serverModel [T[ȍ
     */
    public HSendMail(HSendMailServerModel serverModel) {
        this.serverModel = serverModel;
    }

    /**
     * [𑗐M܂B
     * @throws HMailException ݒȂǂsőMs
     */
    public abstract void send() throws HMailException ;
    
    /**
     * [AhX̌``FbNs܂B
     * `FbNsꍇAI[o[ChĂB
     * 
     * @param mailAddress [AhX
     * @return trueAȊOfalse
     */
    protected boolean checkMailAddress(String mailAddress) {
        return true;
    }

    /**
     * [T[ȍݒ肵܂B
     * @param mail [
     * @throws HMailException [T[os
     */
    protected void setServerInfo(Email mail) throws HMailException {

        HSendMailServerModel serverModel = getServerModel();
        //zXg
        String hostName = null;
        //[M|[g
        int smtpPort = 0;
        //F؎̃[U
        String userName = null;
        //F؎̃pX[h
        String password = null;
        //F؂sꍇtrueAȊOfalse
        boolean auth = false;
        //F؏IuWFNg
        Authenticator authenticator = null;
        //SSL[MsꍇtrueAȊOfalse
        boolean sslSmtp = false;
        //[M|[g(SSL)
        int sslSmtpPort = 0;
        //TLS
        boolean tls = false;
        //POP before SMTPF؂sꍇtrueAȊOfalse
        boolean popBeforeSmtp = false;
        //POP[T[o
        String popHostName = null;
        //POP[U
        String popUserName = null;
        //POPpX[h
        String popPassword = null;

        //HMailServerModelݒ肳Ăꍇ͂𗘗p
        if (serverModel != null) {
            auth = serverModel.isAuth();
            hostName = serverModel.getHostName();
            smtpPort = serverModel.getSmtpPort();
            userName = serverModel.getUserName();
            password = serverModel.getPassword();
            authenticator = serverModel.getAuthenticator();
            sslSmtp = serverModel.isSslSmtp();
            sslSmtpPort = serverModel.getSslSmtpPort();
            tls = serverModel.isTls();
            popBeforeSmtp = serverModel.isPopBeforeSmtp();
            popHostName = serverModel.getPopHostName();
            popUserName = serverModel.getPopUserName();
            popPassword = serverModel.getPopPassword();
            
        } else {
            auth = isAuth();
            hostName = getHostName();
            smtpPort = getSmtpPort();
            userName = getUserName();
            password = getPassword();
            authenticator = getAuthenticator();
            sslSmtp = isSslSmtp();
            sslSmtpPort = getSslSmtpPort();
            tls = isTls();
            popBeforeSmtp = isPopBeforeSmtp();
            popHostName = getPopHostName();
            popUserName = getPopUserName();
            popPassword = getPopPassword();
        }

        //`FbN
        //zXg
        if (hostName == null) {
            throw new HMailException("Host-name is null.");
        } else if (hostName.length() == 0) {
            throw new HMailException("Host-name is empty-string.");
        }
        //SMTP|[gԍ
        if (HNetCheck.isRangeOfPort(smtpPort) == false) {
            throw new HMailException("SMTP PORT invalid Range.");
        }

        //zXg
        mail.setHostName(hostName);

        //[M|[gԍ
        mail.setSmtpPort(smtpPort);
        mail.setSSL(sslSmtp);
        mail.setSslSmtpPort(String.valueOf(sslSmtpPort));
        mail.setTLS(tls);
        
        
        //SMTPF؂sꍇ
        if (auth) {
            //F؏IuWFNg
            if (authenticator != null) {
                mail.setAuthenticator(authenticator);
            //F؏IuWFNgȂ̓[UƃpX[h
            } else {
                mail.setAuthentication(userName, password);
            }
        }
        
        //POPF
        mail.setPopBeforeSmtp(popBeforeSmtp, popHostName, popUserName, popPassword);
    }

    /**
     * [̑Mݒ肵܂B
     * @param mail [
     * @throws HMailException [Ms
     */
    protected void setSendInfo(Email mail) throws HMailException {

        boolean debug = isDebug();
        List to = getTo();
        List cc = getCc();
        List bcc = getBcc();
        List replyTo = getReplyTo();
        HMailAddress from = getFrom();
        String subject = getSubject();
        String charset = getCharset();
        Date sentDate = getSentDate();

        //DEBUG
        mail.setDebug(debug);
        
        //`FbN
        //R[h
        if (charset == null) {
            throw new HMailException("charset is null.");
        } else if (Charset.isSupported(charset) == false) {
            throw new HMailException("charset is un-supported.");
        }
        
        //FROM
        if (from == null) {
            throw new HMailException("from is null.");
        }
        String fromAddress = from.getAddress();
        String fromName = from.getName();
        if (fromAddress == null) {
            throw new HMailException("from-address is null.");
        } else if (fromAddress.length() == 0) {
            throw new HMailException("from-address is empty-string.");
        }
        
        //TO
        if (to == null || to.size() == 0) {
            throw new HMailException("to is null or empty-string.");
        } else {
            Iterator it = to.iterator();
            while (it.hasNext()) {
                String toAddress = ((HMailAddress) it.next()).getAddress();
                if (toAddress == null) {
                    throw new HMailException("to-address is null.");
                } else if (toAddress.length() == 0) {
                    throw new HMailException("to-address is empty-string.");
                } else if (checkMailAddress(toAddress) == false) {
                    throw new HMailException("to-address is invalid-format.");
                }
            }
        }

        //cc
        if (cc != null && cc.size() != 0) {
            Iterator it = cc.iterator();
            while (it.hasNext()) {
                String ccAddress = ((HMailAddress) it.next()).getAddress();
                if (ccAddress == null) {
                    throw new HMailException("cc-address is null.");
                } else if (ccAddress.length() == 0) {
                    throw new HMailException("cc-address is empty-string.");
                } else if (checkMailAddress(ccAddress) == false) {
                    throw new HMailException("cc-address is invalid-format.");
                }
            }
        }
        
        //bcc
        if (bcc != null && bcc.size() != 0) {
            Iterator it = bcc.iterator();
            while (it.hasNext()) {
                String bccAddress = ((HMailAddress) it.next()).getAddress();
                if (bccAddress == null) {
                    throw new HMailException("bcc-address is null.");
                } else if (bccAddress.length() == 0) {
                    throw new HMailException("bcc-address is empty-string.");
                } else if (checkMailAddress(bccAddress) == false) {
                    throw new HMailException("bcc-address is invalid-format.");
                }
            }
        }

        //ReplyTo
        if (replyTo != null && replyTo.size() != 0) {
            Iterator it = replyTo.iterator();
            while (it.hasNext()) {
                String replyToAddress = ((HMailAddress) it.next()).getAddress();
                if (replyToAddress == null) {
                    throw new HMailException("ReplyTo-address is null.");
                } else if (replyToAddress.length() == 0) {
                    throw new HMailException("ReplyTo-address is empty-string.");
                } else if (checkMailAddress(replyToAddress) == false) {
                    throw new HMailException("ReplyTo-address is invalid-format.");
                }
            }
        }
        
        //ݒ
        //R[h
        mail.setCharset(charset);

        //M
        if (sentDate != null) {
            mail.setSentDate(sentDate);
        } else {
            mail.setSentDate(Calendar.getInstance().getTime());
        }
        
        //^Cg
        if (subject != null) {
            mail.setSubject(subject);
        } else {
            mail.setSubject("");
        }
        
        //FROM
        try {
            if (fromName != null) {
                mail.setFrom(fromAddress, fromName);
            } else {
                mail.setFrom(fromAddress);
            }
        } catch (EmailException e) {
            throw new HMailException(e);
        }

        //TO
        Iterator it = to.iterator();
        while (it.hasNext()) {
            HMailAddress address = (HMailAddress) it.next();
            String addr = address.getAddress();
            String name = address.getName();
            try {
                if (name != null) {
                    mail.addTo(addr, name);
                } else {
                    mail.addTo(addr);
                }
            } catch (EmailException e) {
                throw new HMailException(e);
            }
        }

        //Cc
        if (cc != null && cc.size() != 0) {
            it = cc.iterator();
            while (it.hasNext()) {
                HMailAddress address = (HMailAddress) it.next();
                String addr = address.getAddress();
                String name = address.getName();
                try {
                    if (name != null) {
                        mail.addCc(addr, name);
                    } else {
                        mail.addCc(addr);
                    }
                } catch (EmailException e) {
                    throw new HMailException(e);
                }
            }
        }

        //Bcc
        if (bcc != null && bcc.size() != 0) {
            it = bcc.iterator();
            while (it.hasNext()) {
                HMailAddress address = (HMailAddress) it.next();
                String addr = address.getAddress();
                String name = address.getName();
                try {
                    if (name != null) {
                        mail.addBcc(addr, name);
                    } else {
                        mail.addBcc(addr);
                    }
                } catch (EmailException e) {
                    throw new HMailException(e);
                }
            }
        }

        //ReplyTo
        if (replyTo != null && replyTo.size() != 0) {
            it = replyTo.iterator();
            while (it.hasNext()) {
                HMailAddress address = (HMailAddress) it.next();
                String addr = address.getAddress();
                String name = address.getName();
                try {
                    if (name != null) {
                        mail.addReplyTo(addr, name);
                    } else {
                        mail.addReplyTo(addr);
                    }
                } catch (EmailException e) {
                    throw new HMailException(e);
                }
            }
        }
    }
    
    
    /**
     * [T[o擾܂B
     * @return model [T[o
     */
    public HSendMailServerModel getServerModel() {
        return serverModel;
    }

    /**
     * [T[oݒ肵܂B
     * @param model [T[o
     */
    public void setServerModel(HSendMailServerModel serverModel) {
        this.serverModel = serverModel;
    }

    /**
     * F؃tO擾܂B
     * F؂sꍇtrueAȊOfalsełB
     * @return auth F؃tO
     */
    public boolean isAuth() {
        return auth;
    }

    /**
     * F؃tOݒ肵܂B
     * F؂sꍇtrueAȊOfalsełB
     * @param auth F؃tO
     */
    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    /**
     * [T[õzXg擾܂B
     * @return [T[õzXg
     */
    public String getHostName() {
        return hostName;
    }

    /**
     * [T[õzXgݒ肵܂B
     * @param hostName [T[õzXg
     * @throws NullPointerException hostNamenull
     * @throws IllegalArgumentException hostName󕶎
     */
    public void setHostName(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("Host-name is null.");
        } else if (hostName.length() == 0) {
            throw new IllegalArgumentException("Host-name is empty.");
        }
        this.hostName = hostName;
    }

    /**
     * [M|[gԍ擾܂B
     * @return [M|[gԍ
     */
    public int getSmtpPort() {
        return smtpPort;
    }

    /**
     * [M|[gԍݒ肵܂B
     * @param smtpPort [M|[gԍ
     * @throws IllegalArgumentException smtpPort0ȉw
     */
    public void setSmtpPort(int smtpPort) {
        //SMTP|[gԍ
        if (HNetCheck.isRangeOfPort(smtpPort) == false) {
            throw new IllegalArgumentException("SMTP PORT invalid Range.");
        }
        this.smtpPort = smtpPort;
    }

    /**
     * F؃[U擾܂B
     * @return userName F؃[U
     */
    public String getUserName() {
        return userName;
    }

    /**
     * F؃[Uݒ肵܂B
     * @param userName F؃[U
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * F؃[UpX[h擾܂B
     * @return password F؃[UpX[h
     */
    public String getPassword() {
        return password;
    }

    /**
     * F؃[UpX[hݒ肵܂B
     * @param password F؃[UpX[h
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * F؏擾܂B
     * @return authenticator F؏
     */
    public Authenticator getAuthenticator() {
        return authenticator;
    }

    /**
     * F؏ݒ肵܂B
     * @param authenticator F؏
     */
    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    /**
     * SSL[MtO擾܂B
     * sꍇtrueAȊOfalsełB
     * @return ssl sꍇtrueAȊOfalse
     */
    public boolean isSslSmtp() {
        return sslSmtp;
    }

    /**
     * SSL[MtOݒ肵܂B
     * sꍇtrueAȊOfalsełB
     * @param sslSmtp SSL[MtO
     */
    public void setSslSmtp(boolean sslSmtp) {
        this.sslSmtp = sslSmtp;
    }

    /**
     * [M|[gԍ(SSL)擾܂B
     * @return sslSmtpPort [M|[gԍ(SSL)
     */
    public int getSslSmtpPort() {
        return sslSmtpPort;
    }

    /**
     * [M|[gԍ(SSL)ݒ肵܂B
     * @param sslSmtpPort [M|[gԍ(SSL)
     */
    public void setSslSmtpPort(int sslSmtpPort) {
        if (HNetCheck.isRangeOfPort(sslSmtpPort) == false) {
            throw new IllegalArgumentException("SMTP(SSL) PORT invalid Range.");
        }
        this.sslSmtpPort = sslSmtpPort;
    }

    /**
     * TLStO擾܂B
     * TLS𗘗pꍇtrueAȊOfalsełB
     * @return tls TLStO
     */
    public boolean isTls() {
        return tls;
    }

    /**
     * TLStOݒ肵܂B
     * TLS𗘗pꍇtrueAȊOfalsełB
     * @param tls TLStO
     */
    public void setTls(boolean tls) {
        this.tls = tls;
    }

    /**
     * FROM擾܂B
     * @return FROM
     */
    public HMailAddress getFrom() {
        return this.from;
    }

    /**
     * FROMݒ肵܂B
     * @param fromAddress FROMAhX
     * @param fromName FROM
     * @throws NullPointerException fromAddressnull
     * @throws IllegalArgumentException fromAddress󕶎
     */
    public void setFrom(String fromAddress, String fromName) {
        if (fromAddress == null) {
            throw new NullPointerException("fromAddress is null.");
        } else if (fromAddress.length() == 0) {
            throw new IllegalArgumentException("fromAddress is empty-string.");
        }
        this.from = new HMailAddress();
        this.from.setAddress(fromAddress);
        this.from.setName(fromName);
    }

    /**
     * FROMݒ肵܂B
     * @param fromAddress FROMAhX
     * @throws NullPointerException fromAddressnull
     * @throws IllegalArgumentException fromAddress󕶎
     */
    public void setFrom(String fromAddress) {
        setFrom(fromAddress, null);
    }

    /**
     * TO擾܂B
     * @return TO
     */
    public List getTo() {
        return to;
    }

    /**
     * CC擾܂B
     * @return CC
     */
    public List getCc() {
        return cc;
    }

    /**
     * BCC擾܂B
     * @return BCC
     */
    public List getBcc() {
        return bcc;
    }

    /**
     * TOݒ肵܂B
     * @param toAddress TOAhX
     * @throws IllegalArgumentException toAddress̃[AhX̌`s
     */
    public void setTo(List toAddress) {
        setTo(toAddress, null);
    }

    /**
     * TOݒ肵܂B
     * @param toAddress TOAhX
     * @throws IllegalArgumentException toAddress̃[AhX̌`s
     */
    public void setTo(String toAddress) {
        setTo(toAddress, null);
    }

    /**
     * TOݒ肵܂B
     * @param toAddress TOAhX
     * @throws IllegalArgumentException toAddress̃[AhX̌`s
     */
    public void setTo(String[] toAddress) {
        setTo(toAddress, null);
    }

    /**
     * TOݒ肵܂B
     * @param toAddress TOAhX
     * @param toName TO\
     * @throws IllegalArgumentException toAddresstoName̗vfsvA
     *                                  toAddress̃[AhX̌`s
     */
    public void setTo(List toAddress, List toName) {
        if (this.to != null) {
            this.to.clear();
        }
        this.to = getAddress(toAddress, toName);
    }

    /**
     * TOݒ肵܂B
     * @param toAddress TOAhX
     * @param toName TO\
     * @throws IllegalArgumentException toAddress̃[AhX̌`s
     */
    public void setTo(String toAddress, String toName) {
        if (this.to != null) {
            this.to.clear();
        }
        this.to = getAddress(toAddress, toName);
    }

    /**
     * TOݒ肵܂B
     * @param toAddress TOAhX
     * @param toName TO\
     * @throws IllegalArgumentException toAddresstoName̗vfsvA
     *                                  toAddress̃[AhX̌`s
     */
    public void setTo(String[] toAddress, String[] toName) {
        if (this.to != null) {
            this.to.clear();
        }
        this.to = getAddress(toAddress, toName);
    }

    /**
     * CCݒ肵܂B
     * @param ccAddress CCAhX
     * @throws IllegalArgumentException ccAddress̃[AhX̌`s
     */
    public void setCc(List ccAddress) {
        setCc(ccAddress, null);
    }

    /**
     * CCݒ肵܂B
     * @param ccAddress CCAhX
     * @throws IllegalArgumentException ccAddress̃[AhX̌`s
     */
    public void setCc(String ccAddress) {
        setCc(ccAddress, null);
    }

    /**
     * CCݒ肵܂B
     * @param ccAddress CCAhX
     * @throws IllegalArgumentException ccAddress̃[AhX̌`s
     */
    public void setCc(String[] ccAddress) {
        setCc(ccAddress, null);
    }

    /**
     * CCݒ肵܂B
     * @param ccAddress CCAhX
     * @param ccName CC\
     * @throws NullPointerException ccAddressnull
     * @throws IllegalArgumentException ccAddressccName̗vfsvA
     *                                  ccAddress̃[AhX̌`s
     */
    public void setCc(List ccAddress, List ccName) {
        if (this.cc != null) {
            this.cc.clear();
        }
        this.cc = getAddress(ccAddress, ccName);
    }

    /**
     * CCݒ肵܂B
     * @param ccAddress CCAhX
     * @param ccName CC\
     * @throws IllegalArgumentException ccAddress̃[AhX̌`s
     */
    public void setCc(String ccAddress, String ccName) {
        if (this.cc != null) {
            this.cc.clear();
        }
        this.cc = getAddress(ccAddress, ccName);
    }

    /**
     * CCݒ肵܂B
     * @param ccAddress CCAhX
     * @param ccName CC\
     * @throws IllegalArgumentException ccAddressccName̗vfsvA
     *                                  ccAddress̃[AhX̌`s
     */
    public void setCc(String[] ccAddress, String[] ccName) {
        if (this.cc != null) {
            this.cc.clear();
        }
        this.cc = getAddress(ccAddress, ccName);
    }

    /**
     * BCCݒ肵܂B
     * @param bcc BCCAhX
     * @throws IllegalArgumentException bccAddress̃[AhX̌`s
     */
    public void setBcc(List bcc) {
        setBcc(bcc, null);
    }

    /**
     * BCCݒ肵܂B
     * @param bcc BCCAhX
     * @throws IllegalArgumentException  bccAddress̃[AhX̌`s
     */
    public void setBcc(String bcc) {
        setBcc(bcc, null);
    }

    /**
     * BCCݒ肵܂B
     * @param bcc BCCAhX
     * @throws IllegalArgumentException bccAddress̃[AhX̌`s
     */
    public void setBcc(String[] bcc) {
        setBcc(bcc, null);
    }

    /**
     * BCCݒ肵܂B
     * @param bccAddress BCCAhX
     * @param bccName BCC\
     * @throws IllegalArgumentException bccAddressbccName̗vfsvA
     *                                  bccAddress̃[AhX̌`s
      */
    public void setBcc(List bccAddress, List bccName) {
        if (this.bcc != null) {
            this.bcc.clear();
        }
        this.bcc = getAddress(bccAddress, bccName);
    }

    /**
     * BCCݒ肵܂B
     * @param bccAddress BCCAhX
     * @param bccName BCC\
     * @throws IllegalArgumentException  bccAddress̃[AhX̌`s
     */
    public void setBcc(String bccAddress, String bccName) {
        if (this.bcc != null) {
            this.bcc.clear();
        }
        this.bcc = getAddress(bccAddress, bccName);
    }

    /**
     * BCCݒ肵܂B
     * @param bccAddress BCCAhX
     * @param bccName BCC\
     * @throws NullPointerException bccAddressnull
     * @throws IllegalArgumentException bccAddress̗vf0A
     *                                  bccAddressbccName̗vfsvA
     *                                  bccAddress̃[AhX̌`s
     */
    public void setBcc(String[] bccAddress, String[] bccName) {
        this.bcc = getAddress(bccAddress, bccName);
    }

    /**
     * [AhXIuWFNg擾܂B
     * @param srcAddress [AhX
     * @param srcName \
     * @return [AhXIuWFNg
     */
    protected List getAddress(String srcAddress, String srcName) {
        if (srcAddress == null) {
            return new Vector();
        } else if (srcAddress.length() == 0) {
            return new Vector();
        }
        String[] srcAddressArray = new String[]{srcAddress};
        String[] srcNameArray = null;
        if (srcName != null) {
            srcNameArray = new String[]{srcName};
        }
        return getAddress(srcAddressArray, srcNameArray);
    }

    /**
     * [AhXIuWFNg擾܂B
     * @param srcAddress [AhX
     * @param srcName \
     * @return [AhXIuWFNg
     * @throws IllegalArgumentException srcAddresssrcName̗vfsvA
     *                                  srcAddress̃[AhX̌`s
     */
    protected List getAddress(List srcAddress, List srcName) {
        if (srcAddress == null) {
            return new Vector();
        } else if (srcAddress.size() == 0) {
            return new Vector();
        }
        String[] srcAddressArray = (String[])srcAddress.toArray(new String[0]);
        String[] srcNameArray = null;
        if (srcName != null) {
            srcNameArray = (String[])srcName.toArray(new String[0]);
        }
        return getAddress(srcAddressArray, srcNameArray);
    }

    /**
     * [AhXIuWFNg擾܂B
     * @param srcAddress [AhX
     * @param srcName \
     * @return [AhXIuWFNg
     * @throws IllegalArgumentException srcAddresssrcName̗vfsvA
     *                                  srcAddress̃[AhX̌`s
     */
    protected List getAddress(String[] srcAddress, String[] srcName) {
        
        if (srcAddress == null) {
            return new Vector();
        } else if (srcAddress.length == 0) {
            return new Vector();
        }

        List retAddress = new Vector();

        //M\ݒ肷ꍇ̓AhXƐvĂ邱Ƃ`FbN
        if (srcName != null) {
            if (srcAddress.length != srcName.length) {
                throw new IllegalArgumentException("Address-length != Name-length.");
            }
        }
        
        for (int i = 0; i < srcAddress.length; i++) {
            //AhX̃`FbN
            if (srcAddress[i] == null) {
                
            } else if (srcAddress[i].length() == 0) {
                
            } else if (checkMailAddress(srcAddress[i]) == false) {
                throw new IllegalArgumentException("Address is invalid format.");
            }
            HMailAddress address = new HMailAddress();
            address.setAddress(srcAddress[i]);
            if (srcName != null) {
                address.setName(srcName[i]);
            }
            retAddress.add(address);
        }
        return retAddress;
    }

    /**
     * [̃TuWFNg擾܂B
     * @return [TuWFNg
     */
    public String getSubject() {
        return subject;
    }

    /**
     * [̃TuWFNgݒ肵܂B
     * @param subject [TuWFNg
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    /**
     * [̃bZ[W擾܂B
     * @return [bZ[W
     */
    public String getMsg() {
        return msg;
    }

    /**
     * [̃bZ[Wݒ肵܂B
     * @param msg [bZ[W
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * [̃bZ[Wݒ肵܂B
     * bZ[W̃tH[}bg͊Ot@Cɒ`܂B
     * @param file tH[}bg̃t@C
     * @param fileCharsetName t@C̕R[h
     * @param params tH[}bg̈
     * @throws UnsupportedEncodingException t@C̕R[hT|[gĂȂꍇ
     * @throws FileNotFoundException t@C݂Ȃꍇ
     * @throws IOException t@CIOG[
     * @throws NullPointerException null
     * @throws IllegalArgumentException 󕶎
     */
    public void setMsg(File file, String fileCharsetName, Object[] params) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        } else if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        } else if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        FileFormat format = new FileFormat(file, fileCharsetName);
        this.msg = format.format(params);
    }

    /**
     * [̃bZ[Wݒ肵܂B
     * bZ[W̃tH[}bg͊Ot@Cɒ`܂B
     * @param file tH[}bg̃t@C
     * @param fileCharsetName t@C̕R[h
     * @param formatLineSeparator bZ[Wϊ̉sR[h
     * @param params tH[}bg̈
     * @throws UnsupportedEncodingException t@C̕R[hT|[gĂȂꍇ
     * @throws FileNotFoundException t@C݂Ȃꍇ
     * @throws IOException t@CIOG[
     * @throws NullPointerException null
     * @throws IllegalArgumentException 󕶎
     */
    public void setMsg(File file, String fileCharsetName, String formatLineSeparator, Object[] params)
            throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        } else if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        } else if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        } else if (formatLineSeparator == null) {
            throw new NullPointerException("format-line-separator is null.");
        } else if (formatLineSeparator.length() == 0) {
            throw new IllegalArgumentException("format-line-separator is empty-string.");
        }
        FileFormat format = new FileFormat(file, fileCharsetName, formatLineSeparator);
        this.msg = format.format(params);
    }

    /**
     * [̃bZ[W̃bZ[Wݒ肵܂B
     * @param format tH[}bg
     * @param params tH[}bg̈
     * @throws NullPointerException formatnull
     */
    public void setMsg(Format format, Object[] params) {
        if (format == null) {
            throw new NullPointerException("format is null.");
        }
        this.msg = format.format(params);
    }    
    
    /**
     * [̃bZ[W̃tH[}bgݒ肵܂B
     * bZ[W̃tH[}bg͊Ot@Cɒ`܂B
     * @param file tH[}bg̃t@C
     * @param fileCharsetName t@C̕R[h
     * @throws UnsupportedEncodingException t@C̕R[hT|[gĂȂꍇ
     * @throws FileNotFoundException t@C݂Ȃꍇ
     * @throws IOException t@CIOG[
     * @throws NullPointerException null
     * @throws IllegalArgumentException 󕶎
     */
    public void setMsgFormat(File file, String fileCharsetName)
            throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        } else if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        } else if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        this.msgFormat = new FileFormat(file, fileCharsetName);
    }

    /**
     * [̃bZ[W̃tH[}bgݒ肵܂B
     * bZ[W̃tH[}bg͊Ot@Cɒ`܂B
     * @param file tH[}bg̃t@C
     * @param fileCharsetName t@C̕R[h
     * @param formatLineSeparator bZ[Wϊ̉sR[h
     * @throws UnsupportedEncodingException t@C̕R[hT|[gĂȂꍇ
     * @throws FileNotFoundException t@C݂Ȃꍇ
     * @throws IOException t@CIOG[
     * @throws NullPointerException null
     * @throws IllegalArgumentException 󕶎
     */
    public void setMsgFormat(File file, String fileCharsetName, String formatLineSeparator)
            throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        } else if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        } else if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        } else if (formatLineSeparator == null) {
            throw new NullPointerException("format-line-separator is null.");
        } else if (formatLineSeparator.length() == 0) {
            throw new IllegalArgumentException("format-line-separator is empty-string.");
        }
        this.msgFormat = new FileFormat(file, fileCharsetName, formatLineSeparator);
    }

    /**
     * [̃bZ[W̃tH[}bgݒ肵܂B
     * @param format tH[}bg
     */
    public void setMsgFormat(Format format) {
        this.msgFormat = format;
    }    
    
    /**
     * [bZ[W̃tH[}bg擾܂B
     * @return [bZ[W̃tH[}bg
     */
    public Format getMsgFormat() {
        return msgFormat;
    }

    /**
     * [bZ[W̃tH[}bg̈ݒ肵܂B
     * @param msgFormatParams [bZ[W̃tH[}bg̈
     */
    public void setMsgFormatParams(Object msgFormatParams) {
        this.msgFormatParams = msgFormatParams;
    }

    /**
     * [bZ[W̃tH[}bg̈擾܂B
     * @return [bZ[W̃tH[}bg̈
     */
    public Object getMsgFormatParams() {
        return msgFormatParams;
    }

    /**
     * [̕R[h擾܂B
     * @return charset [̕R[h
     */
    public String getCharset() {
        return charset;
    }

    /**
     * [̕R[hݒ肵܂B
     * @param charset [̕R[h
     */
    public void setCharset(String charset) {
        this.charset = charset;
    }

    /**
     * DEBUG[h̗L擾܂B
     * @return debug DEBUG[h̗L
     */
    public boolean isDebug() {
        return debug;
    }

    /**
     * DEBUG[h̗Lݒ肵܂B
     * @param debug DEBUG[h̗L
     */
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /**
     * ReplyTo擾܂B
     * @return ReplyTo
     */
    public List getReplyTo() {
        return replyTo;
    }

    
    /**
     * ReplyToݒ肵܂B
     * @param replyToAddress ReplyToAhX
     * @throws IllegalArgumentException replyToAddress̃[AhX̌`s
     */
    public void setReplyTo(List replyToAddress) {
        setReplyTo(replyToAddress, null);
    }

    /**
     * ReplyToݒ肵܂B
     * @param replyToAddress ReplyToAhX
     * @throws IllegalArgumentException replyToAddress̃[AhX̌`s
     */
    public void setReplyTo(String replyToAddress) {
        setReplyTo(replyToAddress, null);
    }

    /**
     * ReplyToݒ肵܂B
     * @param replyToAddress ReplyToAhX
     * @throws IllegalArgumentException replyToAddress̃[AhX̌`s
     */
    public void setReplyTo(String[] replyToAddress) {
        setReplyTo(replyToAddress, null);
    }

    /**
     * ReplyToݒ肵܂B
     * @param replyToAddress ReplyToAhX
     * @param replyToName ReplyTo\
     * @throws IllegalArgumentException replyToAddressreplyToName̗vfsvA
     *                                  replyToAddress̃[AhX̌`s
     */
    public void setReplyTo(List replyToAddress, List replyToName) {
        if (this.replyTo != null) {
            this.replyTo.clear();
        }
        this.replyTo = getAddress(replyToAddress, replyToName);
    }

    /**
     * ReplyToݒ肵܂B
     * @param replyToAddress ReplyToAhX
     * @param replyToName ReplyTo\
     * @throws IllegalArgumentException replyToAddress̃[AhX̌`s
     */
    public void setReplyTo(String replyToAddress, String replyToName) {
        if (this.replyTo != null) {
            this.replyTo.clear();
        }
        this.replyTo = getAddress(replyToAddress, replyToName);
    }

    /**
     * ReplyToݒ肵܂B
     * @param replyToAddress ReplyToAhX
     * @param replyToName ReplyTo\
     * @throws IllegalArgumentException replyToAddressreplyToName̗vfsvA
     *                                  replyToAddress̃[AhX̌`s
     */
    public void setReplyTo(String[] replyToAddress, String[] replyToName) {
        if (this.replyTo != null) {
            this.replyTo.clear();
        }
        this.replyTo = getAddress(replyToAddress, replyToName);
    }

    /**
     * [̑M擾܂B
     * @return sendDate M
     */
    public Date getSentDate() {
        return sentDate;
    }

    /**
     * [̑Mݒ肵܂B
     * @param sentDate M
     */
    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    /**
     * POP before SMTPF؂̃tO擾܂B
     * @return F؂sꍇtrueAȊOfalse
     */
    public boolean isPopBeforeSmtp() {
        return popBeforeSmtp;
    }

    /**
     * POP before SMTPF؂̃tOݒ肵܂B
     * F؂sꍇtrueAȊOfalsełB
     * @param popBeforeSmtp POP before SMTPF؃tO
     */
    public void setPopBeforeSmtp(boolean popBeforeSmtp) {
        this.popBeforeSmtp = popBeforeSmtp;
    }

    /**
     * POP before SMTPF؂s[T[o擾܂B
     * @return POP[T[o
     */
    public String getPopHostName() {
        return popHostName;
    }

    /**
     * POP before SMTPF؂s[T[oݒ肵܂B
     * @param popHostName POP[T[o
     */
    public void setPopHostName(String popHostName) {
        this.popHostName = popHostName;
    }

    /**
     * POP before SMTPF؂s[U擾܂B
     * @return POP[U
     */
    public String getPopUserName() {
        return popUserName;
    }

    /**
     * POP before SMTPF؂s[Uݒ肵܂B
     * @param popUserName POP[U
     */
    public void setPopUserName(String popUserName) {
        this.popUserName = popUserName;
    }

    /**
     * POP before SMTPF؂spX[h擾܂B
     * @return POPpX[h
     */
    public String getPopPassword() {
        return popPassword;
    }

    /**
     * POP before SMTPF؂spX[hݒ肵܂B
     * @param popPassword POPpX[h
     */
    public void setPopPassword(String popPassword) {
        this.popPassword = popPassword;
    }
}
