/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.accesscontrol.action.ModifyPassword;
import com.clustercontrol.accesscontrol.bean.UserListTableDefine;
import com.clustercontrol.accesscontrol.dialog.ModifyPasswordDialog;
import com.clustercontrol.accesscontrol.view.UserListView;
import com.clustercontrol.util.Messages;

/**
 * アクセス[ユーザ]ビューの「パスワード変更」のアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyPasswordAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction";
	/** ビュー */
	private IViewPart viewPart;
	
    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
	public void init(IViewPart view) {
		this.viewPart = view;
	}

    /**
     * アクセス[ユーザ]ビューの「パスワード変更」が押された場合に、<BR>
     * アクセス[パスワード変更]ダイアログを表示し、パスワードを変更します。
     * <p>
	 * <ol>
	 * <li>アクセス[ユーザ]ビューから選択されているユーザのユーザIDを取得します。</li>
	 * <li>アクセス[パスワード変更]ダイアログを表示します。</li>
	 * <li>アクセス[パスワード変更]ダイアログからパスワードを取得します。</li>
	 * <li>パスワードの変更を行います。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.accesscontrol.dialog.ModifyPasswordDialog
     * @see com.clustercontrol.accesscontrol.view.UserListView
     * @see com.clustercontrol.accesscontrol.action.ModifyPassword#change(String, String)
     */
	public void run(IAction action) {
        // ユーザ一覧より、選択されているユーザのUIDを取得

        UserListView view = (UserListView) this.viewPart
                .getAdapter(UserListView.class);

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        String uid = null;
        if (list != null) {
            uid = (String) list.get(UserListTableDefine.UID);
        }

        if (uid != null) {
            // ダイアログを生成
            ModifyPasswordDialog dialog = 
            	new ModifyPasswordDialog(this.viewPart.getSite().getShell());
            dialog.setUserid(uid);

            // ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
            if (dialog.open() == IDialogConstants.OK_ID) {
                String password = dialog.getPassword();

                if (new ModifyPassword().change(uid, password)) {
                    // 成功報告ダイアログを生成
                	MessageDialog.openInformation(
                			null, 
                			Messages.getString("successful"), 
                			Messages.getString("message.accesscontrol.14"));
                } else {
                    // 失敗報告ダイアログを生成
                	MessageDialog.openError(
                			null, 
                			Messages.getString("failed"), 
                			Messages.getString("message.accesscontrol.15"));
                }

                view.update();
            }
        }
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

	}

}
