/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;

import org.eclipse.jface.viewers.CellEditor;

/**
 * プロパティクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class Property extends PropertyTreeItem implements Serializable {
    /** プロパティ値 */
    protected Object m_Value;

    /** プロパティ定義 */
    protected String m_Editor;

    /** プロパティ定義 */
    protected PropertyDefine m_Define;

    /** プロパティ値変更の可/不可 */
    protected int m_Modify;

    /** プロパティのコピー可/不可 */
    protected int m_Copy;

    /** プロパティの変更値 */
    protected Object m_selectValues[][];
    
    /** プロパティの上限値 **/
    protected int m_UpperBound ;
    
    /** プロパティの下限値 **/
    protected int m_LowerBound ;
    
    /** プロパティの文字数上限値 **/
    protected int m_stringUpperBound;

    /**
     * @param id
     * @param name
     * @param define
     * @since 1.0.0
     */
    public Property(String id, String name, String editor) {
        m_ID = id;
        m_Name = name;
        m_Editor = editor;
        m_Define = null;
        m_Copy = PropertyConstant.COPY_NG;
        m_Modify = PropertyConstant.MODIFY_NG;
    }

    /**
     * @param id
     * @param name
     * @param define
     * @param upper
     * @param lower
     * @since 2.2.0
     */
    public Property(String id, String name, String editor, int upper, int lower) {
        m_ID = id;
        m_Name = name;
        m_Editor = editor;
        m_UpperBound = Integer.valueOf(upper);
        m_LowerBound = Integer.valueOf(lower);
        m_Define = null;
        m_Copy = PropertyConstant.COPY_NG;
        m_Modify = PropertyConstant.MODIFY_NG;
    }
    
    /**
     * @param id
     * @param name
     * @param define
     * @param stringUpper
     * @since 2.2.0
     */
    public Property(String id, String name, String editor, int stringUpper) {
        m_ID = id;
        m_Name = name;
        m_Editor = editor;
        m_stringUpperBound = Integer.valueOf(stringUpper);
        m_Define = null;
        m_Copy = PropertyConstant.COPY_NG;
        m_Modify = PropertyConstant.MODIFY_NG;
    }

    /**
     * プロパティ変更の可/不可取得
     * 
     * @return canModify
     * @since 1.0.0
     */
    public int getModify() {
        return m_Modify;
    }

    /**
     * プロパティ変更の可/不可設定
     * 
     * @param modify
     * @since 1.0.0
     */
    public void setModify(int modify) {
        m_Modify = modify;
    }

    /**
     * プロパティ値取得
     * 
     * @return プロパティ値
     * @since 1.0.0
     */
    public Object getValue() {
        return m_Value;
    }

    /**
     * プロパティ値設定
     * 
     * @param value
     *            プロパティ値
     * @since 1.0.0
     */
    public void setValue(Object value) {
        m_Value = value;
    }

    /**
     * プロパティ定義取得
     * 
     * @return プロパティ定義
     * @since 1.0.0
     */
    public PropertyDefine getDefine() {
        return m_Define;
    }

    /**
     * プロパティ定義設定
     * 
     * @param define
     *            プロパティ定義取得
     * @since 1.0.0
     */
    public void setDefine(PropertyDefine define) {
        m_Define = define;
    }

    /**
     * @return Returns the m_selectValues.
     */
    public Object[][] getSelectValues() {
        return m_selectValues;
    }

    /**
     * @param values
     *            The m_selectValues to set.
     */
    public void setSelectValues(Object[][] values) {
        m_selectValues = values;
    }

    /**
     * @return Returns the m_Copy.
     */
    public int getCopy() {
        return m_Copy;
    }

    /**
     * @param copy
     *            The m_Copy to set.
     */
    public void setCopy(int copy) {
        m_Copy = copy;
    }

    /**
     * @return Returns the m_Editor.
     */
    public String getEditor() {
        return m_Editor;
    }

    /**
     * @param editor
     *            The m_Editor to set.
     */
    public void setEditor(String editor) {
        m_Editor = editor;
    }

    /**
     * プロパティ値文字列取得
     * 
     * @return プロパティ値文字列
     * @since 1.0.0
     */
    public String getValueText() {
        return m_Define.getColumnText(m_Value);
    }

    /**
     * CellEditor取得
     * 
     * @return CellEditor
     * @since 1.0.0
     */
    public CellEditor getCellEditor() {
        return m_Define.getCellEditor();
    }

    /**
     * CellEditor初期化処理
     * 
     * @since 1.0.0
     */
    public void initEditer() {
        m_Define.initEditer();
    }

    /**
     * @return
     * @since 1.0.0
     */
    public Object getModifyValue() {
        return m_Define.getValue(this);
    }

    /**
     * @param value
     * @since 1.0.0
     */
    public void modify(Object value) {
        m_Define.modify(this, value);
    }
    
	/**
	 * プロパティの上限値の取得
	 * 
     * @return
     * @since 2.2.0
     */
    public int getUpperBound() {
		return m_UpperBound;
	}
    
    /**
     * プロパティの上限値の設定
     * 
     * @param value
     * @since 2.2.0
     */
	public void setUpperBound(int value) {
		m_UpperBound = value;
	}
	
	/**
	 * プロパティの下限値の取得
	 * 
     * @return
     * @since 2.2.0
     */
    public int getLowerBound() {
		return m_LowerBound;
	}
    
    /**
     * プロパティの下限値の設定
     * 
     * @param value
     * @since 2.2.0
     */
	public void setLowerBound(int value) {
		m_LowerBound = value;
	}

	/**
	 * プロパティの文字数上限値の取得
	 * 
     * @return
     * @since 2.2.0
     */
	public int getStringUpperValue() {
		return m_stringUpperBound;
	}

    /**
     * プロパティの文字数上限値の設定
     * 
     * @param value
     * @since 2.2.0
     */
	public void setStringUpperValue(int value) {
		m_stringUpperBound = value;
	}
	

}