/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * カレンダ曜日別情報取得クラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetWeekdayInfoProperty {

    /**
     * カレンダ曜日別情報を返します。
     * 
     * @param id
     * @param property
     * @return カレンダ曜日別情報
     */
    public Property getProperty(String id, Integer weekday, Date from, Date to, int mode) {
		CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		
        Property property = null;
        try {
            property = calendar.getWeekdayProperty(id, weekday, from, to, mode, Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
		} catch (NamingException e) {
		}
        return property;
    }
}