/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

/**
 * 正の数値用VerifyListenerクラス
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class PositiveNumberVerifyListener extends NumberVerifyListener {
    
    /**
     * コンストラクタ
     */
    public PositiveNumberVerifyListener(){
    	super();
    }
    
    /**
     * コンストラクタ
     * 
     * @param low 下限
     * @param high 上限
     */
    public PositiveNumberVerifyListener(int low, int high){
    	super(low, high);
    }
    
	/*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.VerifyListener#verifyText(org.eclipse.swt.events.VerifyEvent)
     */
    public void verifyText(VerifyEvent e) {
        
    	//テキストボックスから入力前の文字列を取得
		Text text = (Text)e.getSource();
		StringBuilder input = new StringBuilder(text.getText());
		
        //キー入力以外は有効にする
        if (e.keyCode == 0) {
        	//貼り付けの場合もここに入る
     
        	//文字列追加
        	input.replace(e.start, e.end, e.text);
        } 
        else {
        	//BackspaceやDeleteが押されたときは、有効にする
            if (e.character == SWT.BS || e.character == SWT.DEL) {
            	input.delete(e.start, e.end);
            }
            else{
            	//文字追加
            	input.replace(e.start, e.end, e.text);
            }
        }
        
        //数字以外が入力されたら無効にする
        if (!input.toString().matches("\\d*")) {
        	e.doit = false;
        	return;
        }
        
        //範囲チェック
    	checkRange(e, input.toString());
    }
}