#!/bin/sh
MKDIR_PROC="/bin/mkdir"
CHOWN_PROC="/bin/chown"

##
## 引数格納
##
while [ $# -gt 0 ]
do
  #echo $1
  case $1 in
    -u)
      shift
      user="$1"
      ;;
    -g)
      shift
      group="$1"
      ;;
    -m)
      shift
      mode="-m $1"
      ;;
    *)
      #ディレクトリ名
      dirname=$1
      ;;
  esac

  shift

done

##
##　ユーザ入力チェック
##
if [ ${#user} -eq 0 ] ; then
    echo 'The user is not specified.' 1>&2
    exit 11
fi

##
##　グループ入力チェック
##
if [ ${#group} -eq 0 ] ; then
    echo 'The group is not specified.' 1>&2
    exit 12
fi

##
## mkdirコマンド実行
##
echo "$MKDIR_PROC $mode $dirname"
$MKDIR_PROC $mode $dirname
if [ $? -ne 0 ] ; then
    exit 10
fi

##
## chownコマンド実行
##
if [ ${#user} -ne 0 ] ; then
    ownarg=$user
fi
if [ ${#group} -ne 0 ] ; then
    ownarg=$ownarg:$group
fi
if [ ${#ownarg} -ne 0 ] ; then
    echo "$CHOWN_PROC $ownarg $dirname"
    $CHOWN_PROC $ownarg $dirname
    if [ $? -ne 0 ] ; then
        exit 1
    fi
fi

exit

