#!/bin/bash

#Copyright (C) 2006, 2007 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

echo "Hinemos starting"
echo ""

EXEC_USER=`/usr/bin/whoami`

# check for incorrect user

if [ $EXEC_USER != "hinemos" ]; then 
	echo "";
	echo "ERROR  Hienmos Maneger boot at incorrect user "; 
	echo "";
	exit 1;
fi

. %%hinemos_install_dir%%/hinemos.cfg

# Start up PostgreSQL

${HINEMOS_HOME}/bin/pg_start.sh
echo ""


#Start up OpenLDAP

echo -n "waiting for slapd to start...";
${HINEMOS_HOME}/bin/ldap_start.sh

REVAL=$?
if [ $REVAL -eq 0 ]; then
        echo "done"
        echo "slapd started"
fi
        echo ""

#Start up JBoss

echo -n "waiting for jboss to start";
${HINEMOS_HOME}/bin/jboss_start.sh

REVAL=$?
if [ $REVAL -eq 1 ] ; then
        exit 1
fi

while [ 1 ];
do
        if [ -f ${HINEMOS_HOME}/var/log/jboss.log ]; then

                RUN_COUNT=`grep running ${HINEMOS_HOME}/var/log/jboss.log | wc -l`
                EXCEPTION_COUNT=`grep Exception ${HINEMOS_HOME}/var/log/jboss.log | wc -l`

                while [ 1 ] ;
                do
                        if [ `grep running ${HINEMOS_HOME}/var/log/jboss.log | wc -l` -gt ${RUN_COUNT} ] ; then
                                break;
                        elif [ `grep Exception ${HINEMOS_HOME}/var/log/jboss.log | wc -l` -gt ${EXCEPTION_COUNT} ] ; then
                                echo ""
                                echo "Exception occurred. It may not start normally."
				ecoh "Please check ${HINEMOS_HOME}/var/log/jboss.log ."
                                exit 1
                        fi
                        sleep 2
                        echo -n "."
                done

                echo "done"
                echo ""
                break;
        else
                sleep 2
                echo -n "."
        fi
done

#copy jboss boot.log to /opt/hinemos/var/log/boot.log.XXXX-XX-XX
SDATE=`date +%Y-%m-%d`
cat ${HINEMOS_HOME}/jboss-4.0.3SP1/server/default/log/boot.log >>${HINEMOS_HOME}/var/log/boot.log.${SDATE}

echo "Hinemos started"

