/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.dialog.HistoryFilterDialog;
import com.clustercontrol.jobmanagement.view.JobHistoryView;

/**
 * ジョブ[履歴]ビューの「フィルタ処理」のアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryFilterAction implements IViewActionDelegate {
	/** ビュー */
    protected IViewPart m_view;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /**
     * ジョブ[履歴]ビューの「フィルタ処理」が押された場合に、フィルタ条件に該当する履歴一覧情報を表示します。
     * <p>
	 * <ol>
	 * <li>ジョブ[履歴フィルタ処理]ダイアログを表示します。</li>
	 * <li>ジョブ[履歴]ビューにフィルタ条件を設定します。</li>
	 * <li>ジョブ[履歴]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.view.JobHistoryView
     * @see com.clustercontrol.jobmanagement.dialog.HistoryFilterDialog
     * @see com.clustercontrol.bean.Property
     */
    public void run(IAction action) {
        if (action.isChecked()) { // ボタンが押された場合

            HistoryFilterDialog dialog = new HistoryFilterDialog(PlatformUI
                    .getWorkbench().getActiveWorkbenchWindow().getShell());

            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);

            //ジョブ履歴フィルタダイアログを表示
            if (dialog.open() == IDialogConstants.OK_ID) {
                // ジョブ履歴ビューをフィルタモードで表示
                Property property = dialog.getInputData();
                view.setFilterCondition(property);
                view.update();
            } else {
                action.setChecked(false);
            }
        } else { // ボタンが戻った場合
            // ジョブ履歴ビューを通常モードで表示
            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);
            view.setFilterCondition(null);
            view.update();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}