/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ステータス情報フィルタ用プロパティを取得するクラスです。
 * 
 * マネージャにSessionBean経由でアクセスし、ステータス情報フィルタ用プロパティを取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetStatusFilterProperty {

    /**
     * マネージャにSessionBean経由でアクセスし、ステータス情報フィルタ用プロパティを取得します。
     * 
     * @return ステータス情報フィルタ用プロパティ
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
	 * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getStatusFilterProperty(Locale)
     */
    public Property getProperty() {
        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        Property property = null;
        try {

            property = monitor.getStatusFilterProperty(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return property;
    }
}