/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoUtil;

/**
 * 文字列監視の判定情報を変更する抽象クラスです。
 * <p>
 * 文字列監視を行う各監視管理クラスで継承してください。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
abstract public class ModifyMonitorStringValueType extends ModifyMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( ModifyMonitorStringValueType.class );
	
	/**
	 * 監視情報より文字列監視の判定情報を取得し、変更します。
	 * <p>
	 * <ol>
	 * <li>監視情報より判定情報を削除します。</li>
	 * <li>判定情報を作成し、監視情報に設定します。</li>
	 * </ol>
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean modifyJudgementInfo() throws CreateException, RemoveException, NamingException {
		
		// 文字列監視判定情報を削除
		Collection ct = m_monitor.getMonitorStringValueInfo();
	    if(ct != null && ct.size() > 0){
	        Object[] infoArray = ct.toArray();
	        for(int j = 0; j < infoArray.length; j++){
	        	MonitorStringValueInfoLocal info = (MonitorStringValueInfoLocal)infoArray[j];
	            if(info != null){
	            	info.remove();
	            }
	        }
	    }		
		
		// 文字列監視判定情報を設定
		ArrayList valueList = m_monitorInfo.getJudgementInfo();
		ArrayList<MonitorStringValueInfoLocal> valueLocalList = new ArrayList<MonitorStringValueInfoLocal>();
		
		MonitorStringValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorStringValueInfo)valueList.get(index);
			if(value != null){
				MonitorStringValueInfoLocal local = MonitorStringValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						Integer.valueOf(value.getOrderNo()),
						value.getDescription(),
						Integer.valueOf(value.getProcessType()),
						value.getPattern(),
						Integer.valueOf(value.getPriority()),
						value.getMessageId(),
						value.getMessage(),
						value.getNotifyId(),
						Integer.valueOf(value.getJobRun()),
						value.getJobId(),
						Integer.valueOf(value.getJobInhibitionFlg()),
						Integer.valueOf(value.getJobFailurePriority()),
						ValidConstant.booleanToType(value.isValidFlg())
						);
				valueLocalList.add(local);
			}
		}
		if(valueLocalList != null){
			ct.addAll(valueLocalList);
			m_monitor.setMonitorStringValueInfo(ct);
		}
		
		return true;
	}
}
