/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.util;

import java.util.Properties;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.bean.SnmpSharedTableConstant;
import com.clustercontrol.snmppoller.SnmpSharedTable;

/**
 * SNMPポーリングサービスとのコネクションを管理するクラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpProcConnectionManager {
	
	protected static Log m_log = LogFactory.getLog( SnmpProcConnectionManager.class );
    
	private static SnmpProcConnectionManager m_instance = null;
	private InitialContext m_ctx = null;
	
	/**
	 * このオブジェクトを取得
	 * シングルトン
	 * @return　ConnectionManager コネクションマネージャ
	 */
	public static SnmpProcConnectionManager getConnectionManager() {
		if (m_instance==null) {
			m_instance = new SnmpProcConnectionManager();
		}
		return m_instance;
	}

	private SnmpProcConnectionManager() {
		try {
			String serverName = System.getProperty("jboss.server.name");
			if(serverName.equals("all")){
				Properties properties = new Properties(); 
				properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
				properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
				properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
				
				m_ctx = new InitialContext(properties);
			}
			else{
				m_ctx = new InitialContext();
			}
		} catch (NamingException e) {
			m_log.error("SnmpProcConnectionManager:" + e.getMessage());
		}
	}
	
	/**
	 * SNMP収集値の共有テーブルを取得
	 * 
	 * @return　SnmpSharedTable
	 */
	public synchronized SnmpSharedTable getSnmpSharedTable() throws NamingException {
	    if(m_ctx == null){
			try {
				String serverName = System.getProperty("jboss.server.name");
				if(serverName.equals("all")){
					Properties properties = new Properties(); 
					properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
					properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
					properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
					
					m_ctx = new InitialContext(properties);
				}
				else{
					m_ctx = new InitialContext();
				}
			} catch (NamingException e) {
				m_log.error("getSnmpSharedTable:" + e.getMessage());
				throw e;
			}
		}
		
		try {
			// SNMP収集値の共有テーブルをルックアップ
			SnmpSharedTable table = (SnmpSharedTable)m_ctx.lookup(SnmpSharedTableConstant.JNDI_NAME);
			return table;
		} catch (NamingException e) {
			m_ctx = null;
			
			m_log.error("getSnmpSharedTable:" + e.getMessage());
			throw e;
		}
	}
}
