/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.composite.NodeListComposite;
import com.clustercontrol.repository.composite.action.NodeListSelectionChangedListener;
import com.clustercontrol.repository.view.action.NodeAddAction;
import com.clustercontrol.repository.view.action.NodeDeleteAction;
import com.clustercontrol.repository.view.action.NodeModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ノート一覧ビュークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.repository.view.NodeListView";

    // ----- instance フィールド ----- //

    /** ノード一覧コンポジット */
    private NodeListComposite composite = null;

    /** 検索条件 */
    private Property condition = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     */
    public NodeListView() {
        super();
    }

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.composite = new NodeListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        
        //ポップアップメニュー作成
        createContextMenu();

        // ボタン（アクション）を制御するリスナーを登録        
        this.composite.getTableViewer().addSelectionChangedListener(
        		new NodeListSelectionChangedListener());
        
        this.update();
    }
    
    /**
     * ポップアップメニュー作成
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    /**
     * メニュー項目追加
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem nodeAddAction = (ActionContributionItem) toolbar
                .find(NodeAddAction.ID);
        ActionContributionItem nodeModifyAction = (ActionContributionItem) toolbar
                .find(NodeModifyAction.ID);
        ActionContributionItem nodeDeleteAction = (ActionContributionItem) toolbar
        .find(NodeDeleteAction.ID);

        //ポップアップメニューにアクションを追加
        manager.add(nodeAddAction.getAction());
        manager.add(nodeModifyAction.getAction());
        manager.add(nodeDeleteAction.getAction());
    }

    /**
     * compositeを返します。
     * 
     * @return composite
     */
    public NodeListComposite getComposite() {
        return this.composite;
    }

    /**
     * 検索条件にヒットしたノードの一覧を表示します。
     * <p>
     * 
     * conditionがnullの場合、全ノードを表示します。
     * 
     * @param condition
     *            検索条件
     */
    public void update(Property condition) {
        this.condition = condition;

        this.update();
    }

    /**
     * ビューを更新します。
     * <p>
     * 
     * 検索条件が事前に設定されている場合、その条件にヒットするノードの一覧を 表示します <br>
     * 検索条件が設定されていない場合は、全ノードを表示します。
     */
    public void update() {
        this.composite.update(this.condition);
    }
    
    /**
     * ビューのアクションの有効/無効を設定します。
     * 
     * @param num 選択イベント数
     * @param selection ボタン（アクション）を有効にするための情報
     */
    public void setEnabledAction(int num, ISelection selection) {
    	//ビューアクションの使用可/不可を設定
    	super.setEnabledAction(NodeDeleteAction.ID, selection);
    	super.setEnabledAction(NodeModifyAction.ID, selection);
    	
    	if (num > 0){
    		super.setEnabledAction(NodeDeleteAction.ID, true);
    		super.setEnabledAction(NodeModifyAction.ID, true);
    	} else {
    		super.setEnabledAction(NodeDeleteAction.ID, false);
    		super.setEnabledAction(NodeModifyAction.ID, false);
    	}
    }
}