/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.util.Log;
import org.jfree.xml.generator.SourceCollector;

public class JavaSourceCollector
implements SourceCollector {
    private CollectorFileFilter eff = new CollectorFileFilter("<ignore>", ".java");
    private ArrayList fileList = new ArrayList();
    private ArrayList ignoredPackages;
    private ArrayList ignoredBaseClasses;
    private File startDirectory;
    private String initialPackageName;

    public JavaSourceCollector(File file) {
        this(file, "");
    }

    public JavaSourceCollector(File file, String string) {
        this.startDirectory = file;
        this.initialPackageName = string;
        this.ignoredPackages = new ArrayList();
        this.ignoredBaseClasses = new ArrayList();
    }

    public void addIgnoredPackage(String string) {
        Log.debug(new Log.SimpleMessage("Added IgnPackage: ", string));
        this.ignoredPackages.add(string);
    }

    public void addIgnoredBaseClass(String string) {
        Class clazz = this.loadClass(string);
        if (clazz != null) {
            Log.debug(new Log.SimpleMessage("Added IgnClass: ", string));
            this.ignoredBaseClasses.add(clazz);
        }
    }

    public void addIgnoredBaseClass(Class clazz) {
        this.ignoredBaseClasses.add(clazz);
    }

    protected boolean isIgnoredPackage(String string) {
        for (int i = 0; i < this.ignoredPackages.size(); ++i) {
            String string2 = (String)this.ignoredPackages.get(i);
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnoredBaseClass(Class clazz) {
        for (int i = 0; i < this.ignoredBaseClasses.size(); ++i) {
            Class clazz2 = (Class)this.ignoredBaseClasses.get(i);
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public void collectFiles() {
        this.collectFiles(this.startDirectory, this.initialPackageName);
    }

    protected void collectFiles(File file, String string) {
        File[] fileArray = file.listFiles(this.eff);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.collectFiles(fileArray[i], this.buildJavaName(string, fileArray[i].getName()));
                continue;
            }
            String string2 = fileArray[i].getName();
            String string3 = string2.substring(0, string2.length() - 5);
            String string4 = this.buildJavaName(string, string3);
            if (this.isIgnoredPackage(string4)) {
                Log.debug(new Log.SimpleMessage("Do not process: Ignored: ", string3));
                continue;
            }
            Class clazz = this.loadClass(string4);
            if (clazz == null || this.isIgnoredBaseClass(clazz)) continue;
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                Log.debug(new Log.SimpleMessage("Do not process: Abstract: ", string3));
                continue;
            }
            if (!Modifier.isPublic(clazz.getModifiers())) {
                Log.debug(new Log.SimpleMessage("Do not process: Not public: ", string3));
                continue;
            }
            this.fileList.add(clazz);
        }
    }

    protected Class loadClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            Log.warn(new Log.SimpleMessage("Do not process: Failed to load class:", string));
            return null;
        }
    }

    protected String buildJavaName(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        return string + "." + string2;
    }

    public Class[] getClasses() {
        return this.fileList.toArray(new Class[0]);
    }

    private static class CollectorFileFilter
    extends ExtensionFileFilter
    implements FileFilter {
        public CollectorFileFilter(String string, String string2) {
            super(string, string2);
        }
    }
}

