/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection.util;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.AbstractDetector;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;

public class DetectorUtil {
    public static final String TYPE_MULTICAST = "multicast";
    public static final String TYPE_JNDI = "jndi";
    public static final int DEFAULT_PORT = 2410;
    public static final String DEFAULT_HOST = "localhost";
    private String contextFactory = "org.jnp.interfaces.NamingContextFactory";
    private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
    private String type = "multicast";
    private int port = 2410;
    private String host = "localhost";

    public DetectorUtil() {
    }

    public DetectorUtil(String type) {
        this(type, 2410, DEFAULT_HOST);
    }

    public DetectorUtil(String type, int port) {
        this(type, port, DEFAULT_HOST);
    }

    public DetectorUtil(String type, int port, String host) {
        this.type = type;
        this.port = port;
        this.host = host;
    }

    public void start() {
        try {
            BasicConfigurator.configure();
            Category.getRoot().setLevel(Level.DEBUG);
            Logger log = Logger.getLogger(this.getClass());
            System.setProperty("jboss.identity", String.valueOf(System.currentTimeMillis()));
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            NetworkRegistry registry = NetworkRegistry.getInstance();
            server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
            InvokerLocator locator = new InvokerLocator("socket://localhost");
            Connector connector = new Connector();
            connector.setInvokerLocator(locator.getLocatorURI());
            ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
            server.registerMBean(connector, obj);
            connector.start();
            AbstractDetector detector = null;
            ObjectName objName = null;
            if (this.type.equals(TYPE_MULTICAST)) {
                MulticastDetector mdet = new MulticastDetector();
                mdet.setPort(this.port);
                detector = mdet;
                objName = new ObjectName("remoting:type=Detector,transport=multicast");
            } else if (this.type.equals(TYPE_JNDI)) {
                JNDIDetector jdet = new JNDIDetector();
                jdet.setPort(this.port);
                jdet.setHost(this.host);
                jdet.setContextFactory(this.contextFactory);
                jdet.setURLPackage(this.urlPackage);
                detector = jdet;
                objName = new ObjectName("remoting:type=Detector,transport=jndi");
            }
            server.registerMBean(detector, objName);
            detector.start();
            System.err.println("Starting Detector");
            block2: while (true) {
                Thread.currentThread();
                Thread.sleep(3000L);
                NetworkInstance[] instances = registry.getServers();
                int x = 0;
                while (true) {
                    if (x >= instances.length) continue block2;
                    log.debug(instances[x]);
                    ++x;
                }
                break;
            }
        }
        catch (Exception ex) {
            System.err.println("Error creating and starting DetectorUtil.");
            ex.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        DetectorUtil test = null;
        if (args.length == 1) {
            String type = args[0];
            test = new DetectorUtil(type);
        } else if (args.length == 2) {
            String type = args[0];
            int port = Integer.parseInt(args[1]);
            test = new DetectorUtil(type, port);
        } else if (args.length == 3) {
            String type = args[0];
            int port = Integer.parseInt(args[1]);
            String host = args[2];
            test = new DetectorUtil(type, port, host);
        } else {
            test = new DetectorUtil();
            System.out.println("Using default type (" + test.getTransport() + ") and default port (" + test.getPort() + ") and " + "default host (" + test.getHost() + ")" + "\nCan enter type (multicast, jndi), port, and/or host via command line.");
        }
        test.start();
    }

    private String getHost() {
        return this.host;
    }

    private int getPort() {
        return this.port;
    }

    private String getTransport() {
        return this.type;
    }
}

