/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentThread
extends Thread {
    private static Log log = LogFactory.getLog(AgentThread.class);
    protected RunInstructionInfo m_info = null;
    protected SendQueue m_sendQueue = null;
    protected Properties m_props = null;
    protected Hashtable<String, Date> m_runHistory = null;
    protected int m_interval = 30;
    protected int m_limit_orgmsg = 8192;
    private final String END_MESSAGE_RESEND_INTERVAL = "end.message.resend.interval";
    private final String LIMIT_ORGMSG = "limit.size.orgmsg";

    public AgentThread() {
    }

    public AgentThread(RunInstructionInfo info, SendQueue sendQueue, Hashtable<String, Date> runHistory, Properties props) {
        String limit_orgmsg;
        this.m_props = props;
        this.m_info = info;
        this.m_sendQueue = sendQueue;
        this.m_runHistory = runHistory;
        String interval = this.m_props.getProperty("end.message.resend.interval");
        if (interval != null) {
            try {
                this.m_interval = Integer.parseInt(interval);
            }
            catch (NumberFormatException e) {
                log.error((Object)"end.message.resend.interval", (Throwable)e);
            }
        }
        if ((limit_orgmsg = this.m_props.getProperty("limit.size.orgmsg")) != null) {
            try {
                this.m_limit_orgmsg = Integer.parseInt(limit_orgmsg);
            }
            catch (NumberFormatException e) {
                log.error((Object)"limit.orgmsg", (Throwable)e);
            }
        }
    }

    public void sendDeleteHistory(RunResultInfo info) {
        Date checkDate = new Date();
        int commandType = info.getCommandType();
        while (true) {
            if (RunHistoryUtil.findRunHistory(this.m_info, this.m_runHistory) == null) {
                if (commandType == 0) {
                    info.setCommandType(4);
                } else if (commandType == 1) {
                    info.setCommandType(5);
                }
                break;
            }
            Calendar checkTime = Calendar.getInstance();
            checkTime.setTime(checkDate);
            checkTime.add(13, this.m_interval);
            Date now = new Date();
            if (now.after(checkTime.getTime())) {
                info.setCommandType(commandType);
                this.m_sendQueue.put(info);
                checkDate = new Date();
            }
            try {
                AgentThread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        log.info((Object)("delete history SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
    }
}

