/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.ejb.entity.AccessLockLocal;
import com.clustercontrol.accesscontrol.ejb.entity.AccessLockUtil;

/**
 * アクセスロックを行うファクトリクラス<BR>
 * 
 * 機能単位でDBの更新をロックするためのパラメータを保持します。<BR>
 * 
 * cc_acc_lockテーブルにロックIDが登録されている必要があります。
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class AccessLock {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog(AccessLock.class);
	/** エラーメッセージ */
	protected static String m_message = null;
	
	/** アクセス用ロックID */
	public static final String ACCESS = "ACCESS";
	/** カレンダ用ロックID */
	public static final String CALENDER = "CALENDER";
	/** 一括制御用ロックID */
	public static final String CRUN = "CRUN";
	/** ジョブ管理用ロックID */
	public static final String JOB = "JOB";
	/** 監視管理用ロックID */
	public static final String MONITOR = "MONITOR";
	/** Hinemosエージェント監視用ロックID */
	public static final String MONITOR_AGENT = "MONITOR_AGENT";
	/** PING監視用ロックID */
	public static final String MONITOR_PING = "MONITOR_PING";
	/** サービス・ポート監視用ロックID */
	public static final String MONITOR_PORT = "MONITOR_PORT";
	/** プロセス監視用ロックID */
	public static final String MONITOR_PROCESS = "MONITOR_PROCESS";
	/** SNMP監視用ロックID */
	public static final String MONITOR_SNMP = "MONITOR_SNMP";
	/** SQL用ロックID */
	public static final String MONITOR_SQL = "MONITOR_SQL";
	/** syslog-ng監視用ロックID */
	public static final String MONITOR_SYSLOG = "MONITOR_SYSLOG";
	/** 通知用ロックID */
	public static final String NOTIFY = "NOTIFY";
	/** 性能管理用ロックID */
	public static final String PERFORMANCE = "PERFORMANCE";
	/** リポジトリ用ロックID */
	public static final String REPOSITORY = "REPOSITORY";
	/** 重要度判定用ロックID */
	public static final String PRIORITY_JUDGMENT = "PRIORITY_JUDGMENT";
	/** ログ転送用ロックID */
	public static final String LOG_TRANSFER = "LOG_TRANSFER";
	/** SNMPTRAP用ロックID */
	public static final String MONITOR_SNMPTRAP = "MONITOR_SNMPTRAP";
	/** メンテナンス用ロックID */
	public static final String MAINTENANCE = "MAINTENANCE";
	
	/**
	 * コンストラクタ
	 * 
	 * エラーメッセージをプロパティファイルから取得
	 */
	public AccessLock(){
		if(m_message == null){
			
			//FIXME RuntimeのExceptionが発生する恐れがあるためtry-catchとする
			try {
			    Properties properties = new Properties();
			    String etcdir = System.getProperty("hinemos.manager.etc.dir");
				String propertyFile = etcdir + File.separator + "hinemos.properties";
				// FIXME: forest.propertiesは存在しない
				
				// プロパティファイルからキーと値のリストを読み込みます
				properties.load(new FileInputStream(propertyFile));
				
				m_message = properties.getProperty("lock.timeout.message", ".*The\\serror\\sof\\sthe\\srollback\\sobject\\soccurred.*");

			} catch (Exception e) {
				m_message = ".*The\\serror\\sof\\sthe\\srollback\\sobject\\soccurred.*";
			}
		}
	}
	
    /**
     * アクセスロックを取得します。<BR>
     * 取得できるまで取得をリトライします。
     * 
     * @param id ロックID
     * @return アクセスロック
     */
    public static AccessLockLocal lock(String id) {
    	AccessLockLocal acc = null;
    	while(true){
	    	try {
				acc = AccessLockUtil.getLocalHome().findByLockIdForUpdate(id);
				break;
			} catch (FinderException e) {
				String msg = e.getMessage();
				if(msg != null && msg.matches(m_message)){
					m_log.debug("lock() : Lock Timeout");
				}
				else{
					m_log.debug("lock() : " + e.getMessage());
					break;
				}
			} catch (NamingException e) {
				m_log.debug("lock() : " + e.getMessage());
				break;
			}
    	}
    	return acc;
    }
}
