/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import com.clustercontrol.notify.mail.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * メールテンプレート情報を削除するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class DeleteMailTemplate {

    /**
     * メールテンプレート情報を削除します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @param mailTemplateId 削除対象のメールテンプレートID
	 * @return 削除に成功した場合、<code> true </code>
	 * 
	 * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#deleteMailTemplate(java.lang.String)
     */
    public boolean delete(String mailTemplateId) {
    	
    	MailTemplateController mailTemplate = EjbConnectionManager.getConnectionManager().getMailTemplateController();

        boolean result = false;
        try {
        	result = mailTemplate.deleteMailTemplate(mailTemplateId);
        	return result;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (RemoveException e) {
        } catch (NamingException e) {
        } 
        return false;
    }
}