/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.ejb.session.PriorityController;
import com.clustercontrol.priority.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 重要度判定情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetPriorityJudgment {

    /**
     * 指定した重要度判定情報を取得
     * 
     * @return
     */
    public PriorityJudgmentInfo get() {
    	PriorityJudgmentInfo data = null;
    	
    	PriorityController priority = 
			EjbConnectionManager.getConnectionManager().getPriorityController();

        try {
        	data = priority.getPriorityJudgment();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        }
        return data;
    }
}