/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 一括制御階層情報を取得するクライアント側アクションクラス<BR>
 * 
 * サーバから一括制御階層情報を取得します。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetTree {
	
	/**
	 * 一括制御階層情報を取得します。<BR>
	 * 
	 * @return 一括制御階層情報
	 */
	public TreeItem getTree() {
        CollectiveRunController collectiveRun = 
        	EjbConnectionManager.getConnectionManager().getCollectiveRunController();

		TreeItem item = null;
		try {
		    item = collectiveRun.getTree(Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (FinderException e) {
        } catch (NamingException e) {
        }
		return item;
	}
}
